/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.dita.writer;

import java.io.File;
import java.util.Stack;
import net.edgemind.ibee.dita.exception.DitaException;
import net.edgemind.ibee.dita.items.DitaTopic;

public abstract class SaxDocumentWriter {
    private File outDir;
    private Stack<DitaTopic> topics = new Stack();
    private DitaTopic currentTopic;
    private boolean writeSingleDocument;

    protected abstract void doEnterTopic(DitaTopic var1) throws DitaException;

    protected abstract void doLeaveTopic(DitaTopic var1) throws DitaException;

    public boolean isWriteSingleDocument() {
        return this.writeSingleDocument;
    }

    public void setWriteSingleDocument(boolean writeSingleDocument) {
        this.writeSingleDocument = writeSingleDocument;
    }

    public SaxDocumentWriter(File outDir) {
        this.outDir = outDir;
    }

    public File getOutDir() {
        return this.outDir;
    }

    public void enterTopic(DitaTopic topic) throws DitaException {
        this.topics.add(topic);
        this.currentTopic = topic;
        this.doEnterTopic(topic);
    }

    public void leaveTopic() throws DitaException {
        DitaTopic topicToClose = this.currentTopic;
        this.doLeaveTopic(topicToClose);
        topicToClose.clear();
        this.topics.pop();
        this.currentTopic = this.topics.size() > 0 ? this.topics.peek() : null;
    }
}

