/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.dita.writer.html;

import java.io.File;
import java.util.List;
import net.edgemind.ibee.core.log.LogUtil;
import net.edgemind.ibee.dita.builder.dom.DomDocumentBuilder;
import net.edgemind.ibee.dita.exception.DitaException;
import net.edgemind.ibee.dita.items.DitaTopic;
import net.edgemind.ibee.dita.writer.DomDocumentWriter;
import net.edgemind.ibee.dita.writer.IDitaDocumentWriter;
import net.edgemind.ibee.dita.writer.html.HtmlDomSerializer;
import net.edgemind.ibee.util.file.FileUtil;
import org.w3c.dom.Document;

public class HtmlDomDocumentWriter
extends DomDocumentWriter
implements IDitaDocumentWriter {
    private List<String> cssFiles = null;
    private List<String> jsFiles = null;
    private boolean writeSingleDocument = true;

    public void setCssFiles(List<String> cssFiles) {
        this.cssFiles = cssFiles;
    }

    public void setJsFiles(List<String> jsFiles) {
        this.jsFiles = jsFiles;
    }

    public void writeSingleDocument(boolean writeSingleDocument) {
        this.writeSingleDocument = writeSingleDocument;
    }

    public boolean writeSingleDocument() {
        return this.writeSingleDocument;
    }

    protected DomDocumentBuilder createDocumentBuilder() {
        DomDocumentBuilder builder = new DomDocumentBuilder();
        builder.setCssFiles(this.cssFiles);
        builder.setJsFiles(this.jsFiles);
        builder.writeSingleDocument(this.writeSingleDocument);
        return builder;
    }

    @Override
    protected String getFileName(DitaTopic ditaFile) {
        String url = ditaFile.getUrl();
        url = FileUtil.replaceExtension((String)url, (String)".html");
        return url;
    }

    @Override
    public void writeTopicDocument(DitaTopic topic, File outputFolder) throws DitaException {
        LogUtil.info((String)("Processing '" + topic.getUrl() + "'"));
        this.createDomDocument(topic, outputFolder);
    }

    @Override
    protected void write(Document document, File file) {
        HtmlDomSerializer htmlSerializer = new HtmlDomSerializer();
        htmlSerializer.write(document, file);
    }

    @Override
    public void dispose() throws DitaException {
    }
}

