/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.dita.writer.html;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import net.edgemind.ibee.dita.exception.DitaException;
import net.edgemind.ibee.dita.items.DitaElement;
import net.edgemind.ibee.dita.items.DitaEntry;
import net.edgemind.ibee.dita.items.DitaRow;
import net.edgemind.ibee.dita.items.DitaSection;
import net.edgemind.ibee.dita.items.DitaTBody;
import net.edgemind.ibee.dita.items.DitaTGroup;
import net.edgemind.ibee.dita.items.DitaTable;
import net.edgemind.ibee.dita.items.DitaTitle;
import net.edgemind.ibee.dita.items.DitaTopic;
import net.edgemind.ibee.dita.writer.SaxDocumentWriter;
import net.edgemind.ibee.util.file.FileUtil;
import net.edgemind.ibee.util.xml.XmlUtil;

public class HtmlSaxDocumentWriter
extends SaxDocumentWriter {
    private XMLStreamWriter writer;
    private DitaTopic mainTopic;
    private int indent = 0;
    private boolean standalone = false;

    public HtmlSaxDocumentWriter(File outDir) {
        super(outDir);
    }

    protected File getHtmlFile(DitaTopic topic) {
        String url = topic.getUrl();
        if (url == null) {
            return null;
        }
        File file = new File(url);
        if (!file.isAbsolute()) {
            file = new File(this.getOutDir(), url);
        }
        if (!file.getName().endsWith(".html")) {
            url = FileUtil.replaceExtension((String)file.getAbsolutePath(), (String)".html");
            file = new File(url);
        }
        return file;
    }

    public void setStandalone(boolean standalone) {
        this.standalone = standalone;
    }

    public boolean isStandalone() {
        return this.standalone;
    }

    @Override
    protected void doEnterTopic(DitaTopic topic) throws DitaException {
        if (this.writer == null) {
            File htmlFile = this.getHtmlFile(topic);
            if (htmlFile == null) {
                htmlFile = new File(this.getOutDir(), topic.getTitle() + ".html");
            }
            try {
                this.mainTopic = topic;
                try {
                    this.writer = XmlUtil.createStreamWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(htmlFile), "UTF-8"));
                    this.writer.writeStartDocument();
                    this.openTag("html");
                    this.openTag("head");
                    this.closeTag();
                    this.openTag("body");
                }
                catch (UnsupportedEncodingException | XMLStreamException e) {
                    throw new DitaException(e);
                }
            }
            catch (FileNotFoundException e) {
                throw new DitaException(e);
            }
        }
        try {
            this.openTag("div");
        }
        catch (XMLStreamException e) {
            throw new DitaException(e);
        }
    }

    @Override
    protected void doLeaveTopic(DitaTopic topic) throws DitaException {
        try {
            this.writeElement(topic);
            this.closeTag();
            if (topic == this.mainTopic) {
                this.closeTag();
                this.closeTag();
                this.writer.writeEndDocument();
                this.writer.flush();
            }
        }
        catch (XMLStreamException e) {
            throw new DitaException(e);
        }
    }

    private void writeElement(DitaElement el) throws XMLStreamException {
        if (el instanceof DitaSection) {
            this.writeSection((DitaSection)el);
        } else if (el instanceof DitaTitle) {
            this.writeTitle((DitaTitle)el);
        } else if (el instanceof DitaTable) {
            this.writeTable((DitaTable)el);
        }
        for (DitaElement sub : el.getChildren()) {
            this.writeElement(sub);
        }
    }

    private boolean writeSection(DitaElement section) throws XMLStreamException {
        this.openTag("div");
        this.closeTag();
        return true;
    }

    private boolean writeTitle(DitaTitle title) throws XMLStreamException {
        this.writeTextTag("h2", title.getText());
        return true;
    }

    private boolean writeTable(DitaTable table) throws XMLStreamException {
        DitaTGroup tGroup = table.getFirstGroup();
        if (tGroup == null) {
            return false;
        }
        DitaTBody tBody = tGroup.getBody();
        if (tBody == null) {
            return false;
        }
        this.openTag("table");
        for (DitaRow row : tBody.getRows()) {
            this.openTag("tr");
            for (DitaEntry entry : row.getEntries()) {
                this.writeTextTag("td", entry.getText());
            }
            this.closeTag();
        }
        this.closeTag();
        return false;
    }

    private void writeTextTag(String tag, String content) throws XMLStreamException {
        this.nl();
        this.writer.writeStartElement(tag);
        this.writer.writeCharacters(content);
        this.writer.writeEndElement();
    }

    private void openTag(String tag) throws XMLStreamException {
        this.nl();
        this.writer.writeStartElement(tag);
        ++this.indent;
    }

    private void closeTag() throws XMLStreamException {
        --this.indent;
        this.nl();
        this.writer.writeEndElement();
    }

    private void nl() throws XMLStreamException {
        this.writer.writeCharacters(FileUtil.lineSeparator());
        char[] chars = new char[this.indent];
        int i = 0;
        while (i < this.indent) {
            chars[i] = 32;
            ++i;
        }
        String s = new String(chars);
        this.writer.writeCharacters(s);
    }
}

