/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.dita.writer.word;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.docx4j.dml.wordprocessingDrawing.Inline;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.BinaryPartAbstractImage;
import org.docx4j.wml.Drawing;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.P;
import org.docx4j.wml.R;

public class AddingAnInlineImage {
    public static P createImage(String path, WordprocessingMLPackage pack, P paragraph) throws Exception {
        File file = new File(path);
        byte[] bytes = AddingAnInlineImage.convertImageToByteArray(file);
        return AddingAnInlineImage.addImageToPackage(pack, bytes, paragraph);
    }

    public static P createImage(String path, WordprocessingMLPackage pack, P paragraph, int widthPercent) throws Exception {
        File file = new File(path);
        byte[] bytes = AddingAnInlineImage.convertImageToByteArray(file);
        return AddingAnInlineImage.addImageToPackage(pack, bytes, paragraph, widthPercent);
    }

    private static P addImageToPackage(WordprocessingMLPackage wordMLPackage, byte[] bytes, P paragraph) throws Exception {
        BinaryPartAbstractImage imagePart = BinaryPartAbstractImage.createImagePart((WordprocessingMLPackage)wordMLPackage, (byte[])bytes);
        int docPrId = 1;
        int cNvPrId = 2;
        Inline inline = imagePart.createImageInline("Filename hint", "Alternative text", (long)docPrId, cNvPrId, false);
        return AddingAnInlineImage.addInlineImageToParagraph(inline, paragraph);
    }

    private static P addImageToPackage(WordprocessingMLPackage wordMLPackage, byte[] bytes, P paragraph, int widthPercent) throws Exception {
        BinaryPartAbstractImage imagePart = BinaryPartAbstractImage.createImagePart((WordprocessingMLPackage)wordMLPackage, (byte[])bytes);
        int docPrId = 1;
        int cNvPrId = 2;
        Inline inline = imagePart.createImageInline("Filename hint", "Alternative text", (long)docPrId, cNvPrId, (long)(9500 * widthPercent / 100), false);
        return AddingAnInlineImage.addInlineImageToParagraph(inline, paragraph);
    }

    private static P addInlineImageToParagraph(Inline inline, P paragraph) {
        ObjectFactory factory = new ObjectFactory();
        R run = factory.createR();
        paragraph.getContent().add(run);
        Drawing drawing = factory.createDrawing();
        run.getContent().add(drawing);
        drawing.getAnchorOrInline().add(inline);
        return paragraph;
    }

    private static byte[] convertImageToByteArray(File file) throws FileNotFoundException, IOException {
        FileInputStream is = new FileInputStream(file);
        long length = file.length();
        if (length > Integer.MAX_VALUE) {
            System.out.println("File too large!!");
        }
        byte[] bytes = new byte[(int)length];
        int offset = 0;
        int numRead = 0;
        while (offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0) {
            offset += numRead;
        }
        if (offset < bytes.length) {
            System.out.println("Could not completely read file " + file.getName());
        }
        ((InputStream)is).close();
        return bytes;
    }
}

