/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.dita.writer.word;

import java.util.List;
import org.docx4j.jaxb.Context;
import org.docx4j.model.structure.SectionWrapper;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.WordprocessingML.FooterPart;
import org.docx4j.relationships.Relationship;
import org.docx4j.wml.FldChar;
import org.docx4j.wml.FooterReference;
import org.docx4j.wml.Ftr;
import org.docx4j.wml.HdrFtrRef;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.P;
import org.docx4j.wml.R;
import org.docx4j.wml.STFldCharType;
import org.docx4j.wml.SectPr;
import org.docx4j.wml.Text;

public class AddingPageNrToFooter {
    private WordprocessingMLPackage wordMLPackage;
    private ObjectFactory factory;

    public void addPageNumbers(WordprocessingMLPackage pack) throws Exception {
        this.wordMLPackage = pack;
        this.factory = Context.getWmlObjectFactory();
        Relationship relationship = this.createFooterPart();
        this.createFooterReference(relationship);
    }

    private Relationship createFooterPart() throws InvalidFormatException {
        FooterPart footerPart = new FooterPart();
        footerPart.setPackage((OpcPackage)this.wordMLPackage);
        footerPart.setJaxbElement((Object)this.createFooterWithPageNr());
        return this.wordMLPackage.getMainDocumentPart().addTargetPart((Part)footerPart);
    }

    public Ftr createFooterWithPageNr() {
        Ftr ftr = this.factory.createFtr();
        P paragraph = this.factory.createP();
        this.addFieldBegin(paragraph);
        this.addPageNumberField(paragraph);
        this.addFieldEnd(paragraph);
        ftr.getContent().add(paragraph);
        return ftr;
    }

    private void addPageNumberField(P paragraph) {
        R run = this.factory.createR();
        Text txt = new Text();
        txt.setSpace("preserve");
        txt.setValue(" PAGE   \\* MERGEFORMAT ");
        run.getContent().add(this.factory.createRInstrText(txt));
        paragraph.getContent().add(run);
    }

    private void addFieldBegin(P paragraph) {
        R run = this.factory.createR();
        FldChar fldchar = this.factory.createFldChar();
        fldchar.setFldCharType(STFldCharType.BEGIN);
        run.getContent().add(fldchar);
        paragraph.getContent().add(run);
    }

    private void addFieldEnd(P paragraph) {
        FldChar fldcharend = this.factory.createFldChar();
        fldcharend.setFldCharType(STFldCharType.END);
        R run3 = this.factory.createR();
        run3.getContent().add(fldcharend);
        paragraph.getContent().add(run3);
    }

    public void createFooterReference(Relationship relationship) {
        List sections = this.wordMLPackage.getDocumentModel().getSections();
        SectPr sectPr = ((SectionWrapper)sections.get(sections.size() - 1)).getSectPr();
        if (sectPr == null) {
            sectPr = this.factory.createSectPr();
            this.wordMLPackage.getMainDocumentPart().addObject((Object)sectPr);
            ((SectionWrapper)sections.get(sections.size() - 1)).setSectPr(sectPr);
        }
        FooterReference footerReference = this.factory.createFooterReference();
        footerReference.setId(relationship.getId());
        footerReference.setType(HdrFtrRef.DEFAULT);
        sectPr.getEGHdrFtrReferences().add(footerReference);
    }
}

