/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.dita.writer.word;

import jakarta.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.wml.Document;
import org.docx4j.wml.FldChar;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.P;
import org.docx4j.wml.R;
import org.docx4j.wml.STFldCharType;
import org.docx4j.wml.Text;

public class AddingTableOfContent {
    private ObjectFactory factory;

    public void addToc(WordprocessingMLPackage pack) throws Docx4JException {
        this.factory = Context.getWmlObjectFactory();
        MainDocumentPart documentPart = pack.getMainDocumentPart();
        this.addTableOfContent(documentPart);
    }

    private void addTableOfContent(MainDocumentPart documentPart) {
        P paragraph = this.factory.createP();
        this.addFieldBegin(paragraph);
        this.addTableOfContentField(paragraph);
        this.addFieldEnd(paragraph);
        ((Document)documentPart.getJaxbElement()).getBody().getContent().add(paragraph);
    }

    private void addTableOfContentField(P paragraph) {
        R run = this.factory.createR();
        Text txt = new Text();
        txt.setSpace("preserve");
        txt.setValue("TOC \\o \"1-3\" \\h \\z \\u");
        run.getContent().add(this.factory.createRInstrText(txt));
        paragraph.getContent().add(run);
    }

    private void addFieldBegin(P paragraph) {
        R run = this.factory.createR();
        FldChar fldchar = this.factory.createFldChar();
        fldchar.setFldCharType(STFldCharType.BEGIN);
        fldchar.setDirty(Boolean.valueOf(true));
        run.getContent().add(this.getWrappedFldChar(fldchar));
        paragraph.getContent().add(run);
    }

    private void addFieldEnd(P paragraph) {
        R run = this.factory.createR();
        FldChar fldcharend = this.factory.createFldChar();
        fldcharend.setFldCharType(STFldCharType.END);
        run.getContent().add(this.getWrappedFldChar(fldcharend));
        paragraph.getContent().add(run);
    }

    public JAXBElement<FldChar> getWrappedFldChar(FldChar fldchar) {
        return new JAXBElement(new QName("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "fldChar"), FldChar.class, (Object)fldchar);
    }
}

