/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.dita.writer.word;

import java.io.File;
import java.math.BigInteger;
import java.util.List;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.StyleDefinitionsPart;
import org.docx4j.wml.HpsMeasure;
import org.docx4j.wml.RFonts;
import org.docx4j.wml.RPr;
import org.docx4j.wml.Style;
import org.docx4j.wml.Styles;
import org.docx4j.wml.U;
import org.docx4j.wml.UnderlineEnumeration;

public class ChangingTheStyleSheet {
    private WordprocessingMLPackage wordMLPackage;

    public void main(String[] args) throws Docx4JException {
        this.wordMLPackage = WordprocessingMLPackage.createPackage();
        this.alterStyleSheet();
        this.wordMLPackage.getMainDocumentPart().addStyledParagraphOfText("Title", "Hello World! This title is now in Arial.");
        this.wordMLPackage.getMainDocumentPart().addStyledParagraphOfText("Subtitle", "Subtitle, this subtitle is now Arial too");
        this.wordMLPackage.getMainDocumentPart().addStyledParagraphOfText("Heading1", "As is Heading1");
        this.wordMLPackage.getMainDocumentPart().addStyledParagraphOfText("Heading2", "Heading2 is now Arial, no longer bold and has an underline and fontsize 12");
        this.wordMLPackage.getMainDocumentPart().addStyledParagraphOfText("Heading3", "Heading3 is now Arial");
        this.wordMLPackage.getMainDocumentPart().addStyledParagraphOfText("Normal", "And normal text has changed to Arial and fontsize 10");
        this.wordMLPackage.save(new File("src/main/files/HelloWord12.docx"));
    }

    public void alterStyleSheet() {
        StyleDefinitionsPart styleDefinitionsPart = this.wordMLPackage.getMainDocumentPart().getStyleDefinitionsPart();
        Styles styles = (Styles)styleDefinitionsPart.getJaxbElement();
        List stylesList = styles.getStyle();
        for (Style style : stylesList) {
            if (style.getStyleId().equals("Normal")) {
                this.alterNormalStyle(style);
                continue;
            }
            if (style.getStyleId().equals("Heading2")) {
                this.alterHeading2Style(style);
                continue;
            }
            if (!style.getStyleId().equals("Heading1") && !style.getStyleId().equals("Heading3") && !style.getStyleId().equals("Title") && !style.getStyleId().equals("Subtitle")) continue;
            this.getRunPropertiesAndRemoveThemeInfo(style);
        }
    }

    private void alterNormalStyle(Style style) {
        RPr rpr = new RPr();
        this.changeFontToArial(rpr);
        this.changeFontSize(rpr, 20);
        style.setRPr(rpr);
    }

    private void alterHeading2Style(Style style) {
        RPr rpr = this.getRunPropertiesAndRemoveThemeInfo(style);
        this.removeBoldStyle(rpr);
        this.changeFontSize(rpr, 24);
        this.addUnderline(rpr);
    }

    private RPr getRunPropertiesAndRemoveThemeInfo(Style style) {
        RPr rpr = style.getRPr();
        this.removeThemeFontInformation(rpr);
        return rpr;
    }

    private void changeFontToArial(RPr runProperties) {
        RFonts runFont = new RFonts();
        runFont.setAscii("Arial");
        runFont.setHAnsi("Arial");
        runProperties.setRFonts(runFont);
    }

    private void changeFontSize(RPr runProperties, int fontSize) {
        HpsMeasure size = new HpsMeasure();
        size.setVal(BigInteger.valueOf(fontSize));
        runProperties.setSz(size);
    }

    private void removeThemeFontInformation(RPr runProperties) {
        runProperties.getRFonts().setAsciiTheme(null);
        runProperties.getRFonts().setHAnsiTheme(null);
    }

    private void removeBoldStyle(RPr runProperties) {
        runProperties.getB().setVal(Boolean.valueOf(false));
    }

    private void addUnderline(RPr runProperties) {
        U underline = new U();
        underline.setVal(UnderlineEnumeration.SINGLE);
        runProperties.setU(underline);
    }
}

