/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.dita.writer.word;

import java.math.BigInteger;
import org.docx4j.jaxb.Context;
import org.docx4j.wml.CTBorder;
import org.docx4j.wml.CTTblLayoutType;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.STBorder;
import org.docx4j.wml.STTblLayoutType;
import org.docx4j.wml.Tbl;
import org.docx4j.wml.TblBorders;
import org.docx4j.wml.TblPr;
import org.docx4j.wml.TblWidth;
import org.docx4j.wml.Tc;
import org.docx4j.wml.TcPr;

public class TableUtil {
    private static ObjectFactory factory = Context.getWmlObjectFactory();

    public static void addBorders(Tbl table, String borderColor) {
        TblPr tableProperties = TableUtil.getTableProperties(table);
        CTBorder border = new CTBorder();
        border.setColor("auto");
        border.setSz(new BigInteger("4"));
        border.setSpace(new BigInteger("0"));
        border.setVal(STBorder.SINGLE);
        if (borderColor != null) {
            border.setColor(borderColor);
        }
        TblBorders borders = new TblBorders();
        borders.setBottom(border);
        borders.setLeft(border);
        borders.setRight(border);
        borders.setTop(border);
        borders.setInsideH(border);
        borders.setInsideV(border);
        tableProperties.setTblBorders(borders);
    }

    public static void setCellWidth(Tc tableCell, Integer width) {
        TcPr tableCellProperties = new TcPr();
        TblWidth tableWidth = new TblWidth();
        tableWidth.setType("dxa");
        tableWidth.setW(BigInteger.valueOf(width.intValue()));
        tableCellProperties.setTcW(tableWidth);
        tableCell.setTcPr(tableCellProperties);
    }

    public static void setTableWidth(Tbl table, Integer width) {
        TblPr tableProperties = TableUtil.getTableProperties(table);
        TblWidth tableWidth = new TblWidth();
        tableWidth.setType("dxa");
        tableWidth.setW(BigInteger.valueOf(width.intValue()));
        tableProperties.setTblW(tableWidth);
        CTTblLayoutType tbllayouttype = factory.createCTTblLayoutType();
        tbllayouttype.setType(STTblLayoutType.FIXED);
        tableProperties.setTblLayout(tbllayouttype);
    }

    private static TblPr getTableProperties(Tbl table) {
        TblPr tableProperties = table.getTblPr();
        if (tableProperties == null) {
            tableProperties = new TblPr();
            table.setTblPr(tableProperties);
        }
        return tableProperties;
    }
}

