/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.dita.writer.word;

import java.io.File;
import net.edgemind.ibee.core.exception.ManualInteruptionException;
import net.edgemind.ibee.core.log.LogLevel;
import net.edgemind.ibee.dita.builder.word.WordDocumentBuilder;
import net.edgemind.ibee.dita.exception.DitaException;
import net.edgemind.ibee.dita.items.DitaTopic;
import net.edgemind.ibee.dita.style.DefaultStyleEngine;
import net.edgemind.ibee.dita.style.StyleEngine;
import net.edgemind.ibee.dita.writer.AbstractTopicWriter;
import net.edgemind.ibee.dita.writer.IDitaDocumentWriter;
import net.edgemind.ibee.dita.writer.word.AddingPageNrToFooter;
import net.edgemind.ibee.util.file.FileUtil;
import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.wml.ObjectFactory;

public class WordDocumentWriter
extends AbstractTopicWriter
implements IDitaDocumentWriter {
    private StyleEngine styleEngine = new DefaultStyleEngine();
    private String tableSize = "DIN A4, PORTRAIT";
    private boolean showPageNumbers = false;
    private ObjectFactory factory = Context.getWmlObjectFactory();

    public void setStyleEngine(StyleEngine engine) {
        this.styleEngine = engine;
    }

    public void setTableSize(String tableSize) {
        this.tableSize = tableSize;
    }

    public void setShowPageNumbers(boolean showPageNumbers) {
        this.showPageNumbers = showPageNumbers;
    }

    @Override
    public void dispose() throws DitaException {
        this.styleEngine = null;
    }

    protected WordDocumentBuilder createDocumentBuilder() {
        WordDocumentBuilder builder = new WordDocumentBuilder();
        builder.setFactory(this.factory);
        builder.setStyleEngine(this.styleEngine);
        builder.setUseTemplating(false);
        builder.setTableSize(this.tableSize);
        builder.writeSingleDocument(true);
        return builder;
    }

    @Override
    protected String getFileName(DitaTopic ditaFile) {
        String url = ditaFile.getUrl();
        url = FileUtil.replaceExtension((String)url, (String)".docx");
        return url;
    }

    @Override
    public void writeTopicDocument(DitaTopic topic, File outputFolder) throws DitaException {
        File file = new File(outputFolder, topic.getUrl() + ".docx");
        this.writeToFile(topic, file);
    }

    public void writeToFile(DitaTopic topic, File file) throws DitaException {
        try {
            WordDocumentBuilder builder = this.createDocumentBuilder();
            builder.setStyleEngine(this.styleEngine);
            builder.setTargetFolder(file.getParentFile());
            builder.setUseTemplating(false);
            builder.setTableSize(this.tableSize);
            WordprocessingMLPackage wordMLPackage = builder.buildTopicDocument(topic);
            if (this.showPageNumbers) {
                new AddingPageNrToFooter().addPageNumbers(wordMLPackage);
            }
            wordMLPackage.save(file);
            this.log("File '" + file.getAbsolutePath() + "' written successully", LogLevel.INFO);
        }
        catch (ManualInteruptionException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DitaException(e);
        }
    }
}

