/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.io.File;
import java.io.IOException;
import net.edgemind.ibee.dita.exception.DitaException;
import net.edgemind.ibee.dita.items.DitaEntry;
import net.edgemind.ibee.dita.items.DitaFactory;
import net.edgemind.ibee.dita.items.DitaRow;
import net.edgemind.ibee.dita.items.DitaSection;
import net.edgemind.ibee.dita.items.DitaTBody;
import net.edgemind.ibee.dita.items.DitaTGroup;
import net.edgemind.ibee.dita.items.DitaTable;
import net.edgemind.ibee.dita.items.DitaTitle;
import net.edgemind.ibee.dita.items.DitaTopic;
import net.edgemind.ibee.dita.writer.SaxDocumentWriter;
import net.edgemind.ibee.dita.writer.html.HtmlSaxDocumentWriter;
import net.edgemind.ibee.util.file.FileUtil;

public class HtmlSaxWriterTest {
    static SaxDocumentWriter writer;

    public static void main(String[] args) throws DitaException, IOException {
        String tmpdir = System.getProperty("java.io.tmpdir");
        File outDir = new File(tmpdir, "dita");
        FileUtil.createDir((String)outDir.getAbsolutePath());
        System.out.println(String.format("Write output into directory %s", outDir.getAbsolutePath()));
        writer = new HtmlSaxDocumentWriter(outDir);
        writer.setWriteSingleDocument(true);
        DitaTopic topic = DitaFactory.getInstance().createTopic("index");
        writer.enterTopic(topic);
        int i = 0;
        while (i < 10) {
            HtmlSaxWriterTest.createSubTopic(topic, i);
            ++i;
        }
        writer.leaveTopic();
    }

    private static void createSubTopic(DitaTopic parentTopic, int index) throws DitaException {
        DitaTopic subTopic = DitaFactory.getInstance().createTopic("chapter" + index);
        parentTopic.append(subTopic);
        writer.enterTopic(subTopic);
        DitaSection section = DitaFactory.getInstance().createSection();
        subTopic.append(section);
        DitaTitle title = DitaFactory.getInstance().createTitle();
        section.append(title);
        title.setText(String.format("This is chapter %d", index));
        DitaTable table = DitaFactory.getInstance().createTable();
        section.append(table);
        DitaTGroup tGroup = DitaFactory.getInstance().createTGroup();
        table.append(tGroup);
        DitaTBody tBody = DitaFactory.getInstance().createTBody();
        tGroup.append(tBody);
        int i = 0;
        while (i < 10) {
            DitaRow tRow = DitaFactory.getInstance().createRow();
            tBody.append(tRow);
            int j = 0;
            while (j < 5) {
                DitaEntry cell = DitaFactory.getInstance().createEntry();
                cell.setText("Cell: " + i + "," + j);
                tRow.append(cell);
                ++j;
            }
            ++i;
        }
        writer.leaveTopic();
    }
}

