/*
 * Decompiled with CFR 0.152.
 */
package test;

import org.docx4j.openpackaging.io.SaveToZipFile;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.SpreadsheetMLPackage;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.SpreadsheetML.WorksheetPart;
import org.xlsx4j.jaxb.Context;
import org.xlsx4j.sml.CTRst;
import org.xlsx4j.sml.CTXstringWhitespace;
import org.xlsx4j.sml.Cell;
import org.xlsx4j.sml.Row;
import org.xlsx4j.sml.STCellType;
import org.xlsx4j.sml.SheetData;
import org.xlsx4j.sml.Worksheet;

public class Test {
    public static void main(String[] args) throws Exception {
        new Test().create();
    }

    public void create() throws Exception {
        String outputfilepath = "test-out.xlsx";
        SpreadsheetMLPackage pkg = SpreadsheetMLPackage.createPackage();
        WorksheetPart sheet1 = pkg.createWorksheetPart(new PartName("/xl/worksheets/sheet1.xml"), "Analysis Case", 1L);
        this.addContent1(sheet1);
        WorksheetPart sheet2 = pkg.createWorksheetPart(new PartName("/xl/worksheets/sheet2.xml"), "ConseqACase-ET", 2L);
        Test.addContent2(sheet2);
        WorksheetPart sheet3 = pkg.createWorksheetPart(new PartName("/xl/worksheets/sheet3.xml"), "Group Spec", 3L);
        Test.addContent3(sheet3);
        SaveToZipFile saver = new SaveToZipFile((OpcPackage)pkg);
        saver.save(outputfilepath);
        System.out.println("\n\n done .. " + outputfilepath);
    }

    private void addContent1(WorksheetPart sheet) {
        SheetData sheetData = ((Worksheet)sheet.getJaxbElement()).getSheetData();
        Row row = Context.getsmlObjectFactory().createRow();
        this.addCell(row, "Analysis Case Type");
        this.addCell(row, "Analysis Case ID");
        this.addCell(row, "Description");
        this.addCell(row, "MCS Setup");
        this.addCell(row, "Unc. Setup");
        this.addCell(row, "Imp. Setup");
        this.addCell(row, "T-D Setup");
        this.addCell(row, "BC Set ID");
        this.addCell(row, "Input Gate");
        this.addCell(row, "Input Sequence");
        this.addCell(row, "Input Consequence");
        sheetData.getRow().add(row);
    }

    private void addCell(Row row, String content) {
        CTRst ctrst = new CTRst();
        CTXstringWhitespace v = new CTXstringWhitespace();
        v.setValue(content);
        ctrst.setT(v);
        Cell cell = Context.getsmlObjectFactory().createCell();
        cell.setT(STCellType.INLINE_STR);
        cell.setIs(ctrst);
        row.getC().add(cell);
    }

    private static void addContent2(WorksheetPart sheet) {
        SheetData sheetData = ((Worksheet)sheet.getJaxbElement()).getSheetData();
        Row row = Context.getsmlObjectFactory().createRow();
        Cell cell = Context.getsmlObjectFactory().createCell();
        cell.setV("1234");
        row.getC().add(cell);
        sheetData.getRow().add(row);
    }

    private static void addContent3(WorksheetPart sheet) {
        SheetData sheetData = ((Worksheet)sheet.getJaxbElement()).getSheetData();
        Row row = Context.getsmlObjectFactory().createRow();
        Cell cell = Context.getsmlObjectFactory().createCell();
        cell.setV("1234");
        row.getC().add(cell);
        sheetData.getRow().add(row);
    }
}

