/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.genpython;

import java.util.ArrayList;
import java.util.List;
import net.edgemind.ibee.genpython.PythonBuf;
import net.edgemind.ibee.genpython.PythonFile;
import net.edgemind.ibee.genpython.PythonFunction;
import net.edgemind.ibee.genpython.PythonObject;
import net.edgemind.ibee.genpython.PythonParameter;
import net.edgemind.ibee.genpython.PythonVariable;

public class PythonClass
extends PythonObject {
    private List<PythonClass> inheritations = new ArrayList<PythonClass>();
    private List<PythonFunction> functions = new ArrayList<PythonFunction>();
    private List<PythonVariable> variables = new ArrayList<PythonVariable>();
    private String name;
    private PythonFile file;

    public PythonClass(String name) {
        super(name, "");
        this.name = name;
    }

    public PythonClass(String name, String doc) {
        super(name, doc);
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void addFunction(PythonFunction fct) {
        this.functions.add(fct);
    }

    public PythonFunction addConstructor(String ... parameter) {
        return this.addFunction("__init__", "", "", parameter);
    }

    public PythonFunction addFunction(String name, String returnType, String doc, String ... parameter) {
        PythonFunction fct = new PythonFunction(name, returnType, doc);
        PythonParameter par = new PythonParameter("self", "");
        fct.addParameter(par);
        if (parameter != null) {
            String[] stringArray = parameter;
            int n = parameter.length;
            int n2 = 0;
            while (n2 < n) {
                String parName = stringArray[n2];
                par = new PythonParameter(parName, "");
                fct.addParameter(par);
                ++n2;
            }
        }
        this.functions.add(fct);
        return fct;
    }

    public PythonFunction addFunction(String name, String returnType, String doc) {
        PythonFunction fct = this.addFunction(name, returnType, doc, null);
        return fct;
    }

    public List<PythonFunction> getFunctions() {
        return this.functions;
    }

    public void addVariable(String name, String value, Boolean isStatic, String doc) {
        PythonVariable variable = new PythonVariable(name, isStatic, doc);
        variable.setValue(value);
        variable.setParent(this);
        this.variables.add(variable);
    }

    public List<PythonVariable> getVariables() {
        return this.variables;
    }

    public void addInheritation(String name) {
        PythonClass clazz = new PythonClass(name);
        this.addInheritation(clazz);
    }

    public void addInheritation(PythonClass clazz) {
        if (!this.inheritations.contains(clazz)) {
            this.inheritations.add(clazz);
        }
    }

    public List<PythonClass> getInheritations() {
        return this.inheritations;
    }

    public boolean inherits(PythonClass clazz) {
        for (PythonClass test : this.inheritations) {
            if (test == clazz) {
                return true;
            }
            if (!test.inherits(clazz)) continue;
            return true;
        }
        return false;
    }

    public void setFile(PythonFile file) {
        this.file = file;
    }

    public PythonFile getFile() {
        return this.file;
    }

    public void writeDoc(PythonBuf buf) {
        Object doc = this.getDoc().trim();
        if (((String)doc).length() > 0) {
            if (!((String)(doc = ((String)doc).substring(0, 1).toUpperCase() + ((String)doc).substring(1, ((String)doc).length()))).endsWith(".")) {
                doc = (String)doc + ".";
            }
            doc = (String)doc + "\n";
        }
        if (!((String)(doc = this.getName() + ".\n" + (String)doc)).trim().equals("")) {
            this.writeDoc(buf, (String)doc);
        }
    }
}

