/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.genpython;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.edgemind.ibee.core.util.Selection;
import net.edgemind.ibee.genpython.PythonBlock;
import net.edgemind.ibee.genpython.PythonClass;
import net.edgemind.ibee.genpython.PythonFunction;
import net.edgemind.ibee.genpython.PythonImport;
import net.edgemind.ibee.genpython.PythonObject;
import net.edgemind.ibee.genpython.PythonProgram;
import net.edgemind.ibee.genpython.PythonVariable;
import net.edgemind.ibee.util.file.FileUtil;

public class PythonFile {
    private String name;
    private List<PythonImport> imports = new ArrayList<PythonImport>();
    private Selection<PythonObject> children = new Selection();
    private List<PythonVariable> variables = new ArrayList<PythonVariable>();

    public PythonFile(String name) {
        this.setName(name);
    }

    public void setName(String name) {
        this.name = name = FileUtil.replaceExtension((String)name, null);
    }

    public String getName() {
        return this.name;
    }

    public PythonClass addClass(PythonClass clazz) {
        this.children.add((Object)clazz);
        return clazz;
    }

    public void addClass(String name, String doc) {
        PythonClass clazz = new PythonClass(name, doc);
        this.children.add((Object)clazz);
    }

    public List<PythonClass> getClasses() {
        return this.children.getElements(PythonClass.class);
    }

    public PythonClass getClass(String name) {
        return this.getClass(name, false);
    }

    public List<PythonObject> getChildren() {
        return this.children.getElements();
    }

    public PythonBlock addBlock(PythonBlock block) {
        this.children.add((Object)block);
        return block;
    }

    public PythonBlock addBlock(String content) {
        PythonBlock block = new PythonBlock();
        block.writeln(content);
        return block;
    }

    public PythonClass getClass(String name, boolean create) {
        List list = this.children.getElements(PythonClass.class);
        for (PythonClass next : list) {
            if (!next.getName().equals(name)) continue;
            return next;
        }
        if (create) {
            PythonClass clazz = new PythonClass(name);
            this.children.add((Object)clazz);
            clazz.setFile(this);
            return clazz;
        }
        return null;
    }

    public void addImport(PythonImport pythonImport) {
        if (!this.imports.contains(pythonImport)) {
            this.imports.add(pythonImport);
        }
    }

    public PythonImport addImport(String name, String basePackage, String alias) {
        PythonImport pythonImport = new PythonImport();
        pythonImport.setPackageName(basePackage);
        pythonImport.setClazzName(name);
        pythonImport.setAlias(alias);
        this.imports.add(pythonImport);
        return pythonImport;
    }

    public PythonImport getImportFromAlias(String alias) {
        for (PythonImport next : this.imports) {
            String nextAlias = next.getAlias();
            if (!nextAlias.equals(alias)) continue;
            return next;
        }
        return null;
    }

    public List<PythonImport> getImports() {
        return this.imports;
    }

    public void setImports(List<PythonImport> imports) {
        this.imports = imports;
    }

    public void addFunction(PythonFunction fct) {
        this.children.add((Object)fct);
    }

    public List<PythonFunction> getFunctions() {
        List list = this.children.getElements(PythonFunction.class);
        return list;
    }

    public void addVariable(PythonVariable variable) {
        this.variables.add(variable);
    }

    public void addVariable(String name, String value, Boolean isStatic, String doc) {
        PythonVariable variable = new PythonVariable(name, isStatic, doc);
        variable.setValue(value);
        this.variables.add(variable);
    }

    public List<PythonVariable> getVariables() {
        return this.variables;
    }

    public void updateIncludes(String content) {
        if (content == null) {
            return;
        }
        HashMap<String, PythonImport> includeMap = PythonProgram.getIncludeMap();
        Pattern pattern = Pattern.compile("\\w+");
        Matcher matcher = pattern.matcher(content);
        int indexEnd = 0;
        while (matcher.find(indexEnd)) {
            indexEnd = matcher.end();
            String key = content.substring(matcher.start(), matcher.end()).trim();
            if (!includeMap.containsKey(key)) continue;
            PythonImport imp = includeMap.get(key);
            this.addImport(imp);
        }
    }
}

