/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.genpython;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import net.edgemind.ibee.genpython.PythonBlock;
import net.edgemind.ibee.genpython.PythonBuf;
import net.edgemind.ibee.genpython.PythonClass;
import net.edgemind.ibee.genpython.PythonFile;
import net.edgemind.ibee.genpython.PythonFunction;
import net.edgemind.ibee.genpython.PythonImport;
import net.edgemind.ibee.genpython.PythonObject;
import net.edgemind.ibee.genpython.PythonParameter;
import net.edgemind.ibee.genpython.PythonVariable;
import net.edgemind.ibee.util.file.FileUtil;

public class PythonWriter {
    public PythonBuf readFile(PythonFile file, File baseFolder) {
        PythonBuf buf = new PythonBuf();
        for (PythonImport imp : file.getImports()) {
            this.writeImport(imp, buf);
        }
        for (PythonVariable var : file.getVariables()) {
            this.writeVariable(var, buf);
        }
        for (PythonObject obj : file.getChildren()) {
            if (obj instanceof PythonClass) {
                this.writeClass((PythonClass)obj, buf);
            }
            if (obj instanceof PythonFunction) {
                this.writeFunction((PythonFunction)obj, buf);
            }
            if (!(obj instanceof PythonBlock)) continue;
            this.writeBlock((PythonBlock)obj, buf);
        }
        return buf;
    }

    public void writeFile(PythonFile file, File baseFolder) throws IOException {
        PythonBuf buf = new PythonBuf();
        for (PythonImport imp : file.getImports()) {
            this.writeImport(imp, buf);
        }
        for (PythonVariable var : file.getVariables()) {
            this.writeVariable(var, buf);
        }
        for (PythonObject obj : file.getChildren()) {
            if (!(obj instanceof PythonClass)) continue;
            this.writeForwardDeclarationClass((PythonClass)obj, buf);
        }
        for (PythonObject obj : file.getChildren()) {
            if (obj instanceof PythonClass) {
                this.writeClass((PythonClass)obj, buf);
            }
            if (obj instanceof PythonFunction) {
                this.writeFunction((PythonFunction)obj, buf);
            }
            if (!(obj instanceof PythonBlock)) continue;
            this.writeBlock((PythonBlock)obj, buf);
        }
        String filename = FileUtil.replaceExtension((String)new File(file.getName()).getName(), (String)"py");
        FileOutputStream out = new FileOutputStream(new File(baseFolder, filename));
        out.write(buf.getText().getBytes());
        out.close();
    }

    private void writeImport(PythonImport imp, PythonBuf buf) {
        String alias;
        String name;
        String packName = imp.getPackageName();
        if (packName != null && packName.length() > 0) {
            buf.write("from " + packName + " ");
        }
        if ((name = imp.getClazzName()) != null && name.length() > 0) {
            buf.write("import " + name);
        }
        if ((alias = imp.getAlias()) != null && alias.length() > 0) {
            buf.write(" as " + alias);
        }
        buf.writeln(";");
    }

    private void writeClass(PythonClass clazz, PythonBuf buf) {
        buf.write("class " + clazz.getName());
        boolean first = true;
        if (clazz.getInheritations().size() > 0) {
            buf.write("(");
        }
        for (PythonClass parentClazz : clazz.getInheritations()) {
            if (first) {
                first = false;
            } else {
                buf.write(",");
            }
            buf.write(parentClazz.getName());
        }
        if (clazz.getInheritations().size() > 0) {
            buf.write(")");
        }
        buf.writeln(":").enter();
        clazz.writeDoc(buf);
        for (PythonVariable var : clazz.getVariables()) {
            this.writeVariable(var, buf);
        }
        for (PythonFunction fct : clazz.getFunctions()) {
            this.writeFunction(fct, buf);
        }
        buf.leave();
    }

    private void writeForwardDeclarationClass(PythonClass clazz, PythonBuf buf) {
        buf.writeln("class " + clazz.getName() + ": pass");
    }

    private void writeBlock(PythonBlock block, PythonBuf buf) {
        buf.writeln(block.buf);
    }

    private void writeFunction(PythonFunction fct, PythonBuf buf) {
        if (fct.isStatic().booleanValue()) {
            buf.writeln("@staticmethod");
        }
        Object fctName = "";
        fctName = (String)fctName + "def " + fct.getName() + "(";
        boolean first = true;
        for (PythonParameter par : fct.getParameter()) {
            if (first) {
                first = false;
            } else {
                fctName = (String)fctName + ", ";
            }
            fctName = (String)fctName + par.getName();
        }
        fctName = (String)fctName + "):";
        buf.writeln((String)fctName);
        buf.enter();
        fct.writeDoc(buf);
        buf.writeln(fct.buf);
        buf.leave();
    }

    private void writeVariable(PythonVariable var, PythonBuf buf) {
        if (var.isStatic().booleanValue()) {
            buf.write("self.");
        }
        buf.writeln(var.getName() + " = " + var.getValue());
        var.writeDoc(buf);
    }
}

