/*
 * Decompiled with CFR 0.152.
 */
package net.ibee.gmf.model.converter;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.edgemind.ibee.core.exception.IbeeException;
import net.edgemind.ibee.core.iml.domain.Version;
import net.edgemind.ibee.core.library.IbeeLibrary;
import net.edgemind.ibee.core.resource.IbeeResource;
import net.edgemind.ibee.core.resource.ResourceFactory;
import net.edgemind.ibee.util.file.FileUtil;
import net.ibee.gmf.model.IGmfDomain;
import net.ibee.gmf.model.IGmfMeta;
import net.ibee.gmf.model.IGmfModel;
import net.ibee.gmf.model.converter.AbstractGmfConverter;
import net.ibee.gmf.reader.DomGmfReader;
import net.ibee.gmf.reader.SaxGmfReader;
import net.ibee.gmf.writer.SaxGmfWriter;

public abstract class AChainedGmfModelConverter {
    private List<AbstractGmfConverter> converterList = new ArrayList<AbstractGmfConverter>();
    private String toVersion;
    private String domainName;
    private Version convertedToVersion;

    protected abstract List<AbstractGmfConverter> getConverter(String var1, String var2);

    public void init(String fromVersion, String toVersion, String domainName) {
        fromVersion = this.getDefaultVersionIfNotSet(fromVersion);
        this.toVersion = toVersion = this.getDefaultVersionIfNotSet(toVersion);
        this.domainName = domainName;
        this.converterList = this.getConverter(fromVersion, toVersion);
    }

    private String getDefaultVersionIfNotSet(String version) {
        if (version == null || version.length() == 0) {
            version = "1.0";
        }
        return version;
    }

    public boolean canConvert() {
        return this.converterList.size() > 0;
    }

    public List<AbstractGmfConverter> getConverterList() {
        return this.converterList;
    }

    public void convert(File in, File out) {
        try {
            IbeeResource resFrom = ResourceFactory.getInstance().createIbeeResource();
            resFrom.disableNotifications();
            this.readResource(in, resFrom);
            IGmfModel model = (IGmfModel)resFrom.getRoot();
            int index = 0;
            this.convertedToVersion = null;
            for (AbstractGmfConverter converter : this.converterList) {
                converter.convert(model);
                this.convertedToVersion = converter.getToVersion();
            }
            this.setVersion(model, this.convertedToVersion.toVersionString());
            this.getMetaData("domain-name", model, true).setValue(this.domainName);
            this.getMetaData("xml-writer-name", model, true).setValue("SaxResourceWriter");
            this.getMetaData("xml-writer-version", model, true).setValue("1.0");
            IbeeResource resource = model.giGetResource();
            for (IbeeLibrary lib : resFrom.getLibraries()) {
                resource.addLibrary(lib, resFrom.getDescriptor(lib).getUrl(), index++);
            }
            this.writeResourceSax(out, model);
        }
        catch (IOException e) {
            throw new IbeeException((Throwable)e);
        }
    }

    protected void setVersion(IGmfModel model, String version) {
        this.getMetaData("domain-version", model, true).setValue(version);
        model.setVersion(version);
    }

    private IGmfMeta getMetaData(String key, IGmfModel model, boolean create) {
        IGmfMeta meta = null;
        for (IGmfMeta nextMeta : model.getMeta()) {
            if (!nextMeta.getName().equalsIgnoreCase(key)) continue;
            meta = nextMeta;
            break;
        }
        if (meta == null && create) {
            meta = IGmfDomain.instance.createGmfMeta();
            meta.setName(key);
            model.addMeta(meta);
        }
        return meta;
    }

    protected void readResource(File in, IbeeResource resource) throws IOException {
        if (FileUtil.isZipFile((File)in)) {
            SaxGmfReader reader = new SaxGmfReader();
            reader.convert(in, resource);
        } else {
            DomGmfReader reader = new DomGmfReader();
            reader.convert(in, resource);
        }
    }

    protected void writeResourceSax(File out, IGmfModel modelTo) throws IOException {
        SaxGmfWriter writer = new SaxGmfWriter();
        writer.write(modelTo, out);
    }

    public Version getConvertedToVersion() {
        return this.convertedToVersion;
    }
}

