/*
 * Decompiled with CFR 0.152.
 */
package net.ibee.gmf.model.converter;

import java.util.ArrayList;
import net.edgemind.ibee.core.iml.domain.Version;
import net.edgemind.ibee.core.log.ILogHandler;
import net.edgemind.ibee.core.log.LogLevel;
import net.ibee.gmf.model.IGmfAttribute;
import net.ibee.gmf.model.IGmfComponent;
import net.ibee.gmf.model.IGmfElement;
import net.ibee.gmf.model.IGmfLibrary;
import net.ibee.gmf.model.IGmfList;
import net.ibee.gmf.model.IGmfMeta;
import net.ibee.gmf.model.IGmfModel;

public abstract class AbstractGmfConverter {
    ILogHandler logHandler;

    public abstract Version getToVersion();

    public void setLogHandler(ILogHandler handler) {
        this.logHandler = handler;
    }

    public void convert(IGmfModel model) {
        this.pre(model);
        this.covertModel(model);
        this.post(model);
    }

    protected void pre(IGmfModel model) {
    }

    protected void covertModel(IGmfModel model) {
        this.covertMeta(model);
        this.convertLibraries(model);
        ArrayList<IGmfComponent> components = new ArrayList<IGmfComponent>(model.getComponents());
        for (IGmfComponent component : components) {
            this.convertComponent(component);
        }
    }

    protected void post(IGmfModel model) {
    }

    protected void covertMeta(IGmfModel model) {
        for (IGmfMeta meta : model.getMeta()) {
            this.convertMetaData(meta, model);
        }
    }

    protected void convertComponent(IGmfComponent component) {
        for (IGmfAttribute attrFrom : new ArrayList<IGmfAttribute>(component.getAttributes())) {
            this.convertAttribute(attrFrom, component);
        }
        for (IGmfList listFrom : new ArrayList<IGmfList>(component.getLists())) {
            this.convertListFeature(listFrom, component);
        }
        for (IGmfElement elFeature : new ArrayList<IGmfElement>(component.getElements())) {
            this.convertElementFeature(elFeature, component);
        }
    }

    protected void convertLibraries(IGmfModel model) {
        for (IGmfLibrary lib : model.getLibrary()) {
            this.convertLibrary(lib);
        }
    }

    protected void convertAttribute(IGmfAttribute attr, IGmfComponent component) {
    }

    protected void convertElementFeature(IGmfElement elFeature, IGmfComponent component) {
    }

    protected void convertListFeature(IGmfList listFeature, IGmfComponent component) {
    }

    protected void convertMetaData(IGmfMeta meta, IGmfModel model) {
    }

    protected void convertLibrary(IGmfLibrary library) {
    }

    public void log(String msg) {
        this.log(msg, LogLevel.INFO);
    }

    public void log(String msg, LogLevel level) {
        if (this.logHandler != null) {
            this.logHandler.log(msg, level);
        }
    }

    public void log(Throwable e, LogLevel level) {
        if (this.logHandler != null) {
            this.logHandler.log(e, level);
        }
    }

    public void error(String msg) {
        this.log(msg, LogLevel.ERROR);
    }

    public void warn(String msg) {
        this.log(msg, LogLevel.WARNING);
    }

    public void info(String msg) {
        this.log(msg, LogLevel.INFO);
    }

    public void debug(String msg) {
        this.log(msg, LogLevel.DEBUG);
    }

    public void log(Throwable e) {
        this.log(e, LogLevel.ERROR);
    }
}

