/*
 * Decompiled with CFR 0.152.
 */
package net.ibee.gmf.reader;

import java.io.File;
import java.io.IOException;
import java.util.List;
import net.edgemind.ibee.core.iml.model.IElement;
import net.edgemind.ibee.core.library.IbeeLibrary;
import net.edgemind.ibee.core.resource.IbeeResource;
import net.edgemind.ibee.util.string.StringUtil;
import net.edgemind.ibee.util.xml.XmlUtil;
import net.ibee.gmf.model.IGmfComponent;
import net.ibee.gmf.model.IGmfDomain;
import net.ibee.gmf.model.IGmfElement;
import net.ibee.gmf.model.IGmfList;
import net.ibee.gmf.model.IGmfModel;
import net.ibee.gmf.model.IGmfRef;
import net.ibee.gmf.util.GmfHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DomGmfReader {
    GmfHelper gmfHelper;

    public IGmfModel convert(File in, IbeeResource resource) throws IOException {
        Document doc = null;
        this.gmfHelper = new GmfHelper(resource);
        try {
            IGmfRef ref;
            doc = XmlUtil.readXmlFile((File)in);
            IGmfModel model = IGmfDomain.instance.createGmfModel();
            resource.putObject((IElement)model);
            resource.setRoot((IElement)model);
            Element root = doc.getDocumentElement();
            model.setVersion(XmlUtil.getAttribute((Element)root, (String)"version", (boolean)false, null));
            Long rootId = StringUtil.toLong((String)XmlUtil.getAttribute((Element)root, (String)"root", (boolean)false, null), (Long)-1L);
            if (rootId != null && rootId >= 0L && (ref = this.gmfHelper.createRef(rootId)) != null) {
                model.setRoot(ref);
            }
            this.parseComponents(root, model);
            this.readLibraries(root, model.giGetResource());
            IGmfModel iGmfModel = model;
            return iGmfModel;
        }
        finally {
            if (doc != null) {
                XmlUtil.destroy((Document)doc);
            }
        }
    }

    protected void readLibraries(Element parent, IbeeResource resource) {
        List libs = XmlUtil.getChildrenByTagName((String)"library", (Element)parent);
        int index = 0;
        for (Element eLib : libs) {
            IbeeLibrary lib = new IbeeLibrary();
            lib.setName(eLib.getAttribute("name"));
            String url = eLib.getAttribute("url");
            resource.addLibrary(lib, url, index++);
        }
    }

    protected void parseComponents(Element parent, IGmfModel model) {
        List elements = XmlUtil.getChildrenByTagName((String)"element", (Element)parent);
        for (Element e : elements) {
            String type = XmlUtil.getAttribute((Element)e, (String)"type", (boolean)false, (String)"");
            String domain = XmlUtil.getAttribute((Element)e, (String)"domain", (boolean)false, (String)"");
            long id = StringUtil.toLong((String)XmlUtil.getAttribute((Element)e, (String)"id", (boolean)false), (Long)-1L);
            long parentId = StringUtil.toLong((String)XmlUtil.getAttribute((Element)e, (String)"parent", (boolean)true), (Long)-1L);
            IGmfComponent component = this.gmfHelper.createComponent(id, parentId, type, domain, model);
            this.parseAttributes(e, component);
            this.parseElements(e, component);
            this.parseLists(e, component);
        }
    }

    protected void parseAttributes(Element parent, IGmfComponent component) {
        List elements = XmlUtil.getChildrenByTagName((String)"attribute", (Element)parent);
        for (Element e : elements) {
            String name = XmlUtil.getAttribute((Element)e, (String)"name", (boolean)false, (String)"");
            String value = e.getTextContent();
            this.gmfHelper.setAttribute(name, value, component);
        }
    }

    protected void parseElements(Element parent, IGmfComponent component) {
        List elements = XmlUtil.getChildrenByTagName((String)"element", (Element)parent);
        for (Element e : elements) {
            IGmfRef ref;
            long id;
            String name = XmlUtil.getAttribute((Element)e, (String)"name", (boolean)false, (String)"");
            IGmfElement gmfEl = this.gmfHelper.createElement(name, component);
            Element elId = XmlUtil.getFirstChildByTagName((String)"id", (Element)e);
            if (elId == null || (id = StringUtil.toLong((String)elId.getTextContent(), (Long)-1L).longValue()) < 0L || (ref = this.gmfHelper.createRef(id)) == null) continue;
            gmfEl.setRef(ref);
        }
    }

    protected void parseLists(Element parent, IGmfComponent component) {
        List elements = XmlUtil.getChildrenByTagName((String)"list", (Element)parent);
        for (Element e : elements) {
            String[] ids;
            String name = XmlUtil.getAttribute((Element)e, (String)"name", (boolean)false, (String)"");
            IGmfList gmfList = this.gmfHelper.createList(name, component);
            Element elId = XmlUtil.getFirstChildByTagName((String)"ids", (Element)e);
            if (elId == null) continue;
            String[] stringArray = ids = elId.getTextContent().split(",");
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                IGmfRef ref;
                String idS = stringArray[n2];
                long id = StringUtil.toLong((String)idS, (Long)-1L);
                if (id >= 0L && (ref = this.gmfHelper.createRef(id)) != null) {
                    gmfList.addRef(ref);
                }
                ++n2;
            }
        }
    }
}

