/*
 * Decompiled with CFR 0.152.
 */
package net.ibee.gmf.reader;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.edgemind.ibee.core.iml.model.IElement;
import net.edgemind.ibee.core.resource.IbeeResource;
import net.edgemind.ibee.core.resource.ResourceException;
import net.edgemind.ibee.util.file.FileUtil;
import net.edgemind.ibee.util.string.StringUtil;
import net.ibee.gmf.model.IGmfComponent;
import net.ibee.gmf.model.IGmfDomain;
import net.ibee.gmf.model.IGmfLibrary;
import net.ibee.gmf.model.IGmfList;
import net.ibee.gmf.model.IGmfMeta;
import net.ibee.gmf.model.IGmfModel;
import net.ibee.gmf.util.GmfHelper;

public class SaxGmfReader {
    IGmfModel model;
    Stack<IGmfComponent> components = new Stack();
    Stack<StartElement> xmlStack = new Stack();
    Map<Integer, Boolean> xmlComponents = new HashMap<Integer, Boolean>();
    String defaultDomain;
    STEP step = STEP.OTHER;
    IGmfLibrary currLibrary;
    GmfHelper gmfHelper;

    public String getDefaultDomain() {
        return this.defaultDomain;
    }

    public void setDefaultDomain(String defaultDomain) {
        this.defaultDomain = defaultDomain;
    }

    public IGmfModel convert(File in, IbeeResource resource) throws IOException {
        this.gmfHelper = new GmfHelper(resource);
        XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
        InputStream xmlInput = null;
        this.model = IGmfDomain.instance.createGmfModel();
        resource.putObject((IElement)this.model);
        resource.setRoot((IElement)this.model);
        XMLEventReader xmlEventReader = null;
        try {
            try {
                xmlInput = this.createInputStream(in);
                xmlEventReader = xmlInputFactory.createXMLEventReader(xmlInput);
                int level = 0;
                while (xmlEventReader.hasNext()) {
                    XMLEvent xmlEvent = xmlEventReader.nextEvent();
                    if (xmlEvent.isStartElement()) {
                        IGmfComponent component;
                        this.xmlComponents.put(++level, false);
                        StartElement el = xmlEvent.asStartElement();
                        this.xmlStack.add(el);
                        if (level == 2 && el.getName().getLocalPart().equals("meta")) {
                            this.step = STEP.PARSE_META;
                            Iterator<Attribute> it = el.getAttributes();
                            while (it.hasNext()) {
                                Attribute attr = it.next();
                                IGmfMeta meta = IGmfDomain.instance.createGmfMeta();
                                this.model.addMeta(meta);
                                meta.setName(attr.getName().getLocalPart());
                                meta.setValue(attr.getValue());
                            }
                            continue;
                        }
                        if (level == 2 && el.getName().getLocalPart().equals("libraries")) {
                            this.step = STEP.PARSE_LIB;
                            continue;
                        }
                        if (level == 2 && el.getName().getLocalPart().equals("root")) {
                            this.step = STEP.PARSE_RESOURCE;
                            this.defaultDomain = this.getAttribute(el, "domain");
                            String type = this.getAttribute(el, "type");
                            component = this.createComponent(el, null);
                            this.components.push(component);
                            component.setType(type);
                            this.model.setRoot(this.gmfHelper.createRef(component));
                            continue;
                        }
                        if (this.step == STEP.PARSE_RESOURCE && this.isComponent(el)) {
                            this.xmlComponents.put(level, true);
                            IGmfComponent parentComponent = this.components.peek();
                            component = this.createComponent(el, parentComponent);
                            this.components.push(component);
                            StartElement elParent = (StartElement)this.xmlStack.get(this.xmlStack.size() - 2);
                            if (this.isComponent(elParent)) {
                                typeName = this.getAttribute(el, "type", null);
                                component.setType(typeName);
                                featureName = el.getName().getLocalPart();
                                elFeature = this.gmfHelper.createElement(featureName, parentComponent);
                                elFeature.setRef(this.gmfHelper.createRef(component));
                            } else {
                                typeName = el.getName().getLocalPart();
                                component.setType(typeName);
                                featureName = elParent.getName().getLocalPart();
                                IGmfList listFeature = this.gmfHelper.createList(featureName, parentComponent);
                                listFeature.addRef(this.gmfHelper.createRef(component));
                            }
                        }
                        if (this.step == STEP.PARSE_LIB && el.getName().getLocalPart().equals("library")) {
                            this.currLibrary = IGmfDomain.instance.createGmfLibrary();
                            this.model.addLibrary(this.currLibrary);
                        }
                    } else if (xmlEvent.isCharacters()) {
                        Characters chars = xmlEvent.asCharacters();
                        Object text = chars.getData();
                        if (this.step == STEP.PARSE_LIB) {
                            if (this.xmlStack.peek().getName().getLocalPart().equals("name")) {
                                this.currLibrary.setName((String)text);
                            } else if (this.xmlStack.peek().getName().getLocalPart().equals("url")) {
                                this.currLibrary.setUrl((String)text);
                            }
                        }
                        if (this.step == STEP.PARSE_RESOURCE && text != null && ((String)text).trim().length() > 0) {
                            StartElement parentEl = this.xmlStack.peek();
                            IGmfComponent component = this.components.peek();
                            if (this.isRefFeature(parentEl)) {
                                featureName = parentEl.getName().getLocalPart();
                                Long id = StringUtil.toLong((String)text, (Long)-1L);
                                if (id != -1L) {
                                    elFeature = this.gmfHelper.createElement(featureName, component);
                                    elFeature.setRef(this.gmfHelper.createRef(id));
                                }
                            } else if (this.isRefListFeature(parentEl)) {
                                featureName = parentEl.getName().getLocalPart();
                                IGmfList listFeature = null;
                                String[] stringArray = ((String)text).split(",");
                                int n = stringArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    String nextId = stringArray[n2];
                                    Long id = StringUtil.toLong((String)nextId, (Long)-1L);
                                    if (id != -1L) {
                                        if (listFeature == null) {
                                            listFeature = this.gmfHelper.createList(featureName, component);
                                        }
                                        listFeature.addRef(this.gmfHelper.createRef(id));
                                    }
                                    ++n2;
                                }
                            } else {
                                String attrName = parentEl.getName().getLocalPart();
                                String textPre = this.gmfHelper.getAttributeValue(attrName, component);
                                if (textPre != null) {
                                    text = textPre + (String)text;
                                }
                                this.gmfHelper.setAttribute(attrName, (String)text, component);
                            }
                        }
                    }
                    if (!xmlEvent.isEndElement()) continue;
                    if (this.step == STEP.PARSE_RESOURCE && this.xmlComponents.get(level).booleanValue()) {
                        this.components.pop();
                    }
                    --level;
                    this.xmlStack.pop();
                }
            }
            catch (XMLStreamException e) {
                throw new IOException(e);
            }
        }
        finally {
            if (xmlEventReader != null) {
                try {
                    xmlEventReader.close();
                }
                catch (XMLStreamException e) {
                    throw new ResourceException((Throwable)e);
                }
            }
        }
        return this.model;
    }

    private boolean isRefFeature(StartElement el) {
        return this.getAttribute(el, "ref") != null && this.getAttribute(el, "ref").equalsIgnoreCase("true");
    }

    private boolean isRefListFeature(StartElement el) {
        return this.getAttribute(el, "reflist") != null && this.getAttribute(el, "reflist").equalsIgnoreCase("true");
    }

    private boolean isComponent(StartElement el) {
        return el.getAttributeByName(new QName("id")) != null;
    }

    private String getAttribute(StartElement el, String attr) {
        return this.getAttribute(el, attr, null);
    }

    private String getAttribute(StartElement el, String attr, String def) {
        Attribute attribute = el.getAttributeByName(new QName(attr));
        if (attribute != null) {
            return attribute.getValue();
        }
        return def;
    }

    private String getType(StartElement el) {
        return this.getAttribute(el, "type");
    }

    private IGmfComponent createComponent(StartElement el, IGmfComponent parent) {
        long id = StringUtil.toLong((String)el.getAttributeByName(new QName("id")).getValue(), (Long)-1L);
        String domain = this.getDomain(el);
        Long parentId = parent != null ? parent.getId() : -1L;
        IGmfComponent gmfComponent = this.gmfHelper.createComponent(id, parentId, null, domain, this.model);
        return gmfComponent;
    }

    private String getDomain(StartElement el) {
        String domain = this.getAttribute(el, "domain");
        if (domain == null) {
            return this.defaultDomain;
        }
        return domain;
    }

    private InputStream createInputStream(File file) throws IOException {
        ZipFile zip = null;
        if (FileUtil.isZipFile((File)file)) {
            zip = new ZipFile(file);
            ZipEntry entry = zip.getEntry("_model.xml");
            if (entry == null) {
                return null;
            }
            return new BufferedInputStream(zip.getInputStream(entry));
        }
        return new BufferedInputStream(new FileInputStream(file));
    }

    static enum STEP {
        OTHER,
        PARSE_META,
        PARSE_LIB,
        PARSE_RESOURCE;

    }
}

