/*
 * Decompiled with CFR 0.152.
 */
package net.ibee.gmf.util;

import java.util.ArrayList;
import java.util.List;
import net.edgemind.ibee.core.exception.IbeeException;
import net.edgemind.ibee.core.iml.model.IElement;
import net.edgemind.ibee.core.resource.IbeeResource;
import net.ibee.gmf.model.IGmfAttribute;
import net.ibee.gmf.model.IGmfComponent;
import net.ibee.gmf.model.IGmfDomain;
import net.ibee.gmf.model.IGmfElement;
import net.ibee.gmf.model.IGmfList;
import net.ibee.gmf.model.IGmfModel;
import net.ibee.gmf.model.IGmfRef;
import net.ibee.gmf.util.GmfResolver;

public class GmfHelper
extends GmfResolver {
    long lastFreeId = -1L;

    public GmfHelper(IbeeResource resource) {
        super(resource, null);
        this.setHelper(this);
        this.initCache(resource);
    }

    public IGmfComponent getParent(IGmfComponent component) {
        if (component == null) {
            return null;
        }
        Long parentId = component.getParentId();
        return this.resolve(parentId, component.giGetResource());
    }

    public IGmfComponent findParent(IGmfComponent el, String type) {
        IGmfComponent current = el;
        while (current != null) {
            String currentType = current.getType();
            if (currentType != null && currentType.equalsIgnoreCase(type)) {
                return current;
            }
            current = this.getParent(current);
        }
        return null;
    }

    public IGmfComponent removeComponent(IGmfComponent component, boolean recursive) {
        IGmfComponent parent;
        if (recursive) {
            component.clearAttributes();
            component.clearElements();
            component.clearLists();
        }
        if ((parent = this.getParent(component)) != null) {
            for (IGmfElement el : parent.getElements()) {
                IGmfRef ref = el.getRef();
                if (ref == null || ref.getId().longValue() != component.getId().longValue()) continue;
                parent.removeElement(el);
            }
            for (IGmfList list : parent.getLists()) {
                List<IGmfRef> refs = list.getRef();
                for (IGmfRef ref : refs) {
                    if (ref.getId().longValue() != component.getId().longValue()) continue;
                    list.removeRef(ref);
                }
                if (list.getRef().size() != 0) continue;
                parent.removeList(list);
            }
        }
        return component;
    }

    public IGmfElement removeElement(String name, IGmfComponent component) {
        IGmfElement element = this.getElement(name, component);
        if (element != null) {
            component.removeElement(element);
            this.cache.remove(component.getId());
        }
        return element;
    }

    public IGmfComponent createComponent(long id, long parentId, String type, String domain, IGmfModel model) {
        IGmfComponent component = IGmfDomain.instance.createGmfComponent();
        component.setId(id);
        component.setType(type);
        component.setDomain(domain);
        component.setParentId(parentId);
        model.addComponent(component);
        this.cache.put(component.getId(), component);
        return component;
    }

    public IGmfAttribute setAttribute(String name, String value, IGmfComponent component) {
        IGmfAttribute attr = this.getAttribute(name, component);
        if (attr == null) {
            attr = IGmfDomain.instance.createGmfAttribute();
            attr.setName(name);
            component.addAttribute(attr);
        }
        attr.setValue(value);
        return attr;
    }

    public IGmfAttribute getAttribute(String name, IGmfComponent component) {
        return this.getAttribute(name, component, false);
    }

    public IGmfAttribute getAttribute(String name, IGmfComponent component, boolean create) {
        for (IGmfAttribute attr : component.getAttributes()) {
            if (!attr.getName().equalsIgnoreCase(name)) continue;
            return attr;
        }
        if (create) {
            IGmfAttribute attr;
            attr = IGmfDomain.instance.createGmfAttribute();
            attr.setName(name);
            component.addAttribute(attr);
            return attr;
        }
        return null;
    }

    public String getAttributeValue(String name, IGmfComponent component) {
        return this.getAttributeValue(name, component, null);
    }

    public String getAttributeValue(String name, IGmfComponent component, String def) {
        for (IGmfAttribute attr : component.getAttributes()) {
            if (!attr.getName().equalsIgnoreCase(name)) continue;
            return attr.getValue();
        }
        return def;
    }

    public IGmfAttribute removeAttribute(String name, IGmfComponent component) {
        IGmfAttribute attr = this.getAttribute(name, component);
        if (attr != null) {
            component.removeAttribute(attr);
        }
        return attr;
    }

    public IGmfList getList(String name, IGmfComponent component) {
        for (IGmfList list : component.getLists()) {
            if (!list.getName().equalsIgnoreCase(name)) continue;
            return list;
        }
        return null;
    }

    public void removeListElement(String listName, IGmfComponent parent, IGmfComponent element) {
        IGmfList list = this.getList(listName, parent, false);
        if (list != null) {
            for (IGmfRef ref : new ArrayList<IGmfRef>(list.getRef())) {
                if (ref.getId() == null || !ref.getId().equals(element.getId())) continue;
                list.removeRef(ref);
            }
        }
    }

    public IGmfList removeList(String name, IGmfComponent component) {
        IGmfList list = this.getList(name, component);
        if (list != null) {
            component.removeList(list);
        }
        return list;
    }

    public IGmfElement getElement(String name, IGmfComponent component) {
        for (IGmfElement element : component.getElements()) {
            if (!element.getName().equalsIgnoreCase(name)) continue;
            return element;
        }
        return null;
    }

    public IGmfList createList(String name, IGmfComponent component) {
        return this.getList(name, component, true);
    }

    public IGmfList getList(String name, IGmfComponent component, boolean create) {
        if (component.getLists() != null) {
            for (IGmfList list : component.getLists()) {
                if (!list.getName().equalsIgnoreCase(name)) continue;
                return list;
            }
        }
        if (create) {
            IGmfList list;
            list = IGmfDomain.instance.createGmfList();
            component.addList(list);
            list.setName(name);
            return list;
        }
        return null;
    }

    public void disposeList(String listName, IGmfComponent parent) {
        IGmfList list = this.getList(listName, parent);
        if (list != null) {
            list.remove();
        }
    }

    public IGmfComponent createListChild(IGmfComponent parent, String listName, String childType) {
        IGmfList list = this.getList(listName, parent, true);
        IGmfModel model = (IGmfModel)parent.giGetResource().getRoot();
        long id = this.findFreeComponentId(model, 0L);
        IGmfComponent child = this.createComponent(id, parent.getId(), childType, parent.getDomain(), model);
        this.addListElement(list, child);
        return child;
    }

    public void addListElement(IGmfList list, IGmfComponent child) {
        list.getRef().add(this.createRef(child));
    }

    public IGmfComponent createChild(IGmfComponent parent, String elementFeature, String childType) {
        IGmfElement elementHandle = this.getElement(elementFeature, parent, true);
        IGmfModel model = (IGmfModel)parent.giGetResource().getRoot();
        long id = this.findFreeComponentId(model, 0L);
        IGmfComponent child = this.createComponent(id, parent.getId(), childType, parent.getDomain(), model);
        this.setChild(elementHandle, child);
        return child;
    }

    public void setChild(IGmfComponent parent, String elementFeature, IGmfComponent child) {
        IGmfElement elementHandle = this.getElement(elementFeature, parent, true);
        this.setChild(elementHandle, child);
    }

    public void setChild(IGmfElement elementHandle, IGmfComponent child) {
        elementHandle.setRef(this.createRef(child));
    }

    public IGmfElement createElement(String name, IGmfComponent component) {
        return this.getElement(name, component, true);
    }

    public IGmfElement getElement(String name, IGmfComponent component, boolean create) {
        if (component.getElements() != null) {
            for (IGmfElement element : component.getElements()) {
                if (!element.getName().equalsIgnoreCase(name)) continue;
                return element;
            }
        }
        if (create) {
            IGmfElement element;
            element = IGmfDomain.instance.createGmfElement();
            component.addElement(element);
            element.setName(name);
            return element;
        }
        return null;
    }

    public IGmfRef createRef(IGmfComponent component) {
        IGmfRef ref = IGmfDomain.instance.createGmfRef();
        ref.setId(component.getId());
        return ref;
    }

    public IGmfRef createRef(long id) {
        IGmfRef ref = IGmfDomain.instance.createGmfRef();
        ref.setId(id);
        return ref;
    }

    public IGmfModel getModel(IGmfComponent component) {
        return this.getModel(component.giGetResource());
    }

    public IGmfModel getModel(IbeeResource resource) {
        IElement root = resource.getRoot();
        if (root instanceof IGmfModel) {
            return (IGmfModel)root;
        }
        return null;
    }

    public long findFreeComponentId(IGmfModel model, long offset) {
        long freeId;
        if (this.lastFreeId == -1L) {
            long max = offset;
            for (IGmfComponent comp : model.getComponents()) {
                Long id = comp.getId();
                if (id == null || id < max) continue;
                max = comp.getId();
            }
            freeId = max + 1L;
        } else {
            freeId = this.lastFreeId + 1L;
        }
        this.lastFreeId = freeId;
        for (IGmfComponent comp : model.getComponents()) {
            if (comp.getId() != this.lastFreeId) continue;
            throw new IbeeException("id " + this.lastFreeId + " alreayd taken");
        }
        return freeId;
    }
}

