/*
 * Decompiled with CFR 0.152.
 */
package net.ibee.gmf.writer;

import java.io.File;
import java.io.IOException;
import net.edgemind.ibee.core.library.IbeeLibrary;
import net.edgemind.ibee.core.resource.IbeeResource;
import net.edgemind.ibee.util.xml.XmlUtil;
import net.ibee.gmf.model.IGmfAttribute;
import net.ibee.gmf.model.IGmfComponent;
import net.ibee.gmf.model.IGmfElement;
import net.ibee.gmf.model.IGmfList;
import net.ibee.gmf.model.IGmfModel;
import net.ibee.gmf.model.IGmfRef;
import net.ibee.gmf.util.GmfHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DomGmfWriter {
    GmfHelper resolver;

    public void write(IGmfModel model, File out) throws IOException {
        IGmfComponent rootComponent;
        this.resolver = new GmfHelper(model.giGetResource());
        Document doc = XmlUtil.createNewDocument();
        Element root = doc.createElement("model");
        String version = model.getVersion();
        if (version != null) {
            root.setAttribute("version", version);
        }
        if ((rootComponent = this.resolver.resolve(model.getRoot(), model.giGetResource())) != null) {
            root.setAttribute("root", String.valueOf(rootComponent.getId()));
        }
        doc.appendChild(root);
        this.writeComponents(model, root);
        this.writeLibraries(model.giGetResource(), root);
        XmlUtil.writeXmlFile((Document)doc, (String)out.getAbsolutePath());
    }

    public void writeLibraries(IbeeResource resource, Element parent) {
        for (IbeeLibrary lib : resource.getLibraries()) {
            String name = lib.getName();
            String url = resource.getDescriptor(lib).getUrl();
            Element xml = parent.getOwnerDocument().createElement("library");
            parent.appendChild(xml);
            xml.setAttribute("name", name);
            xml.setAttribute("url", url);
        }
    }

    public void writeComponents(IGmfModel model, Element parent) {
        for (IGmfComponent gmfComponent : model.getComponents()) {
            Element xmlComponent = parent.getOwnerDocument().createElement("element");
            parent.appendChild(xmlComponent);
            String type = gmfComponent.getType();
            String domain = gmfComponent.getDomain();
            Long id = gmfComponent.getId();
            Long parentId = gmfComponent.getParentId();
            if (type != null) {
                xmlComponent.setAttribute("type", type);
            }
            if (domain != null) {
                xmlComponent.setAttribute("domain", domain);
            }
            if (id != null) {
                xmlComponent.setAttribute("id", String.valueOf(id));
            }
            if (parentId != null) {
                XmlUtil.setAttribute((Element)xmlComponent, (String)"parent", (String)String.valueOf(parentId), (boolean)true);
            }
            this.writeAttributes(gmfComponent, xmlComponent);
            this.writeElements(gmfComponent, xmlComponent);
            this.writeLists(gmfComponent, xmlComponent);
        }
    }

    protected void writeAttributes(IGmfComponent component, Element parent) {
        for (IGmfAttribute attr : component.getAttributes()) {
            String name = attr.getName();
            String value = attr.getValue();
            Element xmlAttribute = parent.getOwnerDocument().createElement("attribute");
            parent.appendChild(xmlAttribute);
            xmlAttribute.setAttribute("name", name);
            xmlAttribute.setTextContent(value);
        }
    }

    protected void writeElements(IGmfComponent component, Element parent) {
        for (IGmfElement element : component.getElements()) {
            long id;
            String name = element.getName();
            IGmfRef ref = element.getRef();
            if (ref == null || (id = ref.getId().longValue()) < 0L) continue;
            Element xmlElement = parent.getOwnerDocument().createElement("element");
            parent.appendChild(xmlElement);
            xmlElement.setAttribute("name", name);
            Element xmlId = parent.getOwnerDocument().createElement("id");
            xmlElement.appendChild(xmlId);
            xmlId.setTextContent("" + id);
        }
    }

    protected void writeLists(IGmfComponent component, Element parent) {
        for (IGmfList list : component.getLists()) {
            String name = list.getName();
            StringBuffer buf = new StringBuffer();
            for (IGmfRef ref : list.getRef()) {
                long id;
                if (buf.length() > 0) {
                    buf.append(",");
                }
                if ((id = ref.getId().longValue()) < 0L) continue;
                buf.append("" + id);
            }
            if (buf.length() <= 0) continue;
            Element xmlList = parent.getOwnerDocument().createElement("list");
            parent.appendChild(xmlList);
            xmlList.setAttribute("name", name);
            Element xmlIds = parent.getOwnerDocument().createElement("ids");
            xmlList.appendChild(xmlIds);
            xmlIds.setTextContent(buf.toString());
        }
    }
}

