/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.q.analysis;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.edgemind.ibee.core.iml.domain.IElementType;
import net.edgemind.ibee.core.iml.model.IElement;
import net.edgemind.ibee.core.log.LogLevel;
import net.edgemind.ibee.core.log.LogUtil;
import net.edgemind.ibee.core.resource.IbeeResource;
import net.edgemind.ibee.q.exception.QuantificationException;
import net.edgemind.ibee.q.model.yams.IBranch;
import net.edgemind.ibee.q.model.yams.IEvent;
import net.edgemind.ibee.q.model.yams.IIndicator;
import net.edgemind.ibee.q.model.yams.IMeasurement;
import net.edgemind.ibee.q.model.yams.IResult;
import net.edgemind.ibee.q.model.yams.ISequence;
import net.edgemind.ibee.q.model.yams.ITransition;
import net.edgemind.ibee.q.model.yams.IYamsresult;
import net.edgemind.ibee.q.model.yams.IYamsresultDomain;
import net.edgemind.ibee.q.model.yams.Severity;
import net.edgemind.ibee.q.model.yams.State;
import net.edgemind.ibee.q.yams.YamsQuantification;
import net.edgemind.ibee.util.string.StringUtil;
import net.edgemind.ibee.util.xml.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class YamsResultParser {
    public static final String INDICATOR_NAME_FIRST_OCCURRENCE = "top_fails_occ1";
    public static final String INDICATOR_NAME_MTTF = "mttf";
    public static final String INDICATOR_NAME_OCCURRENCE = "top_fails_occ";
    private YamsQuantification configuration;
    private IbeeResource resultResource;
    NameResolver nameResolver;
    private Handler handler;

    public void setNameResolver(NameResolver resolver) {
        this.nameResolver = resolver;
    }

    public void setHandler(Handler handler) {
        this.handler = handler;
    }

    public void init(YamsQuantification configuration) {
        this.configuration = configuration;
    }

    public void parseResults(File mcrFile, IbeeResource resource) throws QuantificationException {
        Document doc;
        this.resultResource = resource;
        try {
            doc = XmlUtil.readXmlFile((String)mcrFile.getAbsolutePath());
        }
        catch (IOException e) {
            throw new QuantificationException(e);
        }
        Element xmlAmcSorties = doc.getDocumentElement();
        IYamsresult root = IYamsresultDomain.instance.createYamsresult();
        this.resultResource.setRoot((IElement)root);
        IResult result = IYamsresultDomain.instance.createResult();
        root.setResult(result);
        LogUtil.log((String)("resrouce url " + String.valueOf(root.giGetResource().getURL())));
        this.parseIndicators(xmlAmcSorties, result);
        this.parseSequences(xmlAmcSorties, result);
        this.performSequencePostTreatment(result);
        List events = result.giGetResource().getAllObjects(IEvent.type);
        if (this.nameResolver != null) {
            for (IElement event : events) {
                String eventName = ((IEvent)event).getName();
                eventName = this.nameResolver.resolve(eventName);
                ((IEvent)event).setName(eventName);
            }
        }
    }

    private void performSequencePostTreatment(IResult result) {
        this.filterSequences(result);
        this.calcContributionValues(result);
        this.calcSeverity(result);
    }

    private void parseIndicators(Element xmlAmcSorties, IResult result) throws QuantificationException {
        Element xmlIndicateurs = XmlUtil.getFirstChildByTagName((String)"INDICATEURS", (Element)xmlAmcSorties);
        if (xmlIndicateurs != null) {
            List xmlIndicateurList = XmlUtil.getChildrenByTagName((String)"INDICATEUR", (Element)xmlIndicateurs);
            for (Element xmlIndicator : xmlIndicateurList) {
                this.parseIndicator(xmlIndicator, result);
            }
        }
    }

    private double getPFirstOccurrence(IResult result) {
        double pFirstOccurrence = 0.0;
        for (IIndicator indicator : result.getIndicator()) {
            if (!indicator.getName().equals(INDICATOR_NAME_FIRST_OCCURRENCE)) continue;
            pFirstOccurrence = this.getProbabilityTotal(indicator);
        }
        return pFirstOccurrence;
    }

    private void parseSequences(Element xmlAmcSorties, IResult result) {
        Element xmlProbabilitiesSequences = XmlUtil.getFirstChildByTagName((String)"PROBABILITES_SEQUENCES", (Element)xmlAmcSorties);
        if (xmlProbabilitiesSequences != null) {
            List xmlSequences = XmlUtil.getChildrenByTagName((String)"SEQUENCE", (Element)xmlProbabilitiesSequences);
            int sequenceCount = 0;
            for (Element xmlSequence : xmlSequences) {
                this.parseSequence(xmlSequence, result);
                if (++sequenceCount >= this.configuration.maxNrSequences) break;
            }
        }
    }

    private void filterSequences(IResult result) {
        ArrayList<ISequence> toRemove = new ArrayList<ISequence>();
        double pFirstOccurrence = this.getPFirstOccurrence(result);
        for (ISequence sequence : result.getSequences()) {
            if (sequence.getProbability() < this.configuration.seqMinProbability) {
                toRemove.add(sequence);
                continue;
            }
            double contribution = sequence.getProbability() / pFirstOccurrence;
            if (!(contribution < this.configuration.seqMinContribution)) continue;
            toRemove.add(sequence);
        }
        for (ISequence sequence : toRemove) {
            result.removeSequence(sequence);
        }
    }

    private void calcContributionValues(IResult result) {
        double pFirstOccurrence = this.getPFirstOccurrence(result);
        double contributionSum = 0.0;
        for (ISequence sequence : result.getSequences()) {
            double contribution = sequence.getProbability() / pFirstOccurrence;
            sequence.setContribution(contribution);
            sequence.setContributionSum(contributionSum += contribution);
        }
    }

    private void calcSeverity(IResult result) {
        for (ISequence sequence : result.getSequences()) {
            Severity severity = sequence.getProbability() > 0.05 ? Severity.CRITICAL : (sequence.getProbability() > 0.01 ? Severity.NORMAL : Severity.MINOR);
            sequence.setSeverity(severity);
        }
    }

    private double getProbabilityTotal(IIndicator indicator) {
        int indexOfLastMeasurement = indicator.getMeasurements().size() - 1;
        if (indexOfLastMeasurement < 0) {
            return 0.0;
        }
        IMeasurement lastMeasurement = indicator.getMeasurements().get(indexOfLastMeasurement);
        return lastMeasurement.getProbability();
    }

    private void parseIndicator(Element xmlIndicator, IResult result) {
        IIndicator indicator = IYamsresultDomain.instance.createIndicator();
        result.addIndicator(indicator);
        String indicatorName = XmlUtil.getAttribute((Element)xmlIndicator, (String)"NOM", (boolean)false);
        indicator.setName(indicatorName);
        Element xmlCombinaison = XmlUtil.getFirstChildByTagName((String)"COMBINAISON", (Element)xmlIndicator);
        if (xmlCombinaison != null) {
            List xmlValeurs = XmlUtil.getChildrenByTagName((String)"VALEURS", (Element)xmlCombinaison);
            for (Element xmlValeur : xmlValeurs) {
                IMeasurement measurement = IYamsresultDomain.instance.createMeasurement();
                indicator.addMeasurement(measurement);
                int timePoint = StringUtil.toInt((String)XmlUtil.getAttribute((Element)xmlValeur, (String)"INSTANT", (boolean)false), (Integer)0);
                double probability = StringUtil.toDouble((String)XmlUtil.getAttribute((Element)xmlValeur, (String)"MOYENNE", (boolean)false), (double)0.0);
                double variance = StringUtil.toDouble((String)XmlUtil.getAttribute((Element)xmlValeur, (String)"VARIANCE", (boolean)false), (double)0.0);
                double confidence = StringUtil.toDouble((String)XmlUtil.getAttribute((Element)xmlValeur, (String)"INT_CONFIANCE", (boolean)false), (double)0.0);
                measurement.setTimestamp(timePoint);
                measurement.setProbability(probability);
                measurement.setVariance(variance);
                measurement.setConfidence(confidence);
            }
        }
    }

    private void parseSequence(Element xmlSequence, IResult result) {
        ISequence sequence = (ISequence)this.createObject(ISequence.type);
        result.addSequence(sequence);
        int sequenceNumber = result.getSequences().size();
        sequence.setNumber(sequenceNumber);
        this.parseSequenceProbability(xmlSequence, sequence);
        this.parseSequenceBranches(xmlSequence, sequence);
    }

    private void parseSequenceBranches(Element xmlSequence, ISequence sequence) {
        List xmlBranches = XmlUtil.getChildrenByTagName((String)"BRANCHE", (Element)xmlSequence);
        int nrBranches = 0;
        double datePreviousBranch = -1.0;
        IBranch currentBranch = null;
        for (Element xmlBranche : xmlBranches) {
            String dateCurrentBranchString = xmlBranche.getAttribute("DATE_FIN_MOY");
            double dateCurrentBranch = StringUtil.toDouble((String)dateCurrentBranchString, (double)-1.0);
            if (currentBranch == null || dateCurrentBranch != datePreviousBranch) {
                currentBranch = (IBranch)this.createObject(IBranch.type);
                sequence.addBranche(currentBranch);
                currentBranch.setDateFin(dateCurrentBranch);
                ++nrBranches;
            }
            datePreviousBranch = dateCurrentBranch;
            List<ITransition> transitions = this.parseTransitions(xmlBranche);
            for (ITransition transition : transitions) {
                currentBranch.addTransition(transition);
            }
            if (nrBranches >= this.configuration.maxNrEvents) break;
        }
    }

    private void parseSequenceProbability(Element xmlSequence, ISequence sequence) {
        double p = StringUtil.toDouble((String)xmlSequence.getAttribute("PROBABILITE"), (double)-1.0);
        if (p != -1.0) {
            sequence.setProbability(p);
        }
    }

    private List<ITransition> parseTransitions(Element xmlBranche) {
        ArrayList<ITransition> result = new ArrayList<ITransition>();
        List xmlTransitions = XmlUtil.getChildrenByTagName((String)"TRANSITION", (Element)xmlBranche);
        for (Element xmlTransition : xmlTransitions) {
            IEvent event;
            ITransition transition;
            if (this.ignoreTransition(xmlTransition, transition = (ITransition)this.createObject(ITransition.type))) continue;
            result.add(transition);
            this.setTransitionState(xmlTransition, transition);
            Object transitionObjectString = xmlTransition.getAttribute("OBJET");
            if (this.isCCFTransition(xmlTransition)) {
                transitionObjectString = (String)transitionObjectString + "_" + this.getDigitsOfCCFEvent(xmlTransition);
            }
            if ((event = this.createYamsEvent((String)transitionObjectString, (IYamsresult)this.resultResource.getRoot())) != null) {
                transition.setEvent(event);
                continue;
            }
            LogUtil.log((String)("transition not connected to an event " + (String)transitionObjectString), (LogLevel)LogLevel.ERROR);
        }
        return result;
    }

    private boolean ignoreTransition(Element xmlTransition, ITransition transition) {
        if (this.handler != null) {
            return !this.handler.acceptTransition(xmlTransition);
        }
        if (XmlUtil.testAttribute((String)"rep", (Element)xmlTransition, (String)"TRANS", (boolean)false)) {
            return false;
        }
        if (XmlUtil.testAttribute((String)"deff", (Element)xmlTransition, (String)"TRANS", (boolean)false)) {
            return false;
        }
        if (XmlUtil.testAttribute((String)"defi", (Element)xmlTransition, (String)"TRANS", (boolean)false)) {
            return false;
        }
        if (XmlUtil.testAttribute((String)"bon", (Element)xmlTransition, (String)"TRANS", (boolean)false)) {
            return true;
        }
        if (this.isCCFTransition(xmlTransition)) {
            int nrCCFEvents = this.getNumberOfCCFEvents(xmlTransition);
            if (nrCCFEvents <= 1) {
                LogUtil.log((String)("figaro sequence parser: ignore ccf transition '" + XmlUtil.getAttribute((Element)xmlTransition, (String)"TRANS", (boolean)false) + "'"), (LogLevel)LogLevel.INFO);
                return true;
            }
            return false;
        }
        LogUtil.log((String)("figaro sequence parser: ignore unknown transition '" + XmlUtil.getAttribute((Element)xmlTransition, (String)"TRANS", (boolean)false) + "'"), (LogLevel)LogLevel.WARNING);
        return true;
    }

    private void setTransitionState(Element xmlTransition, ITransition transition) {
        if (this.handler != null) {
            State state = this.handler.getState(xmlTransition);
            if (state != null) {
                transition.setState(state);
            }
            return;
        }
        if (XmlUtil.testAttribute((String)"rep", (Element)xmlTransition, (String)"TRANS", (boolean)false)) {
            transition.setState(State.OK);
        } else if (XmlUtil.testAttribute((String)"deff", (Element)xmlTransition, (String)"TRANS", (boolean)false)) {
            transition.setState(State.ERROR);
        } else if (XmlUtil.testAttribute((String)"defi", (Element)xmlTransition, (String)"TRANS", (boolean)false)) {
            transition.setState(State.ERROR);
        } else {
            transition.setState(State.ERROR);
        }
    }

    private boolean isCCFTransition(Element transition) {
        String transString = transition.getAttribute("TRANS");
        if (transString == null) {
            return false;
        }
        boolean hasLeadingCCFStringCritera = transString.toLowerCase().startsWith("ccf_");
        if (!hasLeadingCCFStringCritera) {
            return false;
        }
        String digits = transString.substring("ccf_".length());
        Matcher matcher = Pattern.compile("\\d+").matcher(digits);
        return matcher.find();
    }

    private String getDigitsOfCCFEvent(Element transition) {
        String transString = transition.getAttribute("TRANS");
        String digits = transString.substring("ccf_".length());
        return digits;
    }

    private int getNumberOfCCFEvents(Element transition) {
        String transString = transition.getAttribute("TRANS");
        String digits = transString.substring("ccf_".length());
        return digits.length();
    }

    private IEvent createYamsEvent(String name, IYamsresult yamsResult) {
        if (name != null && name.length() > 0) {
            IEvent event2;
            for (IEvent event2 : yamsResult.getEvents()) {
                if (!event2.getName().equalsIgnoreCase(name)) continue;
                return event2;
            }
            event2 = IYamsresultDomain.instance.createEvent();
            yamsResult.addEvent(event2);
            event2.setName(name);
            return event2;
        }
        return null;
    }

    private IElement createObject(IElementType type) {
        return this.resultResource.create(type);
    }

    public static interface Handler {
        public boolean acceptTransition(Element var1);

        public State getState(Element var1);
    }

    public static interface NameResolver {
        public String resolve(String var1);
    }
}

