/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.q.scram;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.edgemind.ibee.core.exception.IbeeException;
import net.edgemind.ibee.util.xml.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ScramConfigfileCreator {
    private Document doc;
    private double minProbability = 0.0;
    private int maxOrder = 0;
    private String mftFile = "mft.xml";
    private String algo = "mocus";
    private double timeStep = 0.0;
    private String approximation;
    private int sensitvitySims = 0;
    private double missionTime = 24.0;

    public void setMinProbability(double p) {
        this.minProbability = p;
    }

    public void setMaxOrder(int order) {
        this.maxOrder = order;
    }

    public void setSensivitySims(int nr) {
        this.sensitvitySims = nr;
    }

    public void setMissionTime(double mt) {
        this.missionTime = mt;
    }

    public void setMftFile(String file) {
        this.mftFile = file;
    }

    public void setAlgo(String algo) {
        this.algo = algo;
    }

    public void setTimeStep(double timeStep) {
        this.timeStep = timeStep;
    }

    public void setApproximation(String approximation) {
        this.approximation = approximation;
    }

    public void createConfig(String configFile) throws IbeeException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            this.doc = docBuilder.newDocument();
            Element rootElement = this.doc.createElement("scram");
            this.doc.appendChild(rootElement);
            this.createSections(rootElement);
            XmlUtil.writeXmlFile((Document)this.doc, (String)configFile);
        }
        catch (ParserConfigurationException e) {
            throw new IbeeException((Throwable)e);
        }
        catch (Exception e) {
            throw new IbeeException((Throwable)e);
        }
    }

    private void createSections(Element root) throws IbeeException {
        this.createLoadSection(root);
        this.createOptionsSection(root);
    }

    private void createLoadSection(Element parent) {
        Element elInputFiles = this.doc.createElement("model");
        parent.appendChild(elInputFiles);
        Element elFile = this.doc.createElement("file");
        elInputFiles.appendChild(elFile);
        elFile.setTextContent(this.mftFile);
    }

    private void createOptionsSection(Element parent) {
        Element elOptions = this.doc.createElement("options");
        parent.appendChild(elOptions);
        Element elAlgorithm = this.doc.createElement("algorithm");
        elOptions.appendChild(elAlgorithm);
        elAlgorithm.setAttribute("name", this.algo);
        Element elAnalysis = this.doc.createElement("analysis");
        elOptions.appendChild(elAnalysis);
        elAnalysis.setAttribute("probability", "true");
        elAnalysis.setAttribute("importance", "true");
        if (this.sensitvitySims > 0) {
            elAnalysis.setAttribute("uncertainty", "true");
        } else {
            elAnalysis.setAttribute("uncertainty", "false");
        }
        if (this.approximation != null) {
            Element elApproximation = this.doc.createElement("approximation");
            elOptions.appendChild(elApproximation);
            elApproximation.setAttribute("name", this.approximation);
        }
        this.createLimitations(elOptions);
    }

    private void createLimitations(Element parent) {
        Element elLimits = this.doc.createElement("limits");
        parent.appendChild(elLimits);
        if (this.maxOrder > 0) {
            XmlUtil.setAttribute((Element)elLimits, (String)"product-order", (String)("" + this.maxOrder), (boolean)true);
        }
        XmlUtil.setAttribute((Element)elLimits, (String)"mission-time", (String)("" + this.missionTime), (boolean)true);
        if (this.minProbability > 0.0) {
            XmlUtil.setAttribute((Element)elLimits, (String)"cut-off", (String)("" + this.minProbability), (boolean)true);
        }
        if (this.sensitvitySims > 0) {
            XmlUtil.setAttribute((Element)elLimits, (String)"number-of-trials", (String)("" + this.sensitvitySims), (boolean)true);
        }
        if (this.timeStep > 0.0) {
            XmlUtil.setAttribute((Element)elLimits, (String)"time-step", (String)("" + this.timeStep), (boolean)true);
        }
    }
}

