/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.q.scram;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import net.edgemind.ibee.core.exception.IbeeException;
import net.edgemind.ibee.util.file.FileUtil;
import net.edgemind.ibee.util.xml.XmlUtil;
import org.w3c.dom.DOMException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ScramResultConverter2 {
    private ResultAdapter adapter;
    private XMLStreamWriter out;
    private int indent = 0;
    private boolean prettyPrint = true;

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public void setAdapter(ResultAdapter resolver) {
        this.adapter = resolver;
    }

    private Map<String, String> toMap(Attributes attributes) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        int i = 0;
        while (i < attributes.getLength()) {
            String key = attributes.getQName(i);
            String value = attributes.getValue(i);
            if (value != null) {
                map.put(key, value);
            }
            ++i;
        }
        return map;
    }

    public void convertScramResultFile(File in, File outfile) {
        try {
            FileOutputStream outputStream = new FileOutputStream(outfile);
            this.out = XmlUtil.createStreamWriter((Writer)new OutputStreamWriter((OutputStream)outputStream, "utf-8"));
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            parser.parse(in, (DefaultHandler)new MyXMLHandler());
            this.out.close();
        }
        catch (DOMException e) {
            throw new IbeeException((Throwable)e);
        }
        catch (XMLStreamException e) {
            throw new IbeeException((Throwable)e);
        }
        catch (SAXException e) {
            throw new IbeeException((Throwable)e);
        }
        catch (IOException e) {
            throw new IbeeException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new IbeeException((Throwable)e);
        }
    }

    public void openTag(String name) throws XMLStreamException {
        this.out.writeStartElement(name);
        ++this.indent;
    }

    public void closeTag() throws XMLStreamException {
        this.out.writeEndElement();
        --this.indent;
    }

    public void openEmptyTag(String name) throws XMLStreamException {
        this.out.writeEmptyElement(name);
        --this.indent;
    }

    private void indent() throws XMLStreamException {
        if (this.prettyPrint) {
            int i = 0;
            while (i < this.indent) {
                this.out.writeCharacters("  ");
                ++i;
            }
        }
    }

    private void nl() throws XMLStreamException {
        this.out.writeCharacters(FileUtil.lineSeparator());
    }

    public class MyXMLHandler
    extends DefaultHandler {
        private String notYetWrittenTag;
        private Map<String, String> notYetWrittenAttributes;

        @Override
        public void startDocument() throws SAXException {
            try {
                ScramResultConverter2.this.out.writeStartDocument();
            }
            catch (XMLStreamException e) {
                throw new IbeeException((Throwable)e);
            }
        }

        @Override
        public void endDocument() throws SAXException {
            try {
                ScramResultConverter2.this.out.writeEndDocument();
            }
            catch (XMLStreamException e) {
                throw new IbeeException((Throwable)e);
            }
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            try {
                if (this.notYetWrittenTag != null) {
                    ScramResultConverter2.this.openTag(this.notYetWrittenTag);
                    if (this.notYetWrittenAttributes != null) {
                        this.writeAttributes(this.notYetWrittenAttributes);
                    }
                }
                this.notYetWrittenTag = qName;
                this.notYetWrittenAttributes = ScramResultConverter2.this.adapter.adaptAttr(qName, ScramResultConverter2.this.toMap(attributes));
            }
            catch (XMLStreamException e) {
                throw new IbeeException((Throwable)e);
            }
        }

        private void writeAttributes(Map<String, String> attributes) throws XMLStreamException {
            for (String key : attributes.keySet()) {
                String value = attributes.get(key);
                if (value == null) continue;
                ScramResultConverter2.this.out.writeAttribute(key, value);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            try {
                if (this.notYetWrittenTag != null) {
                    ScramResultConverter2.this.openEmptyTag(this.notYetWrittenTag);
                    if (this.notYetWrittenAttributes != null) {
                        this.writeAttributes(this.notYetWrittenAttributes);
                    }
                    this.notYetWrittenTag = null;
                    this.notYetWrittenAttributes = null;
                } else {
                    ScramResultConverter2.this.closeTag();
                }
            }
            catch (XMLStreamException e) {
                throw new IbeeException((Throwable)e);
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            try {
                if (this.notYetWrittenTag != null) {
                    ScramResultConverter2.this.openTag(this.notYetWrittenTag);
                    if (this.notYetWrittenAttributes != null) {
                        this.writeAttributes(this.notYetWrittenAttributes);
                    }
                    this.notYetWrittenTag = null;
                    this.notYetWrittenAttributes = null;
                }
                ScramResultConverter2.this.out.writeCharacters(ch, start, length);
            }
            catch (XMLStreamException e) {
                throw new SAXException(e);
            }
        }
    }

    public static interface ResultAdapter {
        public Map<String, String> adaptAttr(String var1, Map<String, String> var2);
    }
}

