/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.q.xfta;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.edgemind.ibee.core.exception.IbeeException;
import net.edgemind.ibee.util.file.FileUtil;
import net.edgemind.ibee.util.xml.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XftaConfigfileCreator {
    private Document doc;
    private double minProbability = 0.0;
    private int maxOrder = 0;
    private String resultFile = "result.xml";
    private String resultFileImportanceFactors = "result_if.xml";
    private String resultFileSensitivity = "result_sens.xml";
    private String mftFile = "mft.xml";
    private String topEvent = "top";
    private int sensitvitySims = 0;
    private double missionTime = 24.0;

    public void setMinProbability(double p) {
        this.minProbability = p;
    }

    public void setMaxOrder(int order) {
        this.maxOrder = order;
    }

    public void setSensivitySims(int nr) {
        this.sensitvitySims = nr;
    }

    public void setMissionTime(double mt) {
        this.missionTime = mt;
    }

    public void setResultFile(String file) {
        this.resultFile = file;
        this.resultFileImportanceFactors = XftaConfigfileCreator.getImportanceFactorResultFile(this.resultFile);
        this.resultFileSensitivity = XftaConfigfileCreator.getSensitivityResultFile(this.resultFile);
    }

    public static String getImportanceFactorResultFile(String resultFile) {
        Object tmp = FileUtil.replaceExtension((String)resultFile, null);
        tmp = (String)tmp + "_if";
        return FileUtil.replaceExtension((String)tmp, (String)FileUtil.getExtension((String)resultFile));
    }

    public static String getSensitivityResultFile(String resultFile) {
        Object tmp = FileUtil.replaceExtension((String)resultFile, null);
        tmp = (String)tmp + "_sens";
        return FileUtil.replaceExtension((String)tmp, (String)FileUtil.getExtension((String)resultFile));
    }

    public static String getPrResultFile(String resultFile) {
        Object tmp = FileUtil.replaceExtension((String)resultFile, null);
        tmp = (String)tmp + "_pr";
        return FileUtil.replaceExtension((String)tmp, (String)FileUtil.getExtension((String)resultFile));
    }

    public void setMftFile(String file) {
        this.mftFile = file;
    }

    public void setTopEvent(String event) {
        this.topEvent = event;
    }

    public void createConfig(String configFile) throws IbeeException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            this.doc = docBuilder.newDocument();
            Element rootElement = this.doc.createElement("xfta");
            this.doc.appendChild(rootElement);
            this.createSections(rootElement);
            XmlUtil.writeXmlFile((Document)this.doc, (String)configFile);
        }
        catch (ParserConfigurationException e) {
            throw new IbeeException((Throwable)e);
        }
        catch (Exception e) {
            throw new IbeeException((Throwable)e);
        }
    }

    private void createSections(Element root) throws IbeeException {
        this.createLoadSection(root);
        this.createBuildSection(root);
        this.createSetSection(root);
        this.createPrintSection(root);
        this.createComputeSection(root);
    }

    private void createLoadSection(Element parent) {
        Element elLoad = this.doc.createElement("load");
        parent.appendChild(elLoad);
        Element elModel = this.doc.createElement("model");
        elLoad.appendChild(elModel);
        elModel.setAttribute("input", this.mftFile);
    }

    private void createBuildSection(Element parent) {
        Element elBuild = this.doc.createElement("build");
        parent.appendChild(elBuild);
        Element elMincs = this.doc.createElement("minimal-cutsets");
        elBuild.appendChild(elMincs);
        elMincs.setAttribute("top-event", this.topEvent);
        elMincs.setAttribute("handle", "MCS");
        if (this.maxOrder > 0) {
            elMincs.setAttribute("maximum-order", "" + this.maxOrder);
        }
        if (this.minProbability > 0.0) {
            elMincs.setAttribute("minimum-probability", "" + this.minProbability);
        }
    }

    private void createSetSection(Element parent) {
        Element elSet = this.doc.createElement("set");
        parent.appendChild(elSet);
        Element elOption = this.doc.createElement("option");
        elSet.appendChild(elOption);
        elOption.setAttribute("name", "print-minimal-cutset-rank");
        elOption.setAttribute("value", "on");
        elOption = this.doc.createElement("option");
        elSet.appendChild(elOption);
        elOption.setAttribute("name", "print-minimal-cutset-order");
        elOption.setAttribute("value", "off");
        elOption = this.doc.createElement("option");
        elSet.appendChild(elOption);
        elOption.setAttribute("name", "print-minimal-cutset-probability");
        elOption.setAttribute("value", "on");
        elOption = this.doc.createElement("option");
        elSet.appendChild(elOption);
        elOption.setAttribute("name", "print-minimal-cutset-contribution");
        elOption.setAttribute("value", "on");
        elOption = this.doc.createElement("option");
        elSet.appendChild(elOption);
        elOption.setAttribute("name", "randomizer-seed");
        elOption.setAttribute("value", "4521585");
        elOption = this.doc.createElement("option");
        elSet.appendChild(elOption);
        elOption.setAttribute("name", "mission-time");
        elOption.setAttribute("value", "" + (int)this.missionTime);
    }

    private void createPrintSection(Element parent) {
        Element elPrint = this.doc.createElement("print");
        parent.appendChild(elPrint);
        Element elMincs = this.doc.createElement("minimal-cutsets");
        elPrint.appendChild(elMincs);
        elMincs.setAttribute("top-event", this.topEvent);
        elMincs.setAttribute("handle", "MCS");
        elMincs.setAttribute("output", this.resultFile);
    }

    private void createComputeSection(Element parent) {
        Element elCompute = this.doc.createElement("compute");
        parent.appendChild(elCompute);
        Element elProbability = this.doc.createElement("probability");
        elCompute.appendChild(elProbability);
        elProbability.setAttribute("top-event", this.topEvent);
        elProbability.setAttribute("handle", "MCS");
        elProbability.setAttribute("output", XftaConfigfileCreator.getPrResultFile(this.resultFile));
        Element elIF = this.doc.createElement("importance-factors");
        elCompute.appendChild(elIF);
        elIF.setAttribute("top-event", this.topEvent);
        elIF.setAttribute("handle", "MCS");
        elIF.setAttribute("output", this.resultFileImportanceFactors);
        if (this.sensitvitySims > 0) {
            Element elSens = this.doc.createElement("sensitivity");
            elCompute.appendChild(elSens);
            elSens.setAttribute("top-event", this.topEvent);
            elSens.setAttribute("mission-time", "" + this.missionTime);
            elSens.setAttribute("handle", "MCS");
            elSens.setAttribute("number-of-tries", "" + this.sensitvitySims);
            elSens.setAttribute("print-basic-event-sensitivity", "on");
            elSens.setAttribute("print-parameter-sensitivity", "on");
            elSens.setAttribute("number-of-quantiles", "20");
            elSens.setAttribute("number-of-bins", "20");
            elSens.setAttribute("output", this.resultFileSensitivity);
        }
    }
}

