/*
 * Decompiled with CFR 0.152.
 */
package fr.edf.ibee.swt.core.table;

import fr.edf.ibee.swt.core.table.IObjectFilter;
import fr.edf.ibee.swt.core.table.ITreeContentProvider;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;

public abstract class ALazyTreeContentProvider
implements ITreeContentProvider {
    protected HashMap<Object, Object[]> mChilds = new HashMap();
    protected HashMap<Object, Object[]> mChildsFiltered = new HashMap();
    private boolean withCaching = true;
    protected Object mModelInput;
    protected IObjectFilter mFilter = null;
    protected TreeViewer mViewer;
    public int limit = -1;

    public void dispose() {
        this.clearFull();
    }

    @Override
    public Object[] getObjects(Object e) {
        if (this.withCaching && this.mChilds.containsKey(e)) {
            return this.mChilds.get(e);
        }
        Object[] obj = this.getChildren(e);
        if (obj == null) {
            obj = new Object[]{};
        }
        if (this.withCaching) {
            this.mChilds.put(e, obj);
        }
        return obj;
    }

    @Override
    public Object[] getObjectsFiltered(Object e) {
        Object[] objFiltered;
        if (this.withCaching && this.mChildsFiltered.containsKey(e)) {
            return this.mChildsFiltered.get(e);
        }
        Object[] obj = this.getObjects(e);
        if (this.limit >= 0 || this.mFilter != null) {
            ArrayList<Object> obj2 = new ArrayList<Object>(obj.length);
            Object[] objectArray = obj;
            int n = obj.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                if (this.mFilter == null || this.mFilter.select(o)) {
                    obj2.add(o);
                }
                if (this.limit >= 0 && obj2.size() >= this.limit) break;
                ++n2;
            }
            objFiltered = obj2.toArray();
        } else {
            objFiltered = obj;
        }
        if (this.withCaching) {
            this.mChildsFiltered.put(e, objFiltered);
        }
        return objFiltered;
    }

    public void updateChildCount(Object element, int currentChildCount) {
        int childCnt = this.getObjectsFiltered(element).length;
        this.mViewer.setChildCount(element, childCnt);
    }

    @Override
    public boolean hasChildren(Object object) {
        Object[] childs = this.getObjectsFiltered(object);
        return childs != null && childs.length > 0;
    }

    public void updateElement(Object parent, int index) {
        if (index >= this.getObjectsFiltered(parent).length) {
            return;
        }
        Object element = this.getObjectsFiltered(parent)[index];
        if (element == null) {
            return;
        }
        this.mViewer.replace(parent, index, element);
        this.mViewer.setHasChildren(element, this.hasChildren(element));
    }

    public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
        this.mModelInput = arg2;
        this.mViewer = (TreeViewer)arg0;
    }

    @Override
    public void clearFull() {
        this.mChildsFiltered.clear();
        this.mChilds.clear();
    }

    @Override
    public void clearFull(Object object) {
        this.mChildsFiltered.remove(object);
        this.mChilds.remove(object);
    }

    @Override
    public void clearFilter() {
        this.mChildsFiltered.clear();
    }

    @Override
    public void setFilter(IObjectFilter filter) {
        this.mFilter = filter;
    }

    @Override
    public void setLimit(int limit) {
        this.limit = limit;
    }

    @Override
    public int getLimit() {
        return this.limit;
    }

    public boolean withFilter() {
        return this.withCaching;
    }

    public void withFilter(boolean withFilter) {
        this.withCaching = withFilter;
    }
}

