/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.swt.core.app;

import java.util.ArrayList;
import java.util.List;
import net.edgemind.ibee.swt.core.app.ISwtWidget;
import net.edgemind.ibee.swt.core.renderer.SWTMenuRenderer;
import net.edgemind.ibee.ui.menu.IMenu;
import net.edgemind.ibee.ui.menu.IMenuProvider;
import net.edgemind.ibee.ui.menu.MenuFactory;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;

public abstract class SwtWidget
implements ISwtWidget {
    private List<IMenuProvider> popupProviders;

    public void addContextMenuProvider(IMenuProvider provider) {
        if (this.popupProviders == null) {
            this.popupProviders = new ArrayList<IMenuProvider>();
        }
        if (!this.popupProviders.contains(provider)) {
            this.popupProviders.add(provider);
        }
    }

    public void removeContextMenuProvider(IMenuProvider provider) {
        if (this.popupProviders == null) {
            return;
        }
        this.popupProviders.remove(provider);
    }

    @Override
    public void createContextMenu(Control parent) {
        final Menu swtMenu = new Menu(parent);
        parent.setMenu(swtMenu);
        swtMenu.addMenuListener(new MenuListener(){

            public void menuShown(MenuEvent e) {
                if (SwtWidget.this.popupProviders == null) {
                    return;
                }
                IMenu menu = MenuFactory.createMenu();
                for (IMenuProvider provider : SwtWidget.this.popupProviders) {
                    menu.addItems(provider.create());
                }
                SWTMenuRenderer renderer = new SWTMenuRenderer(swtMenu);
                renderer.setAutoClear(true);
                renderer.renderMenu(menu, 0.0, 0.0);
            }

            public void menuHidden(MenuEvent e) {
            }
        });
    }
}

