/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.swt.core.dialog;

import java.util.Date;
import net.edgemind.ibee.core.exception.IbeeException;
import net.edgemind.ibee.swt.core.dialog.ADialog;
import net.edgemind.ibee.swt.core.dialog.IMonitor;
import net.edgemind.ibee.swt.core.dialog.IRunnableWithProgress;
import net.edgemind.ibee.swt.core.util.SwtUtil;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DlgExecution
extends ADialog {
    private Label currentTask;
    private Button btnCancel;
    private boolean canceled = false;
    private Text log;
    private boolean running = false;
    private IRunnableWithProgress runnable;
    private IProgressMonitor monitor;

    public DlgExecution(Shell parent, String title) {
        super(parent, title);
    }

    public void execute(IRunnableWithProgress runnable) throws IbeeException {
        this.runnable = runnable;
        this.blocking = false;
        this.open();
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    DlgExecution.this.canceled = false;
                    DlgExecution.this.perform();
                }
                catch (IbeeException ibeeException) {}
            }
        };
        t.start();
    }

    @Override
    public void createContents(Composite parent) {
        super.setDoPack(true);
        Label title = new Label(parent, 0);
        title.setText("Execution in progress, please wait ...");
        GridData data = new GridData();
        data.horizontalIndent = 10;
        data.verticalIndent = 10;
        title.setLayoutData((Object)data);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        data = new GridData(768);
        composite.setLayoutData((Object)data);
        Label imageLabel = new Label(composite, 0);
        Image image = this.getShell().getDisplay().getSystemImage(16);
        image.setBackground(imageLabel.getBackground());
        imageLabel.setImage(image);
        data = new GridData();
        imageLabel.setLayoutData((Object)data);
        this.createInfo(composite);
        super.setDoneButtonName("Close");
        super.setCancelButtonName("Cancel Execution");
        this.createLog(parent);
        this.createCtrl(parent);
    }

    private void createLog(Composite parent) {
        this.log = new Text(parent, 778);
        GridData data = new GridData(1808);
        data.minimumHeight = 400;
        this.log.setLayoutData((Object)data);
    }

    private void createInfo(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        composite.setLayout((Layout)layout);
        GridData data = new GridData(768);
        composite.setLayoutData((Object)data);
        this.currentTask = new Label(composite, 0);
        data = new GridData(768);
        data.minimumWidth = 600;
        this.currentTask.setLayoutData((Object)data);
    }

    private void perform() throws IbeeException {
        if (this.runnable == null) {
            return;
        }
        this.monitor = new IMonitor(){

            @Override
            public void worked(int work) {
            }

            @Override
            public void subTask(String name) {
            }

            @Override
            public void setTaskName(String name) {
                this.setTaskName(name);
            }

            @Override
            public void setCanceled(boolean value) {
                DlgExecution.this.canceled = value;
            }

            @Override
            public boolean isCanceled() {
                return DlgExecution.this.canceled;
            }

            @Override
            public void internalWorked(double work) {
            }

            @Override
            public void done() {
                if (DlgExecution.this.getShell().isDisposed()) {
                    return;
                }
                DlgExecution.this.running = false;
                this.setTaskName("Finished");
                DlgExecution.this.log("Execution finished");
            }

            @Override
            public void beginTask(String name, int totalWork) {
                this.setTaskName(name);
                DlgExecution.this.log("Start Task '" + name + "'");
            }
        };
        this.running = true;
        try {
            this.runnable.run(this.monitor);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IbeeException((Throwable)e);
        }
    }

    private void setTaskName(final String text) {
        if (this.getShell().isDisposed()) {
            return;
        }
        this.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                DlgExecution.this.currentTask.setText("Current Task: " + text);
            }
        });
    }

    public void log(final String msg) {
        this.shell.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                DlgExecution.this.log.append(new Date().toString() + ": " + msg + "\n");
            }
        });
    }

    @Override
    protected boolean prepareDone() {
        if (this.running) {
            SwtUtil.showInfo("Info", "Pycatshoo is still running", this.shell);
            return false;
        }
        return true;
    }

    @Override
    protected void performDialogCancel() {
        if (this.running && this.monitor != null) {
            this.monitor.setCanceled(true);
        }
    }
}

