/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.swt.core.field;

import net.edgemind.ibee.swt.core.field.FieldData;
import net.edgemind.ibee.swt.core.image.ImageUtil;
import net.edgemind.ibee.swt.core.util.SwtUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CallbackField<T>
extends FieldData<T> {
    private boolean editable = false;
    private boolean allowResetNull = true;
    private Runnable editHandler = null;
    private IButtonPressed<T> mCallBack;
    private Label label;

    public void setEditable(boolean value) {
        this.editable = value;
    }

    public void setAllowResetNull(boolean value) {
        this.allowResetNull = value;
    }

    public void setEditHandler(Runnable value) {
        this.editHandler = value;
    }

    public CallbackField(String key, String label, T defaultValue, IButtonPressed<T> callBack) {
        super(key, label, defaultValue);
        this.mCallBack = callBack;
    }

    @Override
    public void updateUi() {
        String text = this.mCallBack.getText(this.mValue);
        if (text == null || text.isEmpty()) {
            text = this.getEmptyStringValue();
        }
        text = this.resizeText(text);
        if (this.mControl != null && !((Text)this.mControl).getText().equals(text)) {
            ((Text)this.mControl).setText(text);
        }
    }

    @Override
    public Control createContents(Composite parent) {
        this.label = new Label(parent, 0);
        this.label.setText(this.mLabel + ": ");
        if (this.mLabelLayout != null) {
            this.label.setLayoutData(this.mLabelLayout);
        }
        int span = 2;
        if (this.allowResetNull) {
            ++span;
        }
        if (this.editHandler != null) {
            ++span;
        }
        Composite subC = new Composite(parent, 0);
        subC.setLayout((Layout)SwtUtil.createLayout(span, 0));
        GridData gridData = new GridData(768);
        subC.setLayoutData((Object)gridData);
        int style = 2048;
        if (!this.editable) {
            style |= 8;
        }
        final Text text = new Text(subC, style);
        gridData = new GridData(768);
        text.setLayoutData((Object)gridData);
        if (this.editable) {
            text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String result = text.getText();
                    CallbackField.this.setValue(result);
                }
            });
        }
        Button btn = new Button(subC, 0);
        btn.setText("Browse ... ");
        gridData = new GridData();
        gridData.horizontalIndent = 10;
        btn.setLayoutData((Object)gridData);
        btn.addSelectionListener(this.createSelectionListener(parent));
        if (this.editHandler != null) {
            btn = new Button(subC, 0);
            btn.setImage(ImageUtil.getBitmapImage("img/icon_edit16x16.png", CallbackField.class));
            btn.setToolTipText("Edit");
            btn.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    CallbackField.this.editHandler.run();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        if (this.allowResetNull) {
            btn = new Button(subC, 0);
            btn.setImage(ImageUtil.getBitmapImage("img/cancel.png", CallbackField.class));
            btn.setToolTipText("Reset");
            btn.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    CallbackField.this.setValue(null);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        return text;
    }

    public SelectionListener createSelectionListener(Composite parent) {
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Object object = CallbackField.this.mCallBack.getValue(CallbackField.this);
                CallbackField.this.setValue(object);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        return listener;
    }

    @Override
    protected void doEnable(boolean value) {
        super.doEnable(value);
        if (this.label != null) {
            SwtUtil.enableWidget((Control)this.label, value, true);
        }
    }

    public static interface IButtonPressed<T> {
        public T getValue(FieldData<T> var1);

        public String getText(T var1);
    }
}

