/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.swt.core.field;

import java.util.Calendar;
import java.util.Date;
import net.edgemind.ibee.swt.core.field.FieldData;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Label;

public class DateField
extends FieldData<String> {
    private Date date;

    public DateField(String key, String label, Date defaultValue) {
        super(key, label, defaultValue.toString());
        this.date = defaultValue;
    }

    @Override
    public void updateUi() {
        DateTime date = (DateTime)this.mControl;
        Calendar startCal = Calendar.getInstance();
        startCal.set(date.getYear(), date.getMonth(), date.getDay(), 0, 0, 0);
        startCal.set(14, 0);
        this.date = startCal.getTime();
        this.mValue = this.date.toString();
        super.setValue((String)this.mValue);
    }

    @Override
    public Control createContents(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(this.mLabel + ": ");
        if (this.mLabelLayout != null) {
            label.setLayoutData(this.mLabelLayout);
        }
        DateTime datetime = new DateTime(parent, 1024);
        Calendar startCal = Calendar.getInstance();
        startCal.setTime(this.date);
        datetime.setDate(startCal.get(1), startCal.get(2), startCal.get(5));
        datetime.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DateField.this.updateUi();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return datetime;
    }

    public Date getDate() {
        return this.date;
    }
}

