/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.swt.core.field;

import net.edgemind.ibee.swt.core.field.FieldData;
import net.edgemind.ibee.swt.core.field.StringField;
import net.edgemind.ibee.util.string.StringUtil;

public class NumberField
extends StringField {
    public NumberField(String key, String label, String defaultValue) {
        super(key, label, defaultValue);
        this.addFieldChecker(new FieldData.FieldChecker<String>(){

            @Override
            public String getErrorMsg(FieldData<String> field) {
                String value = field.getValue();
                if (value.equals("")) {
                    return null;
                }
                try {
                    new Double(value);
                }
                catch (NumberFormatException numberFormatException) {
                    return "Not a number";
                }
                return null;
            }
        });
    }

    public NumberField(String key, String label, Double defaultValue) {
        this(key, label, StringUtil.toString((Double)defaultValue, (String)""));
    }

    public void setValue(Double value) {
        this.setValue(StringUtil.toString((Double)value, (String)""));
    }

    public Double getNumberValue() {
        String value = (String)this.getValue();
        try {
            Double d = new Double(value);
            return d;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }
}

