/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.swt.core.field;

import net.edgemind.ibee.swt.core.field.FieldData;
import net.edgemind.ibee.swt.core.util.SwtUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;

public class SpinnerField
extends FieldData<Integer> {
    private Spinner mCnt;
    int min = 0;
    int max = 100;
    private Label label;

    public SpinnerField(String key, String label, int defaultValue) {
        super(key, label, defaultValue);
    }

    @Override
    public void updateUi() {
        if (this.isEmpty()) {
            if (!this.mCnt.getText().equals("")) {
                this.mCnt.setSelection(0);
            }
        } else if (this.mCnt.getSelection() != ((Integer)this.mValue).intValue()) {
            this.mCnt.setSelection(((Integer)this.mValue).intValue());
        }
    }

    public void setMin(int min) {
        this.min = min;
    }

    public void setMax(int max) {
        this.max = max;
    }

    @Override
    public Control createContents(Composite parent) {
        this.label = new Label(parent, 0);
        this.label.setText(this.mLabel + ": ");
        if (this.mLabelLayout != null) {
            this.label.setLayoutData(this.mLabelLayout);
        }
        int style = 2048;
        Composite subC = new Composite(parent, 0);
        subC.setLayout((Layout)SwtUtil.createLayout(1, 0));
        GridData gridData = new GridData(768);
        subC.setLayoutData((Object)gridData);
        this.mCnt = new Spinner(subC, style);
        this.mCnt.setLayoutData((Object)new GridData(768));
        this.mCnt.setMinimum(this.min);
        this.mCnt.setMaximum(this.max);
        this.mCnt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                int value = SpinnerField.this.mCnt.getSelection();
                SpinnerField.this.setValue(value);
            }
        });
        return this.mCnt;
    }

    @Override
    public Control getTextField() {
        return this.mCnt;
    }

    @Override
    protected void doEnable(boolean value) {
        super.doEnable(value);
        if (this.label != null) {
            SwtUtil.enableWidget((Control)this.label, value, true);
        }
    }
}

