/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.swt.core.field;

import net.edgemind.ibee.swt.core.field.FieldData;
import net.edgemind.ibee.swt.core.util.SwtUtil;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class StringField
extends FieldData<String> {
    private boolean readOnly = false;
    private int style = 2048;
    private Label label;

    public StringField(String key, String label, String initValue) {
        super(key, label, initValue);
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void addStyle(int style) {
        this.style |= style;
    }

    @Override
    public void updateUi() {
        if (this.isEmpty()) {
            if (!((Text)this.mControl).getText().equals(this.getEmptyStringValue())) {
                ((Text)this.mControl).setText(this.getEmptyStringValue());
            }
        } else if (!((Text)this.mControl).getText().equals(this.mValue)) {
            ((Text)this.mControl).setText((String)this.mValue);
        }
    }

    @Override
    public Control createContents(Composite parent) {
        this.label = new Label(this.keyComposite, 0);
        this.label.setText(this.mLabel + ": ");
        if (this.mLabelLayout != null) {
            this.label.setLayoutData(this.mLabelLayout);
        }
        if (this.readOnly) {
            this.style |= 8;
        }
        final Text text = new Text(this.valueComposite, this.style);
        text.setLayoutData((Object)new GridData(768));
        if (this.mValue != null) {
            text.setText((String)this.mValue);
        }
        text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                text.setSelection(0);
            }
        });
        text.addModifyListener(e -> {
            FieldData<String> fieldData = this.setValue(text.getText());
        });
        return text;
    }

    @Override
    protected void doEnable(boolean value) {
        super.doEnable(value);
        if (this.label != null) {
            SwtUtil.enableWidget((Control)this.label, value, true);
        }
    }
}

