/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.swt.core.image;

import java.io.InputStream;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class AnimatedGif {
    private ImageData[] gifFrames;
    private Image currentFrame;
    private int currentFrameIndex = 0;
    private Canvas canvas;
    private boolean animate = false;

    public AnimatedGif(String path, Class<?> gifBundle, Composite parent) {
        this.canvas = new Canvas(parent, 0);
        this.canvas.setBounds(50, 50, 200, 200);
        this.loadGIF(path, gifBundle);
    }

    public void startAnimation() {
        this.animate = true;
        final Display display = this.canvas.getDisplay();
        display.timerExec(0, new Runnable(){

            @Override
            public void run() {
                if (AnimatedGif.this.canvas.isDisposed()) {
                    return;
                }
                AnimatedGif.this.canvas.redraw();
                AnimatedGif.this.nextFrame();
                if (AnimatedGif.this.animate) {
                    display.timerExec(AnimatedGif.this.getDelayTime(), (Runnable)this);
                }
            }
        });
    }

    public void stopAnimation() {
        this.animate = false;
        if (this.currentFrame != null) {
            this.currentFrame.dispose();
            this.currentFrame = null;
        }
    }

    private void loadGIF(String path, Class gifBundle) {
        ImageLoader loader = new ImageLoader();
        InputStream imgStream = gifBundle.getResourceAsStream(path);
        this.gifFrames = loader.load(imgStream);
        this.canvas.addPaintListener(e -> {
            Image image = this.getCurrentFrame();
            if (image != null) {
                e.gc.drawImage(image, 0, 0);
            }
        });
    }

    private Image getCurrentFrame() {
        if (this.currentFrame != null) {
            this.currentFrame.dispose();
            this.currentFrame = null;
        }
        if (this.animate) {
            this.currentFrame = new Image((Device)Display.getDefault(), this.gifFrames[this.currentFrameIndex]);
            return this.currentFrame;
        }
        return this.canvas.getDisplay().getSystemImage(16);
    }

    private int getDelayTime() {
        return this.gifFrames[this.currentFrameIndex].delayTime * 15;
    }

    private void nextFrame() {
        this.currentFrameIndex = (this.currentFrameIndex + 1) % this.gifFrames.length;
    }

    public void dispose() {
        if (this.currentFrame != null) {
            this.currentFrame.dispose();
            this.currentFrame = null;
        }
    }
}

