/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.swt.core.renderer;

import java.util.List;
import net.edgemind.ibee.core.diagram.Color;
import net.edgemind.ibee.core.diagram.DElement;
import net.edgemind.ibee.core.diagram.Diagram;
import net.edgemind.ibee.core.diagram.Edge;
import net.edgemind.ibee.core.diagram.Group;
import net.edgemind.ibee.core.diagram.Node;
import net.edgemind.ibee.core.diagram.Point;
import net.edgemind.ibee.core.diagram.Rect;
import net.edgemind.ibee.core.diagram.Symbol;
import net.edgemind.ibee.core.diagram.Text;
import net.edgemind.ibee.core.diagram.primitives.PCircle;
import net.edgemind.ibee.core.diagram.primitives.PImage;
import net.edgemind.ibee.core.diagram.primitives.PLine;
import net.edgemind.ibee.core.diagram.primitives.PPolyline;
import net.edgemind.ibee.core.diagram.primitives.PRect;
import net.edgemind.ibee.core.diagram.primitives.Primitive;
import net.edgemind.ibee.swt.core.image.ImageUtil;
import net.edgemind.ibee.swt.core.util.SwtUtil;
import net.edgemind.ibee.ui.diagram.DiagramUtil;
import net.edgemind.ibee.ui.diagram.renderer.DiagramRenderer;
import net.edgemind.ibee.util.math.Frame;
import net.edgemind.ibee.util.math.Line;
import net.edgemind.ibee.util.math.MathUtil;
import net.edgemind.ibee.util.math.Point2D;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.LineAttributes;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class SWTDiagramRenderer
extends DiagramRenderer {
    private Composite canvas;
    public static int ZOOM_MAX = 10;
    private Diagram diagram = null;
    private Group overlay;
    private int diagramBufferWidth;
    private int diagramBufferHeight;
    private Display display;
    private double width;
    private double height;
    private Rectangle bounds;
    private Transform saved;

    public void init(Canvas canvas) {
        this.canvas = canvas;
        this.display = canvas.getDisplay();
    }

    public void init(Rectangle bounds) {
        this.bounds = bounds;
        this.display = this.getDisplay();
    }

    private Display getDisplay() {
        Display display = Display.getDefault();
        if (display == null) {
            display = new Display();
        }
        return display;
    }

    private org.eclipse.swt.graphics.Color getColor(Color color, GC gc) {
        return SwtUtil.toSwtColor(color);
    }

    private void disposeResources() {
        if (this.saved != null) {
            this.saved.dispose();
            this.saved = null;
        }
    }

    public void repaintDiagram(Diagram diagram) {
        this.diagram = diagram;
    }

    public void paintDiagram(GC gc) {
        this.isDiagramCoordSystemX = false;
        this.isDiagramCoordSystemY = false;
        this.selectedDiagramElements.clear();
        if (this.backgroundColor != null) {
            this.applyColors(this.backgroundColor, this.backgroundColor, gc);
            gc.fillRectangle(0, 0, (int)this.getClientWidth(), (int)this.getClientHeight());
        }
        this.translateX(gc);
        this.translateY(gc);
        if (this.diagram != null) {
            for (Group group : this.diagram.getGroups()) {
                this.paintGroup(group, gc);
            }
        }
        for (DElement dElement : this.selectedDiagramElements) {
            Node node;
            if (!(dElement instanceof Node) || !this.isVisible(node = (Node)dElement)) continue;
            Color fg = this.selectionColor;
            Color bg = null;
            this.prePaint((DElement)node, gc);
            this.paintSymbol(node.getSymbol(), node, gc, fg, bg);
            Node frame = new Node();
            frame.setX(node.getX());
            frame.setY(node.getY());
            frame.setWidth(node.getWidth());
            frame.setHeight(node.getHeight());
            frame.setSymbol((Symbol)new Rect());
            double lineWidth = this.selectionLineWidth;
            gc.setLineWidth((int)lineWidth);
            this.paintSymbol(frame.getSymbol(), node, gc, fg, bg);
            gc.setLineWidth(1);
            this.postPaint((DElement)node, gc);
        }
        for (DElement dElement : this.selectedDiagramElements) {
            if (!(dElement instanceof Text)) continue;
            Text text = (Text)dElement;
            this.applyColors(text.getForeColor(), text.getBackColor(), gc);
            this.prePaint((DElement)text, gc);
            this.paintText(text, gc);
            this.postPaint((DElement)text, gc);
        }
        this.disposeResources();
    }

    public void paintOverlay(Group overlay) {
        this.overlay = overlay;
        if (this.canvas != null) {
            this.canvas.redraw();
            this.canvas.update();
        }
    }

    public void repaint(GC gc) {
        gc.setAntialias(1);
        gc.setTextAntialias(1);
        gc.setAdvanced(true);
        this.paintDiagram(gc);
        Transform transform = new Transform((Device)this.display);
        gc.setTransform(transform);
        transform.dispose();
        this.paintOverlay(gc);
    }

    public void paintOverlay(GC gc) {
        if (this.overlay == null) {
            return;
        }
        this.isDiagramCoordSystemX = false;
        this.isDiagramCoordSystemY = false;
        this.translateX(gc);
        this.translateY(gc);
        this.paintGroup(this.overlay, gc);
        this.disposeResources();
    }

    private void paintGroup(Group group, GC gc) {
        Object element;
        Color fg;
        for (Edge edge : group.getEdges()) {
            Object element2;
            fg = edge.getForeColor();
            double lineWidth = edge.getLineWidth();
            if (this.selection != null && (element2 = edge.getElement()) != null && this.selection.contains(element2)) {
                fg = this.selectionColor;
                this.selectedDiagramElements.add(edge);
                lineWidth = this.selectionLineWidth;
            }
            gc.setLineWidth((int)lineWidth);
            this.paintEdge(edge, fg, gc);
            gc.setLineWidth(1);
        }
        for (Node node : group.getNodes()) {
            if (!this.isVisible(node)) continue;
            if (this.selection != null && (element = node.getElement()) != null && this.selection.contains(element)) {
                Node frame = new Node();
                frame.setX(node.getX());
                frame.setY(node.getY());
                frame.setWidth(node.getWidth());
                frame.setHeight(node.getHeight());
                frame.setSymbol((Symbol)new Rect());
                this.selectedDiagramElements.add(frame);
            }
            fg = node.getForeColor();
            Color bg = node.getBackColor();
            this.prePaint((DElement)node, gc);
            this.paintSymbol(node.getSymbol(), node, gc, fg, bg);
            this.postPaint((DElement)node, gc);
        }
        for (Group sub : group.getGroups()) {
            this.paintGroup(sub, gc);
        }
        for (Text text : group.getTexts()) {
            this.applyColors(text.getForeColor(), text.getBackColor(), gc);
            this.prePaint((DElement)text, gc);
            this.paintText(text, gc);
            this.postPaint((DElement)text, gc);
            if (this.selection == null || (element = text.getElement()) == null || !this.selection.contains(element)) continue;
            Color fg2 = this.selectionColor;
            Node node = new Node();
            node.setX(text.getX());
            node.setY(text.getY());
            node.setWidth(text.getWidth());
            node.setHeight(text.getHeight());
            if (!this.isVisible(node)) continue;
            this.paintSymbol((Symbol)new Rect(), node, gc, fg2, null);
        }
    }

    private void applyColors(Color fg, Color bg, GC gc) {
        org.eclipse.swt.graphics.Color curr;
        gc.setAlpha(255);
        if (fg != null) {
            curr = gc.getForeground();
            if (curr == null || curr.getRed() != fg.getR() || curr.getGreen() != fg.getG() || curr.getBlue() != fg.getB()) {
                gc.setForeground(this.getColor(fg, gc));
            }
        } else {
            gc.setForeground(Display.getCurrent().getSystemColor(2));
        }
        if (bg != null) {
            curr = gc.getBackground();
            if (curr == null || curr.getRed() != bg.getR() || curr.getGreen() != bg.getG() || curr.getBlue() != bg.getB()) {
                gc.setBackground(this.getColor(bg, gc));
            }
            int alpha = 255 - bg.getT();
            if (curr == null || curr.getAlpha() != alpha) {
                gc.setAlpha(alpha);
            }
        } else {
            gc.setBackground(Display.getCurrent().getSystemColor(1));
        }
    }

    private void paintSymbol(Symbol symbol, Node node, GC gc, Color fg, Color bg) {
        for (Primitive primitive : symbol.getPrimitives()) {
            this.applyColors(fg, bg, gc);
            if (primitive instanceof PLine) {
                this.paintLine((PLine)primitive, node, gc, fg, bg);
            } else if (primitive instanceof PCircle) {
                this.paintCircle((PCircle)primitive, node, gc, fg, bg);
            } else if (primitive instanceof PRect) {
                this.paintRect((PRect)primitive, node, gc, fg, bg);
            }
            if (primitive instanceof PPolyline) {
                this.paintPolyline((PPolyline)primitive, node, gc, fg, bg);
                continue;
            }
            if (!(primitive instanceof PImage)) continue;
            this.paintImage((PImage)primitive, node, gc);
        }
    }

    private boolean isVisible(Node node) {
        if (!node.getPositioning().equals((Object)DElement.Positioning.Absolute)) {
            return true;
        }
        if (this.visibleFrame == null) {
            return true;
        }
        if (node.getX() + node.getWidth() < this.visibleFrame.getX()) {
            return false;
        }
        if (node.getX() > this.visibleFrame.getX() + this.visibleFrame.getWidth()) {
            return false;
        }
        if (node.getY() + node.getHeight() < this.visibleFrame.getY()) {
            return false;
        }
        return !(node.getY() > this.visibleFrame.getY() + this.visibleFrame.getHeight());
    }

    private void paintLine(PLine line, Node node, GC gc, Color fg, Color bg) {
        int y2;
        int x2;
        int y1;
        int x1;
        if (node.getPositioning() == DElement.Positioning.Viewer) {
            x1 = (int)(node.getX() + line.getX1() * node.getWidth());
            y1 = (int)(node.getY() + line.getY1() * node.getHeight());
            x2 = (int)(node.getX() + line.getX2() * node.getWidth());
            y2 = (int)(node.getY() + line.getY2() * node.getHeight());
        } else {
            x1 = (int)(node.getX() + line.getX1() * node.getWidth());
            y1 = (int)(node.getY() + line.getY1() * node.getHeight());
            x2 = (int)(node.getX() + line.getX2() * node.getWidth());
            y2 = (int)(node.getY() + line.getY2() * node.getHeight());
        }
        gc.drawLine(x1, y1, x2, y2);
    }

    private void paintRect(PRect rect, Node node, GC gc, Color fg, Color bg) {
        int h;
        int w;
        int y;
        int x;
        if (node.getPositioning() == DElement.Positioning.Viewer) {
            x = (int)(node.getX() + rect.getX() * node.getWidth());
            y = (int)(node.getY() + rect.getY() * node.getHeight());
            w = (int)(node.getWidth() * rect.getWidth());
            h = (int)(node.getHeight() * rect.getHeight());
        } else {
            x = (int)this.getCoordX(node.getX() + rect.getX() * node.getWidth());
            y = (int)this.getCoordY(node.getY() + rect.getY() * node.getHeight());
            w = (int)(node.getWidth() * rect.getWidth());
            h = (int)(node.getHeight() * rect.getHeight());
        }
        Color backColor = rect.getBackColor() != null ? rect.getBackColor() : bg;
        Color foreColor = rect.getForeColor() != null ? rect.getForeColor() : fg;
        this.applyColors(foreColor, backColor, gc);
        if (backColor != null) {
            gc.fillRectangle(x, y, w, h);
        }
        if (foreColor != null) {
            gc.drawRectangle(x, y, w, h);
        }
    }

    private void paintPolyline(PPolyline line, Node node, GC gc, Color fg, Color bg) {
        double[] pointsX = line.getXArray();
        double[] pointsY = line.getYArray();
        if (pointsX == null || pointsY == null || pointsX.length != pointsY.length) {
            return;
        }
        int[] points = new int[pointsX.length * 2];
        int index = 0;
        while (index < pointsX.length) {
            points[2 * index] = (int)(node.getX() + pointsX[index] * node.getWidth());
            points[2 * index + 1] = (int)(node.getY() + pointsY[index] * node.getHeight());
            ++index;
        }
        Color backColor = line.getBackColor() != null ? line.getBackColor() : bg;
        Color foreColor = line.getForeColor() != null ? line.getForeColor() : fg;
        this.applyColors(foreColor, backColor, gc);
        if (backColor != null) {
            gc.fillPolygon(points);
        }
        gc.drawPolygon(points);
    }

    private void paintCircle(PCircle circle, Node node, GC gc, Color fg, Color bg) {
        int x = (int)(node.getX() + (circle.getX() - circle.getR1()) * node.getWidth());
        int y = (int)(node.getY() + (circle.getY() - circle.getR2()) * node.getHeight());
        int w = (int)(node.getWidth() * circle.getR1() * 2.0);
        int h = (int)(node.getHeight() * circle.getR2() * 2.0);
        Color backColor = null;
        if (circle.getFill()) {
            backColor = circle.getBackColor() != null ? circle.getBackColor() : bg;
        }
        Color foreColor = circle.getForeColor() != null ? circle.getForeColor() : fg;
        this.applyColors(foreColor, backColor, gc);
        if (backColor != null) {
            gc.fillArc(x, y, w, h, (int)circle.getA1(), (int)circle.getA2());
        }
        gc.drawArc(x, y, w, h, (int)circle.getA1(), (int)circle.getA2());
    }

    private void paintImage(PImage image, Node node, GC gc) {
        Image origImage = null;
        double imgWidth = 100.0;
        double imgHeight = 100.0;
        origImage = ImageUtil.getImage(image.getPath(), image.getImageClass(), (int)imgWidth, (int)imgHeight);
        if (origImage != null) {
            Rectangle rect = origImage.getBounds();
            int x = (int)(node.getX() + image.getX() * node.getWidth());
            int y = (int)(node.getY() + image.getY() * node.getHeight());
            int w = (int)(node.getWidth() * image.getWidth());
            int h = (int)(node.getHeight() * image.getHeight());
            gc.drawImage(origImage, rect.x, rect.y, rect.width, rect.height, x, y, w, h);
        }
    }

    int getTextsizeFromPixels(double pixels) {
        double points72 = pixels * 72.0 / (double)this.display.getDPI().y;
        int i = (int)Math.round(points72);
        return i;
    }

    int getTextsizeFromPoints(double points72) {
        return (int)Math.round(points72);
    }

    private void paintText(Text text, GC gc) {
        int style = 0;
        if (text.getFontStyle() == Text.FontStyle.BOLD) {
            style = 1;
        } else if (text.getFontStyle() == Text.FontStyle.ITALIC) {
            style = 2;
        }
        Font font = text.getTextsizeType() == Text.TextSizeType.PIXEL ? new Font(gc.getDevice(), "Arial Narrow", this.getTextsizeFromPixels(text.getTextSize()), style) : new Font(gc.getDevice(), "Arial Narrow", this.getTextsizeFromPoints(text.getTextSize()), style);
        gc.setFont(font);
        if (text.getWidth() == 0.0) {
            double x = text.getX();
            double y = text.getY();
            if (text.getTextAlign() == Text.TextAlign.CENTER) {
                x -= (double)(gc.textExtent((String)text.getText()).x / 2);
            }
            if (text.getTextAlign() == Text.TextAlign.RIGHT) {
                x -= (double)gc.textExtent((String)text.getText()).x;
            }
            gc.drawString(text.getText(), (int)x, (int)y, true);
        } else {
            this.createText(text.getText(), text, 0, gc);
        }
        font.dispose();
    }

    public void createText(String text, Text graphText, int lineNr, GC gc) {
        org.eclipse.swt.graphics.Point size = gc.stringExtent(text);
        int pos = text.length();
        if ((double)size.x > graphText.getWidth()) {
            String testText;
            int lastPos = -1;
            pos = 0;
            while (pos < text.length()) {
                if (text.charAt(pos) == ' ') {
                    testText = text.substring(0, pos);
                    org.eclipse.swt.graphics.Point sizeTest = gc.stringExtent(testText);
                    if ((double)sizeTest.x > graphText.getWidth()) break;
                    lastPos = pos;
                }
                ++pos;
            }
            if (lastPos == -1) {
                pos = 0;
                while (pos < text.length()) {
                    testText = text.substring(0, pos);
                    org.eclipse.swt.graphics.Point testSize = gc.stringExtent(testText);
                    if ((double)testSize.x > graphText.getWidth()) break;
                    lastPos = pos++;
                }
            }
            pos = lastPos;
        }
        if (pos <= 0) {
            pos = text.length();
        }
        String textToPrint = text.substring(0, pos).trim();
        int y = (int)(graphText.getY() + (double)(lineNr * size.y) * graphText.getLineSpacing());
        int offsetX = 0;
        int offsetY = 0;
        org.eclipse.swt.graphics.Point test = null;
        if (graphText.getTextAlign() == Text.TextAlign.CENTER) {
            test = gc.stringExtent(textToPrint);
            offsetX = (int)((graphText.getWidth() - (double)test.x) / 2.0);
        }
        gc.drawString(textToPrint, (int)graphText.getX() + offsetX, y + offsetY, true);
        String restText = text.substring(pos, text.length()).trim();
        if (restText.length() > 0) {
            this.createText(restText, graphText, lineNr + 1, gc);
        }
    }

    private void paintEdge(Edge edge, Color fg, GC gc) {
        Frame f;
        double y2;
        double x2;
        double y1;
        double x1;
        Line l;
        Point2D intersection;
        List points = DiagramUtil.getEdgePoints((Edge)edge);
        if (edge.getSource() != null && edge.getLineAlgo() == Edge.LineAlgo.DIRECT && edge.getArrowType() == Edge.ArrowType.ARROW_TARGET && (intersection = MathUtil.getIntersection((Line)(l = new Line(x1 = ((Point)points.get(0)).getX(), y1 = ((Point)points.get(0)).getY(), x2 = ((Point)points.get(1)).getX(), y2 = ((Point)points.get(1)).getY())), (Frame)(f = edge.getSource().getFrame()))) != null) {
            ((Point)points.get(0)).setX(intersection.getX());
            ((Point)points.get(0)).setY(intersection.getY());
        }
        if (edge.getTarget() != null && edge.getLineAlgo() == Edge.LineAlgo.DIRECT && edge.getArrowType() == Edge.ArrowType.ARROW_TARGET) {
            x1 = ((Point)points.get(points.size() - 2)).getX();
            y1 = ((Point)points.get(points.size() - 2)).getY();
            x2 = ((Point)points.get(points.size() - 1)).getX();
            y2 = ((Point)points.get(points.size() - 1)).getY();
            f = edge.getTarget().getFrame();
            if (edge.getArrowType() == Edge.ArrowType.ARROW_TARGET) {
                f.setX(f.getX() - 10.0);
                f.setY(f.getY() - 10.0);
                f.setWidth(f.getWidth() + 20.0);
                f.setHeight(f.getHeight() + 20.0);
            }
            if ((intersection = MathUtil.getIntersection((Line)(l = new Line(x1, y1, x2, y2)), (Frame)f)) != null) {
                ((Point)points.get(points.size() - 1)).setX(intersection.getX());
                ((Point)points.get(points.size() - 1)).setY(intersection.getY());
            }
        }
        this.applyColors(fg, fg, gc);
        double dashLength = edge.getDashLength();
        double lineLength = edge.getDashLineLength();
        if (edge.getLineStyle() == Edge.LineStyle.DASH) {
            gc.setLineStyle(6);
            if (dashLength < 0.0) {
                dashLength = 10.0;
            }
            if (lineLength < 0.0) {
                lineLength = 1.0;
            }
            gc.setLineDash(new int[]{(int)lineLength, (int)dashLength});
        }
        if (edge.getLineAlgo() == Edge.LineAlgo.BEZIER) {
            this.drawBezier(points, gc);
        } else if (edge.getLineAlgo() == Edge.LineAlgo.DIRECT) {
            int index = 1;
            while (index < points.size()) {
                Point pLast = (Point)points.get(index - 1);
                Point p = (Point)points.get(index);
                gc.drawLine((int)pLast.getX(), (int)pLast.getY(), (int)p.getX(), (int)p.getY());
                ++index;
            }
        }
        gc.setLineStyle(1);
        if (edge.getArrowType() == Edge.ArrowType.ARROW_TARGET) {
            double deltaX = ((Point)points.get(points.size() - 1)).getX() - ((Point)points.get(points.size() - 2)).getX();
            double deltaY = ((Point)points.get(points.size() - 1)).getY() - ((Point)points.get(points.size() - 2)).getY();
            double angle = Math.atan2(deltaX, -deltaY);
            double arrowX = ((Point)points.get(points.size() - 1)).getX();
            double arrowY = ((Point)points.get(points.size() - 1)).getY();
            this.saveTranform(gc);
            this.translate(this.getCoordX(arrowX), this.getCoordY(arrowY), gc);
            this.rotate(angle, gc);
            gc.setLineAttributes(new LineAttributes(1.0f, 1, 1));
            int[] nArray = new int[8];
            nArray[0] = -5;
            nArray[1] = 15;
            nArray[2] = (int)(-edge.getLineWidth());
            nArray[4] = (int)edge.getLineWidth();
            nArray[6] = 5;
            nArray[7] = 15;
            int[] arrowPoints = nArray;
            gc.fillPolygon(arrowPoints);
            this.restoreMatrix(gc);
        }
    }

    private void drawBezier(List<Point> points, GC gc) {
        if ((points.size() - 1) % 3 != 0) {
            return;
        }
        Path path = new Path(gc.getDevice());
        path.moveTo((float)points.get(0).getX(), (float)points.get(0).getY());
        int i = 0;
        while (i < points.size() - 1) {
            path.cubicTo((float)points.get(i + 1).getX(), (float)points.get(i + 1).getY(), (float)points.get(i + 2).getX(), (float)points.get(i + 2).getY(), (float)points.get(i + 3).getX(), (float)points.get(i + 3).getY());
            i += 3;
        }
        gc.drawPath(path);
        path.dispose();
    }

    private void drawDashLine(Point last, Point current, double dashLength, GC context) {
        double deltax = current.getX() - last.getX();
        double deltay = current.getY() - last.getY();
        double distance = Math.sqrt(deltax * deltax + deltay * deltay);
        double dx = deltax / distance;
        double dy = deltay / distance;
        boolean isDash = false;
        double d = 0.0;
        while (d < distance) {
            double x = last.getX() + d * dx;
            double y = last.getY() + d * dy;
            if (isDash) {
                context.drawLine((int)Math.round(x - dx * dashLength), (int)Math.round(y - dy * dashLength), (int)Math.round(x), (int)Math.round(y));
            }
            isDash = !isDash;
            d += dashLength;
        }
    }

    public double getClientWidth() {
        if (this.bounds != null) {
            return this.bounds.width;
        }
        return this.canvas.getClientArea().width;
    }

    public double getClientHeight() {
        if (this.bounds != null) {
            return this.bounds.height;
        }
        return this.canvas.getClientArea().height;
    }

    private void translateX(GC gc) {
        if (this.isDiagramCoordSystemX) {
            return;
        }
        double clientWidth = (float)this.getClientWidth();
        double translateXCenter = 0.0;
        if (this.tanslateToCenterX) {
            translateXCenter = clientWidth / 2.0;
        }
        Transform transform = new Transform((Device)this.display);
        gc.getTransform(transform);
        transform.translate((float)translateXCenter, 0.0f);
        transform.scale((float)this.zoomX, 1.0f);
        transform.translate((float)(-this.translateX), 0.0f);
        gc.setTransform(transform);
        transform.dispose();
        this.isDiagramCoordSystemX = true;
    }

    private void saveTranform(GC gc) {
        if (this.saved == null) {
            this.saved = new Transform((Device)this.display);
        }
        gc.getTransform(this.saved);
    }

    private void restoreMatrix(GC gc) {
        gc.setTransform(this.saved);
    }

    private void rotate(double alpha, GC gc) {
        Transform transform = new Transform((Device)this.display);
        gc.getTransform(transform);
        transform.rotate((float)(alpha * 180.0 / Math.PI));
        gc.setTransform(transform);
        transform.dispose();
    }

    private void translate(double x, double y, GC gc) {
        Transform transform = new Transform((Device)this.display);
        gc.getTransform(transform);
        transform.translate((float)x, (float)y);
        gc.setTransform(transform);
        transform.dispose();
    }

    private void translateY(GC gc) {
        if (this.isDiagramCoordSystemY) {
            return;
        }
        double clientHeight = this.getClientHeight();
        double translateYCenter = 0.0;
        if (this.tanslateToCenterY) {
            translateYCenter = clientHeight / 2.0;
        }
        Transform transform = new Transform((Device)this.display);
        gc.getTransform(transform);
        transform.translate(0.0f, (float)translateYCenter);
        transform.scale(1.0f, (float)this.zoomY);
        transform.translate(0.0f, (float)(-this.translateY));
        gc.setTransform(transform);
        transform.dispose();
        this.isDiagramCoordSystemY = true;
    }

    private void detranslateX(GC gc) {
        if (!this.isDiagramCoordSystemX) {
            return;
        }
        double clientWidth = this.getClientWidth();
        double translateXCenter = 0.0;
        if (this.tanslateToCenterX) {
            translateXCenter = clientWidth / 2.0;
        }
        Transform transform = new Transform((Device)this.display);
        gc.getTransform(transform);
        transform.translate((float)this.translateX, 0.0f);
        transform.scale((float)(1.0 / this.zoomX), 1.0f);
        transform.translate((float)(-translateXCenter), 0.0f);
        gc.setTransform(transform);
        transform.dispose();
        this.isDiagramCoordSystemX = false;
    }

    private void detranslateY(GC gc) {
        if (!this.isDiagramCoordSystemY) {
            return;
        }
        double clientHeight = this.getClientHeight();
        double translateYCenter = 0.0;
        if (this.tanslateToCenterY) {
            translateYCenter = clientHeight / 2.0;
        }
        Transform transform = new Transform((Device)this.display);
        gc.getTransform(transform);
        transform.translate(0.0f, (float)this.translateY);
        transform.scale(1.0f, (float)(1.0 / this.zoomY));
        transform.translate(0.0f, (float)(-translateYCenter));
        gc.setTransform(transform);
        transform.dispose();
        this.isDiagramCoordSystemY = false;
    }

    public double detranslateX(double x) {
        if (this.tanslateToCenterX) {
            double clientWidth = this.getClientWidth();
            return (x - this.translateX) * this.zoomX + clientWidth / 2.0;
        }
        return (x - this.translateX) * this.zoomX;
    }

    public double detranslateY(double y) {
        if (this.tanslateToCenterY) {
            double clientHeight = this.getClientHeight();
            return (y - this.translateY) * this.zoomY + clientHeight / 2.0;
        }
        return (y - this.translateY) * this.zoomY;
    }

    private void prePaint(DElement element, GC context) {
        if (element.getPositioning().equals((Object)DElement.Positioning.Viewer)) {
            this.detranslateX(context);
            this.detranslateY(context);
        }
        if (element.doAntiScaleX()) {
            this.detranslateX(context);
        }
        if (element.doAntiScaleY()) {
            this.detranslateY(context);
        }
    }

    private void postPaint(DElement element, GC context) {
        if (element.getPositioning().equals((Object)DElement.Positioning.Viewer)) {
            this.translateX(context);
            this.translateY(context);
        }
        if (element.doAntiScaleX()) {
            this.translateX(context);
        }
        if (element.doAntiScaleY()) {
            this.translateY(context);
        }
    }
}

