/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.swt.core.renderer;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import net.edgemind.ibee.core.command.ExecutionException;
import net.edgemind.ibee.core.log.LogUtil;
import net.edgemind.ibee.swt.core.image.ImageUtil;
import net.edgemind.ibee.swt.core.renderer.AcceleratorData;
import net.edgemind.ibee.swt.core.renderer.SwtWrappedMenuItem;
import net.edgemind.ibee.ui.common.UiData;
import net.edgemind.ibee.ui.menu.ICommandMenuItem;
import net.edgemind.ibee.ui.menu.IMenu;
import net.edgemind.ibee.ui.menu.IMenuItem;
import net.edgemind.ibee.ui.menu.IMenuRenderer;
import net.edgemind.ibee.ui.menu.MenuItem;
import net.edgemind.ibee.ui.menu.MenuSeparator;
import net.edgemind.ibee.ui.menu.SubMenuItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Menu;

public class SWTMenuRenderer
implements IMenuRenderer {
    boolean autoClear = true;
    private Menu swtMenu;

    public SWTMenuRenderer(Menu swtMenu) {
        this.swtMenu = swtMenu;
    }

    private void createContextMenu(Menu swtMenu, IMenu ibeeMenu) {
        final List items = ibeeMenu.getItems();
        Collections.sort(items, new Comparator<IMenuItem>(){

            @Override
            public int compare(IMenuItem o1, IMenuItem o2) {
                if (o1.getOrder() == o2.getOrder()) {
                    return 0;
                }
                if (o1.getOrder() < o2.getOrder()) {
                    return -1;
                }
                return 1;
            }
        });
        for (final IMenuItem ibeeItem : items) {
            String imagePath;
            org.eclipse.swt.widgets.MenuItem swtItem;
            if (ibeeItem instanceof MenuSeparator) {
                new org.eclipse.swt.widgets.MenuItem(swtMenu, 2);
                continue;
            }
            if (ibeeItem instanceof SwtWrappedMenuItem) {
                ((SwtWrappedMenuItem)ibeeItem).createMenu(swtMenu);
                continue;
            }
            if (ibeeItem instanceof SubMenuItem) {
                swtItem = new org.eclipse.swt.widgets.MenuItem(swtMenu, 64);
                swtItem.setText(ibeeItem.getTitle());
                Menu subMenu = new Menu(swtMenu);
                swtItem.setMenu(subMenu);
                this.createContextMenu(subMenu, ((SubMenuItem)ibeeItem).getMenu());
                continue;
            }
            swtItem = ibeeItem.getCheckable() ? new org.eclipse.swt.widgets.MenuItem(swtMenu, 32) : new org.eclipse.swt.widgets.MenuItem(swtMenu, 8);
            if (ibeeItem.getTitle() != null) {
                swtItem.setText(ibeeItem.getTitle());
            }
            if (ibeeItem.isSelected()) {
                swtItem.setSelection(true);
            }
            if ((imagePath = ibeeItem.getIcon()) != null) {
                Image img = ImageUtil.getImage(imagePath, ibeeItem.getIconClass(), 16, 16);
                swtItem.setImage(img);
            }
            this.installAccelerator(swtItem, ibeeItem);
            swtItem.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    Iterator iterator = items.iterator();
                    while (iterator.hasNext()) {
                        IMenuItem next;
                        next.setSelected((next = (IMenuItem)iterator.next()) == ibeeItem);
                    }
                    if (ibeeItem instanceof ICommandMenuItem) {
                        try {
                            ((ICommandMenuItem)ibeeItem).getCommand().execute();
                        }
                        catch (ExecutionException e1) {
                            LogUtil.log((Throwable)e1);
                        }
                    } else {
                        ((MenuItem)ibeeItem).fireClick(0.0, 0.0);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
    }

    private void installAccelerator(org.eclipse.swt.widgets.MenuItem swtItem, IMenuItem ibeeItem) {
        AcceleratorData acceleratorData;
        int keyStroke;
        UiData data = ibeeItem.getData();
        if (data instanceof AcceleratorData && (keyStroke = (acceleratorData = (AcceleratorData)data).getKeyStroke()) != 0) {
            swtItem.setAccelerator(keyStroke);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void cleanMenu(Menu menu) {
        lastWasSeparator = false;
        var6_3 = menu.getItems();
        var5_4 = var6_3.length;
        var4_5 = 0;
        while (var4_5 < var5_4) {
            item = var6_3[var4_5];
            subMenu = item.getMenu();
            if (subMenu == null) ** GOTO lbl-1000
            this.cleanMenu(subMenu);
            if (subMenu.getItemCount() == 0) {
                item.dispose();
            } else lbl-1000:
            // 2 sources

            {
                v0 = isSeparator = item.getStyle() == 2;
                if (lastWasSeparator && isSeparator) {
                    item.dispose();
                }
                lastWasSeparator = isSeparator;
            }
            ++var4_5;
        }
        if (menu.getItemCount() > 0 && (first = menu.getItem(0)).getStyle() == 2) {
            first.dispose();
        }
        if (menu.getItemCount() > 0 && (last = menu.getItem(menu.getItemCount() - 1)).getStyle() == 2) {
            last.dispose();
        }
    }

    public void renderMenu(IMenu menu, double x, double y) {
        if (this.autoClear) {
            this.clear();
        }
        this.createContextMenu(this.swtMenu, menu);
        this.cleanMenu(this.swtMenu);
    }

    public void setAutoClear(boolean value) {
        this.autoClear = value;
    }

    public void clear() {
        org.eclipse.swt.widgets.MenuItem[] menuItemArray = this.swtMenu.getItems();
        int n = menuItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            org.eclipse.swt.widgets.MenuItem item = menuItemArray[n2];
            item.dispose();
            ++n2;
        }
    }
}

