/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.swt.core.renderer;

import java.util.ArrayList;
import java.util.List;
import net.edgemind.ibee.core.iml.domain.IAttributeFeature;
import net.edgemind.ibee.swt.core.field.CheckboxField;
import net.edgemind.ibee.swt.core.field.FieldData;
import net.edgemind.ibee.swt.core.field.SpinnerField;
import net.edgemind.ibee.swt.core.field.StringField;
import net.edgemind.ibee.swt.core.field.SwtFieldCreator;
import net.edgemind.ibee.ui.property.CheckboxProperty;
import net.edgemind.ibee.ui.property.ElementProperty;
import net.edgemind.ibee.ui.property.EnumProperty;
import net.edgemind.ibee.ui.property.IProperty;
import net.edgemind.ibee.ui.property.IPropertyModificationListener;
import net.edgemind.ibee.ui.property.IPropertySheet;
import net.edgemind.ibee.ui.property.IPropertySheetRenderer;
import net.edgemind.ibee.ui.property.IntegerProperty;
import net.edgemind.ibee.ui.property.TypedProperty;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SwtPropertyRenderer
implements IPropertySheetRenderer {
    private Composite parent;
    private Composite composite;
    List<IProperty<?>> properties;
    GridData style;

    public SwtPropertyRenderer(Composite parent) {
        this(parent, null);
    }

    public SwtPropertyRenderer(Composite parent, GridData style) {
        this.parent = parent;
        this.style = style;
        this.createFieldComponent();
    }

    public void render(IPropertySheet sheet) {
        this.render(sheet.getProperties());
    }

    public void render(IProperty<?> property) {
        ArrayList properties = new ArrayList();
        properties.add(property);
        this.render(properties);
    }

    public void render(List<IProperty<?>> properties) {
        this.properties = properties;
        Control[] controlArray = this.composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control ctrl = controlArray[n2];
            ctrl.dispose();
            ++n2;
        }
        this.renderProperties();
        this.composite.layout(true, true);
    }

    private void createFieldComponent() {
        this.composite = new Composite(this.parent, 0);
        this.composite.setLayout((Layout)new GridLayout(2, false));
        if (this.style == null) {
            this.style = new GridData();
            this.style.grabExcessHorizontalSpace = true;
            this.style.minimumWidth = 400;
        }
        this.composite.setLayoutData((Object)this.style);
    }

    private void renderProperties() {
        for (IProperty<?> property : this.properties) {
            this.renderProperty(property, this.composite);
        }
    }

    public void renderProperty(IProperty<?> property, Composite parent) {
        if (property instanceof TypedProperty) {
            this.createTypedProperty((TypedProperty)property, parent);
        } else if (property instanceof EnumProperty) {
            EnumProperty enumProperty = (EnumProperty)property;
            this.renderEnumProperty(enumProperty, parent);
        } else if (property instanceof ElementProperty) {
            ElementProperty elementProperty = (ElementProperty)property;
            this.renderElementProperty(elementProperty, parent);
        } else if (property instanceof IntegerProperty) {
            IntegerProperty integerProperty = (IntegerProperty)property;
            this.renderIntegerProperty(integerProperty, parent);
        } else if (property instanceof CheckboxProperty) {
            CheckboxProperty elementProperty = (CheckboxProperty)property;
            this.renderCheckboxProperty(elementProperty, parent);
        }
    }

    private void createTypedProperty(final TypedProperty property, Composite parent) {
        final StringField field = new StringField(property.getName(), property.getLabel(), (String)property.getValue());
        GridData data = new GridData(768);
        data.minimumWidth = 200;
        data.horizontalSpan = field.getColSpan();
        field.setFieldLayout(data);
        field.addModifiedListener(new FieldData.IModifiedListener<String>(){

            @Override
            public void modified(String value) {
                property.setValue((Object)value);
                SwtPropertyRenderer.this.updateField((IProperty<?>)property, field);
            }
        });
        SwtFieldCreator creator = new SwtFieldCreator();
        creator.createField(field, parent);
        this.updateField((IProperty<?>)property, field);
    }

    private void updateField(IProperty<?> property, FieldData field) {
        Control control = field.getControl();
        if (property.isValid()) {
            control.setBackground(Display.getCurrent().getSystemColor(1));
        } else {
            control.setBackground(Display.getCurrent().getSystemColor(7));
        }
    }

    private void renderElementProperty(ElementProperty property, Composite parent) {
        IAttributeFeature attribute = property.getAttribute();
        Label label = new Label(parent, 0);
        label.setText(attribute.getName() + ": ");
        GridData data = new GridData();
        data.horizontalIndent = 0;
        label.setLayoutData((Object)data);
        Text text = new Text(parent, 0);
        data = new GridData(768);
        text.setLayoutData((Object)data);
    }

    private void renderIntegerProperty(final IntegerProperty property, Composite parent) {
        final SpinnerField field = new SpinnerField(property.getName(), property.getLabel(), (Integer)property.getValue());
        field.setMin(property.getMin());
        field.setMax(property.getMax());
        GridData data = new GridData(768);
        data.minimumWidth = 200;
        data.horizontalSpan = field.getColSpan();
        field.setFieldLayout(data);
        field.addModifiedListener(new FieldData.IModifiedListener<Integer>(){

            @Override
            public void modified(Integer value) {
                property.setValue((Object)value);
                SwtPropertyRenderer.this.updateField((IProperty<?>)property, field);
            }
        });
        SwtFieldCreator creator = new SwtFieldCreator();
        creator.createField(field, this.composite);
        this.updateField((IProperty<?>)property, field);
    }

    private void renderEnumProperty(final EnumProperty<?> enumProperty, Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(enumProperty.getLabel() + ": ");
        GridData data = new GridData();
        data.horizontalIndent = 0;
        label.setLayoutData((Object)data);
        final Combo combo = new Combo(parent, 8);
        for (String enumValue : enumProperty.getEnumLabels()) {
            combo.add(enumValue);
        }
        if (combo.getItemCount() == 0) {
            combo.setEnabled(false);
        }
        combo.setEnabled(enumProperty.getModifyable());
        data = new GridData(768);
        data.horizontalIndent = 20;
        combo.setLayoutData((Object)data);
        final Object[] objectValues = enumProperty.getEnums().toArray();
        combo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                int index = combo.getSelectionIndex();
                if (index < 0) {
                    return;
                }
                enumProperty.setValue(objectValues[index]);
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        int selectionIndex = -1;
        int index = 0;
        Object[] objectArray = objectValues;
        int n = objectValues.length;
        int n2 = 0;
        while (n2 < n) {
            Object objectValue = objectArray[n2];
            Object currentValue = enumProperty.getValue();
            if (currentValue == null && objectValue == null) {
                selectionIndex = index;
            }
            if (currentValue != null && objectValue != null && currentValue.equals(objectValue)) {
                selectionIndex = index;
            }
            ++index;
            ++n2;
        }
        combo.select(selectionIndex);
        EnumProperty<?> prop = enumProperty;
        prop.addModificationListener((IPropertyModificationListener)new IPropertyModificationListener<Object>(){

            public void propertyModified(IProperty<Object> property) {
                combo.setEnabled(property.getModifyable());
            }
        });
    }

    public Composite getFieldComposite() {
        return this.composite;
    }

    private void renderCheckboxProperty(final CheckboxProperty property, Composite parent) {
        final CheckboxField field = new CheckboxField(property.getName(), property.getLabel(), (Boolean)property.getValue());
        field.setLabel(property.getLabel());
        field.addModifiedListener(new FieldData.IModifiedListener<Boolean>(){

            @Override
            public void modified(Boolean value) {
                property.setValue((Object)value);
                SwtPropertyRenderer.this.updateField((IProperty<?>)property, field);
            }
        });
        SwtFieldCreator creator = new SwtFieldCreator();
        creator.createField(field, parent);
        this.updateField((IProperty<?>)property, field);
    }

    public void refresh() {
        Control[] controlArray = this.composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control ctrl = controlArray[n2];
            ctrl.dispose();
            ++n2;
        }
        this.renderProperties();
        this.composite.getParent().getParent().layout(true, true);
    }
}

