/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.swt.core.renderer;

import fr.edf.ibee.swt.core.table.ALazyTableContentProvider;
import java.util.ArrayList;
import java.util.List;
import net.edgemind.ibee.swt.core.widgets.SwtTableWidget;
import net.edgemind.ibee.ui.column.Column;
import net.edgemind.ibee.ui.column.ISorter;
import net.edgemind.ibee.ui.table.TableRenderer;
import net.edgemind.ibee.ui.z.renderer.AZComponent;
import net.edgemind.ibee.ui.z.renderer.AZRenderer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;

public class SwtTableRenderer<T>
extends AZRenderer<net.edgemind.ibee.ui.table.Table<T>>
implements TableRenderer<T> {
    private Composite parent;
    private net.edgemind.ibee.ui.table.Table<T> table;
    private SwtTableWidget<T> tableWidget;
    private List<Column<T>> tableColumns;
    private long maxRowsToShow = -1L;
    private boolean renderingQueued = false;

    public SwtTableRenderer(Composite parent) {
        this.parent = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRender(net.edgemind.ibee.ui.table.Table<T> tree) {
        this.table = tree;
        if (this.tableWidget == null) {
            this.createTreeWidget();
        } else {
            this.updateColumns();
        }
        SwtTableRenderer swtTableRenderer = this;
        synchronized (swtTableRenderer) {
            if (this.renderingQueued) {
                return;
            }
            this.renderingQueued = true;
        }
        this.parent.getDisplay().asyncExec(() -> {
            SwtTableRenderer swtTableRenderer = this;
            synchronized (swtTableRenderer) {
                this.renderingQueued = false;
            }
            this.tableWidget.refresh();
        });
    }

    public void updateColumns() {
        if (this.tableColumns != null && this.tableColumns.equals(this.table.getTableColumns())) {
            return;
        }
        this.tableWidget.setColumns(this.table.getTableColumns());
        this.tableWidget.updateColumns();
        this.tableColumns = new ArrayList<Column<T>>(this.table.getTableColumns());
    }

    private void createTreeWidget() {
        this.tableWidget = new SwtTableWidget();
        this.tableWidget.setColumns(this.table.getTableColumns());
        this.tableColumns = new ArrayList<Column<T>>(this.table.getTableColumns());
        this.tableWidget.setContentProvider(new ALazyTableContentProvider(){

            @Override
            public Object[] determineObjects() {
                if (SwtTableRenderer.this.table.getTableData() == null) {
                    return null;
                }
                return SwtTableRenderer.this.sort(SwtTableRenderer.this.table.getTableData()).toArray();
            }
        });
        this.tableWidget.setFilter(el -> this.table.getFilter() != null ? this.table.getFilter().accept(el) : true);
        this.tableWidget.setMaxRowsToShow(this.maxRowsToShow);
        this.tableWidget.create(this.parent);
        this.table.setUIObject((Object)this.tableWidget.getTable());
        this.tableWidget.onSelect(sel -> this.table.changeSelection(sel.getItems()));
        this.tableWidget.onDoubleClick(event -> this.table.fireEvent(event));
    }

    private List<T> sort(List<T> elements) {
        int sortColumn = this.tableWidget.getSortColumn();
        int sortDirection = this.tableWidget.getSortDirection();
        if (sortColumn > 0 && sortDirection != 0) {
            ISorter sorter = this.getSorter(sortColumn);
            elements.sort((e1, e2) -> sortDirection == 1 ? sorter.compareEquals(e1, e2) : sorter.compareEquals(e2, e1));
        }
        return elements;
    }

    private ISorter<T> getSorter(int sortColumn) {
        ISorter defaultSorter = (e1, e2) -> ((Column)this.table.getTableColumns().get(sortColumn - 1)).getValue(e1).compareToIgnoreCase(((Column)this.table.getTableColumns().get(sortColumn - 1)).getValue(e2));
        ISorter sorter = ((Column)this.table.getTableColumns().get(sortColumn - 1)).getSorter();
        if (sorter == null) {
            sorter = defaultSorter;
        }
        return sorter;
    }

    private ISorter<T> createSorter() {
        return (e1, e2) -> {
            int sortCol = this.getSortColumn();
            int sortDir = this.getSortDirection();
            ISorter<T> colSorter = this.getSorter(sortCol);
            return sortDir == 1 ? colSorter.compareEquals(e1, e2) : colSorter.compareEquals(e2, e1);
        };
    }

    private int getSortColumn() {
        return this.tableWidget.getSortColumn();
    }

    private int getSortDirection() {
        return this.tableWidget.getSortDirection();
    }

    public Table getSwtTable() {
        return this.tableWidget.getTable();
    }

    public void update() {
        this.render((AZComponent)this.table);
    }

    public long getMaxRowsToShow() {
        return this.maxRowsToShow;
    }

    public void setMaxRowsToShow(long maxRowsToShow) {
        this.maxRowsToShow = maxRowsToShow;
    }
}

