/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.swt.core.renderer;

import java.util.HashMap;
import java.util.Map;
import net.edgemind.ibee.swt.core.image.ImageUtil;
import net.edgemind.ibee.swt.core.renderer.SwtButtonRenderer;
import net.edgemind.ibee.swt.core.renderer.SwtZSpinnerRenderer;
import net.edgemind.ibee.ui.diagram.editor.DiagramEditor;
import net.edgemind.ibee.ui.toolbar.IPopupToolbarItem;
import net.edgemind.ibee.ui.toolbar.IToolbar;
import net.edgemind.ibee.ui.toolbar.IToolbarItem;
import net.edgemind.ibee.ui.toolbar.IToolbarRenderer;
import net.edgemind.ibee.ui.toolbar.ToolBar;
import net.edgemind.ibee.ui.toolbar.ZToolbarItem;
import net.edgemind.ibee.ui.z.ZButton;
import net.edgemind.ibee.ui.z.ZSpinner;
import net.edgemind.ibee.ui.z.renderer.AZComponent;
import net.edgemind.ibee.ui.z.renderer.AZRenderer;
import net.edgemind.ibee.ui.z.renderer.IZRenderer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ToolItem;

public class SwtToolbarRenderer
extends AZRenderer
implements IToolbarRenderer {
    private Composite parent;
    private int imgWidth = 24;
    private int imgHeight = 24;
    private int spacing = 3;
    private boolean vertical = false;
    IToolbar toolbar;
    private Composite bar;
    private boolean enableText = true;
    private Map<IToolbarItem, ToolItem> toggleButtons = new HashMap<IToolbarItem, ToolItem>();

    public SwtToolbarRenderer(Composite parent) {
        this.parent = parent;
    }

    public void setVertical(boolean value) {
        this.vertical = value;
    }

    public void setSpacing(int spacing) {
        this.spacing = spacing;
    }

    public Composite getToolbar() {
        return this.bar;
    }

    public void renderToolBar(IToolbar toolbar) {
        this.toolbar = toolbar;
        if (this.bar != null) {
            Control[] controlArray = this.bar.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                if (!c.isDisposed()) {
                    c.dispose();
                }
                ++n2;
            }
        } else {
            Layout currLayout;
            int style = 0;
            if (this.vertical) {
                style |= 0x200;
            }
            if (!((currLayout = this.parent.getLayout()) instanceof RowLayout)) {
                this.bar = new Composite(this.parent, style);
                RowLayout rowLayout = new RowLayout();
                rowLayout.spacing = this.spacing;
                rowLayout.wrap = true;
                rowLayout.center = true;
                rowLayout.pack = true;
                rowLayout.marginBottom = 0;
                rowLayout.marginTop = 0;
                rowLayout.marginLeft = 0;
                rowLayout.marginRight = 0;
                rowLayout.marginWidth = 0;
                rowLayout.marginHeight = 0;
                this.bar.setLayout((Layout)rowLayout);
            } else {
                this.bar = this.parent;
            }
            this.bar.setData("org.eclipse.e4.ui.css.CssClassName", (Object)"button");
        }
        this.toggleButtons.clear();
        for (IToolbarItem item : toolbar.getItems()) {
            this.renderToolbarItem(item);
        }
        this.bar.requestLayout();
        toolbar.refreshNeeded(false);
    }

    private void renderToolbarItem(final IToolbarItem item) {
        String imagePath;
        int style;
        item.setRenderer((IZRenderer)this);
        IToolbarItem item2 = item;
        if (item instanceof DiagramEditor.WrapperToolbarItem) {
            item2 = ((DiagramEditor.WrapperToolbarItem)item).getWrappedItem();
        }
        if (item2 instanceof ZToolbarItem) {
            this.renderZToolbarItem((ZToolbarItem)item2);
            return;
        }
        int n = style = item.isToggle() || item.isSelectable() ? 32 : 0;
        if (this.isDropDown(item)) {
            style = 4;
        }
        org.eclipse.swt.widgets.ToolBar internalTb = new org.eclipse.swt.widgets.ToolBar(this.bar, style |= 0x800000);
        final ToolItem swtItem = new ToolItem(internalTb, style);
        swtItem.setData("org.eclipse.e4.ui.css.CssClassName", (Object)"button");
        item.setUIObject((Object)swtItem);
        String tooltip = item.getTooltip();
        if (tooltip == null) {
            tooltip = item.getText();
        }
        if (tooltip != null) {
            swtItem.setToolTipText(tooltip);
        }
        if ((imagePath = item.getIcon()) != null) {
            int imgHeight;
            int imgWidth = item.getWidth();
            if (imgWidth <= 0) {
                imgWidth = this.imgWidth;
            }
            if ((imgHeight = item.getHeight()) <= 0) {
                imgHeight = this.imgHeight;
            }
            Image img = ImageUtil.getImage(imagePath, item.getIconClass(), imgWidth, imgHeight);
            swtItem.setImage(img);
            swtItem.setWidth(imgWidth);
        }
        String text = item.getText();
        if ((imagePath == null || this.enableText) && text != null) {
            swtItem.setText(text);
        }
        if (item.isToggle()) {
            this.toggleButtons.put(item, swtItem);
            if (item.isSelected()) {
                swtItem.setSelection(true);
            }
        } else if (item.isSelectable() && item.isSelected()) {
            swtItem.setSelection(true);
        }
        swtItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                if (item.isToggle()) {
                    for (IToolbarItem next : SwtToolbarRenderer.this.toggleButtons.keySet()) {
                        next.setSelected(next == item);
                        ToolItem swtItem2 = SwtToolbarRenderer.this.toggleButtons.get(next);
                        swtItem2.setSelection(next.isSelected());
                    }
                } else if (item.isSelectable()) {
                    item.setSelected(swtItem.getSelection());
                }
                IToolbarItem item2 = item;
                if (item instanceof DiagramEditor.WrapperToolbarItem) {
                    item2 = ((DiagramEditor.WrapperToolbarItem)item).getWrappedItem();
                }
                if (item2 instanceof IPopupToolbarItem) {
                    ((IPopupToolbarItem)item2).setUiParent((Object)swtItem);
                }
                item.click();
                ((ToolBar)SwtToolbarRenderer.this.toolbar).notifySelection(item);
            }
        });
        if (this.isDropDown(item)) {
            swtItem.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    IPopupToolbarItem popup = SwtToolbarRenderer.this.getDropdownToolbarItem(item);
                    popup.dropDown();
                }
            });
        }
    }

    private void renderZToolbarItem(ZToolbarItem item) {
        AZComponent zComponent = item.getZComponent();
        if (zComponent instanceof ZSpinner) {
            ZSpinner spinner = (ZSpinner)zComponent;
            SwtZSpinnerRenderer renderer = new SwtZSpinnerRenderer(this.bar);
            Control cfr_ignored_0 = (Control)renderer.renderSpinner(spinner);
        } else if (zComponent instanceof ZButton) {
            ZButton button = (ZButton)zComponent;
            SwtButtonRenderer renderer = new SwtButtonRenderer(this.bar);
            Control cfr_ignored_1 = (Control)renderer.render(button);
        }
    }

    public void setImageSize(int width, int height) {
        this.imgWidth = width;
        this.imgHeight = height;
    }

    public void select(int index) {
    }

    private boolean isDropDown(IToolbarItem item) {
        if (item instanceof DiagramEditor.WrapperToolbarItem) {
            item = ((DiagramEditor.WrapperToolbarItem)item).getWrappedItem();
        }
        return item instanceof IPopupToolbarItem && ((IPopupToolbarItem)item).isDropDown();
    }

    private IPopupToolbarItem getDropdownToolbarItem(IToolbarItem item) {
        if (item instanceof DiagramEditor.WrapperToolbarItem) {
            item = ((DiagramEditor.WrapperToolbarItem)item).getWrappedItem();
        }
        if (item instanceof IPopupToolbarItem) {
            return (IPopupToolbarItem)item;
        }
        return null;
    }

    public void enableText(boolean value) {
        this.enableText = value;
    }

    protected void doRender(AZComponent component) {
        IToolbarItem toolbar = (IToolbarItem)component;
        Object uiObject = component.getUIObject();
        if (uiObject instanceof Item) {
            Item item = (Item)uiObject;
            item.setText(toolbar.getText());
            this.bar.requestLayout();
        }
    }
}

