/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.swt.core.renderer;

import fr.edf.ibee.swt.core.table.ALazyTreeContentProvider;
import java.util.ArrayList;
import java.util.List;
import net.edgemind.ibee.swt.core.widgets.SwtTreeWidget;
import net.edgemind.ibee.ui.column.Column;
import net.edgemind.ibee.ui.column.ISorter;
import net.edgemind.ibee.ui.tree.TreeRenderer;
import net.edgemind.ibee.ui.z.renderer.AZRenderer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;

public class SwtTreeRenderer<T>
extends AZRenderer<net.edgemind.ibee.ui.tree.Tree<T>>
implements TreeRenderer<T> {
    private Composite parent;
    private net.edgemind.ibee.ui.tree.Tree<T> tree;
    private SwtTreeWidget<T> treeWidget;
    private boolean renderingQueued = false;
    private int delayedSortCol = 0;
    private int maxChildren = -1;

    public SwtTreeRenderer(Composite parent) {
        this.parent = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRender(net.edgemind.ibee.ui.tree.Tree<T> tree) {
        this.tree = tree;
        if (this.treeWidget == null) {
            this.createTreeWidget();
        }
        SwtTreeRenderer swtTreeRenderer = this;
        synchronized (swtTreeRenderer) {
            if (this.renderingQueued) {
                return;
            }
            this.renderingQueued = true;
        }
        this.parent.getDisplay().asyncExec(() -> {
            SwtTreeRenderer swtTreeRenderer = this;
            synchronized (swtTreeRenderer) {
                this.renderingQueued = false;
            }
            this.treeWidget.refresh();
        });
    }

    public void updateColumns() {
        this.treeWidget.setColumns(this.tree.getColumns());
        this.treeWidget.updateColumns();
    }

    private void createTreeWidget() {
        this.treeWidget = new SwtTreeWidget();
        this.treeWidget.setColumns(this.tree.getColumns());
        this.treeWidget.setContentProvider(new ALazyTreeContentProvider(){

            @Override
            public Object getParent(Object object) {
                return null;
            }

            @Override
            public Object[] getChildren(Object object) {
                List childs = object == SwtTreeRenderer.this.treeWidget.getViewer().getInput() ? SwtTreeRenderer.this.tree.getItemProvider().getChilds(SwtTreeRenderer.this.tree.getItemProvider().getRootItem()) : SwtTreeRenderer.this.tree.getItemProvider().getChilds(object);
                if (childs != null) {
                    if (SwtTreeRenderer.this.maxChildren > 0 && childs.size() > SwtTreeRenderer.this.maxChildren) {
                        childs = childs.subList(0, SwtTreeRenderer.this.maxChildren);
                    }
                    return SwtTreeRenderer.this.sort(childs).toArray();
                }
                return null;
            }

            @Override
            public Object[] determineElements(Object object) {
                ArrayList elements = SwtTreeRenderer.this.tree.getItemProvider().getChilds(SwtTreeRenderer.this.tree.getItemProvider().getRootItem());
                if (elements == null) {
                    elements = new ArrayList();
                }
                return elements.toArray();
            }
        });
        this.treeWidget.create(this.parent);
        if (this.delayedSortCol > 0) {
            this.treeWidget.sort(this.delayedSortCol);
        }
        this.treeWidget.setFilter(el -> this.tree.getFilter() != null ? this.tree.getFilter().accept(el) : true);
        this.tree.setUIObject((Object)this.treeWidget.getTree());
        this.treeWidget.onSelect(event -> this.tree.changeSelection(event.getItems()));
        this.treeWidget.onDoubleClick(event -> this.tree.fireEvent(event));
    }

    private List<T> sort(List<T> elements) {
        ISorter sorter;
        int sortColumn = this.treeWidget.getSortColumn();
        int sortDirection = this.treeWidget.getSortDirection();
        if (sortColumn > 0 && sortDirection != 0 && sortColumn <= this.tree.getColumns().size() && (sorter = ((Column)this.tree.getColumns().get(sortColumn - 1)).getSorter()) != null) {
            elements.sort((e1, e2) -> sortDirection == 1 ? sorter.compareEquals(e1, e2) : sorter.compareEquals(e2, e1));
        }
        return elements;
    }

    public Tree getSwtTree() {
        return this.treeWidget.getTree();
    }

    public void sortColumn(int col) {
        if (this.treeWidget != null) {
            this.treeWidget.sort(col);
        } else {
            this.delayedSortCol = col;
        }
    }

    public int getMaxChildren() {
        return this.maxChildren;
    }

    public void setMaxChildren(int maxChildren) {
        this.maxChildren = maxChildren;
    }
}

