/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.swt.core.widgets;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.edgemind.ibee.core.app.IEvent;
import net.edgemind.ibee.core.app.IEventHandler;
import net.edgemind.ibee.core.util.Selection;
import net.edgemind.ibee.swt.core.image.ImageUtil;
import net.edgemind.ibee.swt.core.util.SwtUtil;
import net.edgemind.ibee.ui.column.Column;
import net.edgemind.ibee.ui.column.IColorProvider;
import net.edgemind.ibee.ui.column.IIconProvider;
import net.edgemind.ibee.ui.common.event.MouseDblClickEvent;
import net.edgemind.ibee.ui.common.event.SelectionEvent;
import net.edgemind.ibee.util.Tuple;
import net.edgemind.ibee.util.misc.IFilter;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.widgets.Composite;

public abstract class ASwtTreeTableWidget<T> {
    private int sortCol = -1;
    private int sortDirection = 0;
    private int colIndex = 0;
    private Viewer viewer;
    protected List<Column<T>> columns = new ArrayList<Column<T>>();
    private IEventHandler<SelectionEvent<T>> selectionHandler;
    private IEventHandler<MouseDblClickEvent<T>> dblClickHandler;
    private IFilter<T> filter;

    protected abstract void createContentProvider();

    protected abstract Viewer createViewer(Composite var1);

    protected abstract void createColumn(Column<T> var1);

    protected abstract void clearColumns();

    public void onSelect(IEventHandler<SelectionEvent<T>> selectionHandler) {
        this.selectionHandler = selectionHandler;
    }

    public void onDoubleClick(IEventHandler<MouseDblClickEvent<T>> dblClickHandler) {
        this.dblClickHandler = dblClickHandler;
    }

    public IFilter<T> getFilter() {
        return this.filter;
    }

    public void setFilter(IFilter<T> filter) {
        this.filter = filter;
    }

    public void setColumns(List<Column<T>> columns) {
        this.columns = columns;
    }

    public void addColumn(Column<T> column) {
        this.columns.add(column);
    }

    public Column<T> getColumn(int index) {
        return this.columns.get(index);
    }

    public void create(Composite parent) {
        this.viewer = this.createViewer(parent);
        this.createColumns();
        this.createContentProvider();
    }

    private void createColumns() {
        this.columns.forEach(col -> this.createColumn((Column<T>)col));
    }

    public void updateColumns() {
        this.clearColumns();
        this.createColumns();
        this.viewer.getControl().requestLayout();
    }

    protected CellLabelProvider createLabelProvider(final Column<T> column) {
        return new CellLabelProvider(){

            public void update(ViewerCell cell) {
                IIconProvider iconProvider;
                Object row = cell.getElement();
                cell.setText(column.getValueProvider().getValue(row));
                IColorProvider colorProvider = column.getColorProvider();
                if (colorProvider != null) {
                    cell.setForeground(SwtUtil.toSwtColor(colorProvider.getForeground(row)));
                }
                if ((iconProvider = column.getIconProvider()) != null) {
                    Tuple imageInfo = iconProvider.getImage(row);
                    cell.setImage(ImageUtil.getImage((String)imageInfo.first, (Class)imageInfo.second));
                }
            }
        };
    }

    public void setInput(T rootItem) {
        this.viewer.setInput(rootItem);
    }

    public int getNextColumnIndex() {
        return ++this.colIndex;
    }

    public void resetColumnIndex() {
        this.colIndex = 0;
    }

    public void sort(int col) {
        this.sortDirection = this.sortCol == col ? (this.sortDirection == 0 ? 1 : (this.sortDirection == 1 ? 2 : 0)) : 1;
        this.sortCol = col;
    }

    public List<Object> getSelectedObjects() {
        StructuredSelection sel = (StructuredSelection)this.viewer.getSelection();
        Iterator it = sel.iterator();
        ArrayList<Object> result = new ArrayList<Object>();
        while (it.hasNext()) {
            result.add(it.next());
        }
        return result;
    }

    public int getSortColumn() {
        if (this.sortCol <= this.columns.size()) {
            return this.sortCol;
        }
        return -1;
    }

    public int getSortDirection() {
        return this.sortDirection;
    }

    protected void createSelectionListener() {
        this.viewer.getControl().addListener(13, e -> {
            if (this.selectionHandler == null) {
                return;
            }
            IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
            if (selection == null) {
                return;
            }
            Selection sel = new Selection();
            selection.forEach(el -> {
                boolean bl = sel.add(el);
            });
            this.selectionHandler.handleEvent((IEvent)new SelectionEvent((Collection)sel));
        });
    }

    protected void createDblClickListener() {
        this.viewer.getControl().addListener(8, e -> {
            if (this.dblClickHandler == null) {
                return;
            }
            IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
            if (selection == null) {
                return;
            }
            if (selection.size() == 1) {
                MouseDblClickEvent event = new MouseDblClickEvent(selection.getFirstElement());
                this.dblClickHandler.handleEvent((IEvent)event);
            }
        });
    }
}

