/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.swt.core.widgets;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.edgemind.ibee.core.exception.IbeeException;
import net.edgemind.ibee.core.log.LogEntry;
import net.edgemind.ibee.core.log.LogLevel;
import net.edgemind.ibee.swt.core.dialog.IRunnable;
import net.edgemind.ibee.swt.core.util.SwtUtil;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class SwtLogWidget {
    private StyledText text;
    private Shell shell;
    private boolean syncCalled = false;
    private int lineNr = 0;
    private int MAX_BUFFER_SIZE_READ = 10000;
    private StyleRange warningStyle;
    private StyleRange errorStyle;
    private StyleRange infoStyle;
    private StyleRange debugStyle;
    private int height = -1;
    private LinkedList<LogEntry> remainingLogEntries;
    private boolean autoScroll = false;

    public void setAutoScroll(boolean value) {
        this.autoScroll = value;
    }

    public boolean getAutoScroll() {
        return this.autoScroll;
    }

    public void create(Composite parent) {
        this.errorStyle = new StyleRange(0, 0, parent.getShell().getDisplay().getSystemColor(3), null);
        this.warningStyle = new StyleRange(0, 0, parent.getShell().getDisplay().getSystemColor(8), null);
        this.debugStyle = new StyleRange(0, 0, parent.getShell().getDisplay().getSystemColor(15), null);
        this.remainingLogEntries = new LinkedList();
        this.text = new StyledText(parent, 2826);
        GridData data = new GridData(1808);
        this.text.setLayoutData((Object)data);
        if (this.height > 0) {
            data.heightHint = this.height;
        }
        this.shell = parent.getShell();
    }

    public void clearLog() {
        SwtUtil.runInGui(new IRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() throws IbeeException {
                LinkedList<LogEntry> linkedList = SwtLogWidget.this.remainingLogEntries;
                synchronized (linkedList) {
                    SwtLogWidget.this.remainingLogEntries.clear();
                }
                SwtLogWidget.this.text.setText("");
                SwtLogWidget.this.text.setStyleRanges(new StyleRange[0]);
                SwtLogWidget.this.lineNr = 0;
            }
        }, this.shell);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(String msg, LogLevel level) {
        LinkedList<LogEntry> linkedList = this.remainingLogEntries;
        synchronized (linkedList) {
            this.remainingLogEntries.add(new LogEntry(msg, level));
        }
        this.processLogBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processLogBuffer() {
        LinkedList<LogEntry> linkedList = this.remainingLogEntries;
        synchronized (linkedList) {
            if (this.syncCalled) {
                return;
            }
            if (this.remainingLogEntries.size() == 0) {
                return;
            }
            this.syncCalled = true;
        }
        SwtUtil.runInGuiNonBlocking(() -> {
            try {
                ArrayList list = null;
                LinkedList<LogEntry> linkedList = this.remainingLogEntries;
                synchronized (linkedList) {
                    this.syncCalled = false;
                    int index = Math.min(this.remainingLogEntries.size(), this.MAX_BUFFER_SIZE_READ);
                    list = new ArrayList(this.remainingLogEntries.subList(0, index));
                    this.remainingLogEntries.subList(0, index).clear();
                }
                WriteBlock block = new WriteBlock();
                block.offset = this.text.getCharCount();
                for (LogEntry entry : list) {
                    if (entry == null) continue;
                    this.append(entry, block);
                }
                this.flush(block);
            }
            finally {
                if (this.autoScroll && !this.text.isDisposed()) {
                    this.text.setCaretOffset(this.text.getCharCount());
                    this.text.showSelection();
                }
                this.processLogBuffer();
            }
        }, this.shell);
    }

    private void append(LogEntry logEntry, WriteBlock block) {
        Object msg = logEntry.getMessage();
        LogLevel level = logEntry.getLevel();
        StyleRange styleRange = this.infoStyle;
        if (level == LogLevel.ERROR) {
            styleRange = this.errorStyle;
        } else if (level == LogLevel.WARNING) {
            styleRange = this.warningStyle;
        } else if (level == LogLevel.DEBUG) {
            styleRange = this.debugStyle;
        }
        ++this.lineNr;
        msg = this.lineNr + ": " + (String)msg;
        if (styleRange != null) {
            int length = ((String)msg).length();
            int start = block.offset + block.buf.length();
            block.ranges.add(start);
            block.ranges.add(length);
            block.styleRanges.add(styleRange);
        }
        block.buf.append((String)msg);
    }

    private void flush(WriteBlock block) {
        if (this.text.isDisposed()) {
            return;
        }
        this.text.append(block.buf.toString());
        int[] array = block.ranges.stream().mapToInt(i -> i).toArray();
        this.text.setStyleRanges(block.offset, block.buf.length(), array, block.styleRanges.toArray(new StyleRange[block.styleRanges.size()]));
    }

    public String getBuffer() {
        return this.text.getText();
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    class WriteBlock {
        int offset;
        StringBuffer buf = new StringBuffer();
        List<Integer> ranges = new ArrayList<Integer>();
        List<StyleRange> styleRanges = new ArrayList<StyleRange>();

        WriteBlock() {
        }
    }
}

