/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.extra.dialogs;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.edgemind.ibee.core.exception.IbeeException;
import net.edgemind.ibee.core.property.AProperty;
import net.edgemind.ibee.extra.dialogs.DlgSelectSomething;
import net.edgemind.ibee.swt.core.dialog.AExecutionDialog;
import net.edgemind.ibee.swt.core.field.CheckboxField;
import net.edgemind.ibee.swt.core.field.FieldData;
import net.edgemind.ibee.swt.core.field.FileField;
import net.edgemind.ibee.swt.core.field.SpinnerField;
import net.edgemind.ibee.swt.core.field.StringField;
import net.edgemind.ibee.swt.core.util.SwtUtil;
import net.edgemind.ibee.swt.core.widgets.SwtExecutionWidget;
import net.edgemind.ibee.util.file.FileUtil;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public abstract class AExecutionBatchDialog
extends AExecutionDialog {
    private Button singleButton;
    private boolean isSingle = true;
    private FileField fSingleInput;
    private static String lastSingleInput;
    private FileField fSingleOutput;
    private static String lastSingleOutput;
    private Button multipleButton;
    private boolean isMultiple = false;
    private FileField fMultipleInput;
    private static String lastMultipleInput;
    private FileField fSingleOutputBatch;
    private static String lastSingleOutputBatch;
    private boolean recursive = true;
    private StringField fSuffix;
    private SpinnerField fNrThreads;
    private String lastSuffix;
    private CheckboxField fOverwrite;
    private boolean lastOverwrite = true;
    private Map<File, File> inputOutputFiles;
    private int maximumAllowedThreads = 1;
    private boolean isSingleOuputForBatchExecution = false;

    protected abstract void startConversion(SwtExecutionWidget var1, IProgressMonitor var2, Map<File, File> var3);

    protected abstract String[] getInputFileExtensions();

    protected abstract String[] getOutputFileExtensions();

    public AExecutionBatchDialog(Shell parent, String title) {
        super(parent, title);
    }

    public AExecutionBatchDialog(Shell parent, int style, String title) {
        super(parent, style, title);
    }

    protected FileField getSingleInputField() {
        return this.fSingleInput;
    }

    protected FileField getSingleOutputField() {
        return this.fSingleOutput;
    }

    protected FileField getMultipleInputField() {
        return this.fMultipleInput;
    }

    protected FileField getSingleOutputBatchField() {
        return this.fSingleOutputBatch;
    }

    public int getMaximumAllowedThreads() {
        return this.maximumAllowedThreads;
    }

    public void setMaximumAllowedThreads(int maximumAllowedThreads) {
        this.maximumAllowedThreads = maximumAllowedThreads;
    }

    public int getNrOfThreads() {
        int cnt = 1;
        if (this.fNrThreads != null) {
            cnt = (Integer)this.fNrThreads.getValue();
        }
        return cnt;
    }

    public void setSingleOuputForBatchExecution(boolean value) {
        this.isSingleOuputForBatchExecution = value;
    }

    public void createConfigSection(Composite parent) {
        super.initSize(0.7, 0.7);
        Group container1 = new Group(parent, 0);
        container1.setLayout((Layout)SwtUtil.createLayout((int)1, (boolean)false, (int)0));
        container1.setLayoutData((Object)new GridData(768));
        this.createStacklayoutForSingleAndBatchMode((Composite)container1);
    }

    protected void createStacklayoutForSingleAndBatchMode(Composite parent) {
        this.createStacklayoutForSingleAndBatchMode(parent, parent);
    }

    protected void createStacklayoutForSingleAndBatchMode(Composite ctrlParent, Composite contentParent) {
        Composite radioContainer = new Composite(ctrlParent, 0);
        radioContainer.setLayout((Layout)SwtUtil.createLayout((int)2, (boolean)false, (int)0));
        StackLayout stackLayout = new StackLayout();
        Composite stackLayoutContainer = new Composite(contentParent, 0);
        stackLayoutContainer.setLayout((Layout)stackLayout);
        stackLayoutContainer.setLayoutData((Object)new GridData(768));
        this.createGenericFields();
        Composite singleComposite = this.createSingleGUI(stackLayoutContainer);
        stackLayout.topControl = singleComposite;
        Composite multipleComposite = this.createBatchGUI(stackLayoutContainer);
        this.singleButton = new Button(radioContainer, 16);
        this.singleButton.setText("Single");
        this.singleButton.setSelection(true);
        this.singleButton.addListener(13, e -> {
            stackLayout.topControl = singleComposite;
            stackLayoutContainer.requestLayout();
            this.isSingle = this.singleButton.getSelection();
            this.isMultiple = this.multipleButton.getSelection();
        });
        this.multipleButton = new Button(radioContainer, 16);
        this.multipleButton.setText("Batch");
        this.multipleButton.addListener(13, e -> {
            stackLayout.topControl = multipleComposite;
            stackLayoutContainer.requestLayout();
            this.isSingle = this.singleButton.getSelection();
            this.isMultiple = this.multipleButton.getSelection();
        });
    }

    private void createGenericFields() {
        this.createSingleInputField();
        this.createSingleOutputField();
        this.createMultipleInputBatchField();
        if (this.isSingleOuputForBatchExecution) {
            this.createSingleOutputBatchField();
        } else {
            this.createMultipleSuffixBatchField();
            this.createThreadNumberBatchField();
            this.createOverwriteBatchField();
        }
    }

    protected void createSingleInputField() {
        this.fSingleInput = new FileField("model", "Input Model", lastSingleInput, false, false);
        this.fSingleInput.setEditable(true);
        this.fSingleInput.confirmOverwrite(false);
        String combinedInputExt = Arrays.asList(this.getInputFileExtensions()).stream().collect(Collectors.joining(";"));
        this.fSingleInput.setAutomaticFileExtension(combinedInputExt);
        this.addFieldNotEmptyChecker((FieldData)this.fSingleInput, f -> this.isSingleExecution());
        this.addFileExtensionChecker(this.fSingleInput, f -> this.isSingleExecution(), () -> this.getInputFileExtensions());
        this.addFileExistsChecker(this.fSingleInput, f -> this.isSingleExecution());
        this.fSingleInput.addFieldChecker((FieldData.FieldChecker)new FieldData.FieldChecker<String>(){

            public String getErrorMsg(FieldData<String> field) {
                if (!AExecutionBatchDialog.this.isSingleExecution()) {
                    return null;
                }
                String value = (String)field.getValue();
                if (value == null || value.equals("")) {
                    return null;
                }
                if (!FileUtil.fileExists((String)value)) {
                    return "File '" + (String)field.getValue() + "' does not exist";
                }
                return null;
            }
        });
        this.fSingleInput.addModifiedListener((FieldData.IModifiedListener)new FieldData.IModifiedListener<String>(){

            public void modified(String data) {
                String inputFilePath;
                String string = inputFilePath = AExecutionBatchDialog.this.fSingleInput.getFile() != null ? AExecutionBatchDialog.this.fSingleInput.getFile().getPath() : "";
                if (inputFilePath == null || inputFilePath.length() == 0) {
                    return;
                }
                String defaultOutputPath = "";
                defaultOutputPath = AExecutionBatchDialog.this.getInputFileExtensions()[0].equalsIgnoreCase(AExecutionBatchDialog.this.getOutputFileExtensions()[0]) ? String.format("%s_output.%s", inputFilePath.substring(0, inputFilePath.length() - AExecutionBatchDialog.this.getInputFileExtensions()[0].length() - 1), AExecutionBatchDialog.this.getOutputFileExtensions()[0]) : FileUtil.replaceExtension((String)inputFilePath, (String)AExecutionBatchDialog.this.getOutputFileExtensions()[0]);
                if (AExecutionBatchDialog.this.fSingleOutput.getFile() == null) {
                    AExecutionBatchDialog.this.fSingleOutput.setValue((Object)defaultOutputPath);
                    AExecutionBatchDialog.this.fSingleOutput.updateUi();
                }
            }
        });
    }

    protected void createSingleOutputField() {
        this.fSingleOutput = new FileField("output", "Output File ", lastSingleOutput, false, true);
        this.fSingleOutput.setEditable(true);
        this.fSingleOutput.confirmOverwrite(true);
        String combinedOutputExt = Arrays.asList(this.getOutputFileExtensions()).stream().collect(Collectors.joining(";"));
        this.fSingleOutput.setAutomaticFileExtension(combinedOutputExt);
        this.addFieldNotEmptyChecker((FieldData)this.fSingleOutput, f -> this.isSingleExecution());
        this.addFileExtensionChecker(this.fSingleOutput, f -> this.isSingleExecution(), () -> this.getOutputFileExtensions());
    }

    protected void createMultipleInputBatchField() {
        this.fMultipleInput = new FileField("input", "Input Folder ", lastMultipleInput, true, false);
        this.fMultipleInput.setEditable(true);
        this.addFieldNotEmptyChecker((FieldData)this.fMultipleInput, f -> this.isBatchExecution());
    }

    protected void createSingleOutputBatchField() {
        this.fSingleOutputBatch = new FileField("output", "Output File ", lastSingleOutputBatch, false, true);
        this.fSingleOutputBatch.setEditable(true);
        this.fSingleOutputBatch.confirmOverwrite(true);
        String combinedOutputExt = Arrays.asList(this.getOutputFileExtensions()).stream().collect(Collectors.joining(";"));
        this.fSingleOutputBatch.setAutomaticFileExtension(combinedOutputExt);
        this.addFieldNotEmptyChecker((FieldData)this.fSingleOutputBatch, f -> this.isBatchExecution());
        this.addFileExtensionChecker(this.fSingleOutputBatch, f -> this.isBatchExecution(), () -> this.getOutputFileExtensions());
    }

    protected void createMultipleSuffixBatchField() {
        this.fSuffix = new StringField("suffix", "Suffix", this.lastSuffix);
        this.fSuffix.setDescription("Suffix to append to output file names (optional)");
    }

    protected void createThreadNumberBatchField() {
        this.fNrThreads = new SpinnerField("nrThreads", "Number of Threads", 1);
        this.fNrThreads.setMin(1);
        this.fNrThreads.setMax(this.maximumAllowedThreads);
    }

    protected void createOverwriteBatchField() {
        this.fOverwrite = new CheckboxField("overwrite", "Overwrite existing output files", this.lastOverwrite);
        this.fOverwrite.setDescription("Overwrites existing output files. If not activated, an incrementing unique index is appended to existing output files");
    }

    private Composite createSingleGUI(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)SwtUtil.createLayout((int)3, (boolean)false, (int)0));
        composite.setLayoutData((Object)new GridData(768));
        this.creator.createField((FieldData)this.fSingleInput, composite);
        this.creator.createField((FieldData)this.fSingleOutput, composite);
        this.createSpecificFieldsForSingleAndBatch(composite);
        this.createSpecificSingleFields(composite);
        return composite;
    }

    protected void createSpecificSingleFields(Composite composite) {
    }

    private Composite createBatchGUI(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)SwtUtil.createLayout((int)3, (boolean)false, (int)0));
        composite.setLayoutData((Object)new GridData(768));
        this.creator.createField((FieldData)this.fMultipleInput, composite);
        if (this.isSingleOuputForBatchExecution) {
            this.creator.createField((FieldData)this.fSingleOutputBatch, composite);
        } else {
            this.creator.createField((FieldData)this.fSuffix, composite);
            if (this.maximumAllowedThreads > 1) {
                this.creator.createField((FieldData)this.fNrThreads, composite);
            }
            this.creator.createField((FieldData)this.fOverwrite, composite);
        }
        this.createSpecificFieldsForSingleAndBatch(composite);
        this.createSpecificBatchFields(composite);
        return composite;
    }

    protected void createSpecificBatchFields(Composite composite) {
    }

    protected void createSpecificFieldsForSingleAndBatch(Composite composite) {
    }

    private List<File> selectFiles(List<File> files, final String dirPath) {
        DlgSelectSomething dlgSomething = new DlgSelectSomething(this.shell, "Select List of Files");
        dlgSomething.setElements(files);
        dlgSomething.setMultiSelection(true);
        dlgSomething.setShowCheckbox(true);
        dlgSomething.setDoneButtonName("Execute");
        dlgSomething.setFields(Arrays.asList(new AProperty<String, File>("File"){

            public String getValue(File file) {
                return FileUtil.getRelativePath((String)file.getAbsolutePath(), (String)dirPath);
            }

            public String checkValue(File file) {
                return null;
            }

            public int compareTo(String v1, String v2) {
                return 0;
            }

            public Object getEditValue(File file) {
                return null;
            }

            public String checkEditValue(File file, Object value) {
                return null;
            }

            public boolean setEditValue(File file, Object value) {
                return false;
            }

            public String toString(String value) {
                return value;
            }
        }));
        dlgSomething.open();
        if (!dlgSomething.isValid()) {
            return new ArrayList<File>();
        }
        return dlgSomething.getSelectedElements();
    }

    protected boolean launchPre() {
        this.inputOutputFiles = this.getInputOutputFiles();
        return this.inputOutputFiles != null && this.inputOutputFiles.size() > 0;
    }

    private Map<File, File> getInputOutputFiles() {
        HashMap<File, File> inputOutputFiles = new HashMap<File, File>();
        if (this.isBatchExecution()) {
            String[] inputExtensions = this.getInputFileExtensions();
            ArrayList<File> inputFiles = new ArrayList();
            try {
                inputFiles = FileUtil.findFiles((File)(this.fMultipleInput.getFile() != null ? this.fMultipleInput.getFile() : new File("")), (boolean)this.recursive, file -> Arrays.asList(inputExtensions).stream().anyMatch(ext -> FileUtil.hasExtension((File)file, (String)ext)));
            }
            catch (IOException e1) {
                throw new IbeeException((Throwable)e1);
            }
            List<File> selectedInputFiles = this.selectFiles(inputFiles, this.fMultipleInput.getFile() != null ? this.fMultipleInput.getFile().getAbsolutePath() : "");
            String[] outputExtensions = this.getOutputFileExtensions();
            String firstOutputExt = outputExtensions[0];
            for (File inputFile : selectedInputFiles) {
                String inputFilePath = inputFile.getPath();
                File outputFile = null;
                if (this.isSingleOuputForBatchExecution) {
                    outputFile = this.fSingleOutputBatch.getFile();
                } else {
                    String prefix = FileUtil.replaceExtension((String)inputFilePath, null);
                    String defaultOutputPath = String.format("%s%s.%s", prefix, this.fSuffix.isEmpty() ? "" : this.fSuffix.getValue(), firstOutputExt);
                    outputFile = new File(defaultOutputPath);
                    if (!((Boolean)this.fOverwrite.getValue()).booleanValue() && FileUtil.fileExists((File)outputFile)) {
                        outputFile = this.findFreeFileName(outputFile, firstOutputExt);
                    }
                }
                inputOutputFiles.put(inputFile, outputFile);
            }
        } else {
            inputOutputFiles.put(this.fSingleInput.getFile(), this.fSingleOutput.getFile());
        }
        return inputOutputFiles;
    }

    public void perform(SwtExecutionWidget exec, IProgressMonitor progress) {
        String out;
        String err = this.creator.getErrorMsg();
        if (err != null) {
            SwtUtil.showError((String)"Execution", (String)err, (Shell)this.shell);
            return;
        }
        if (this.isSingleExecution() ? FileUtil.fileExists((String)(out = (String)this.fSingleOutput.getValue())) && !this.continueIfTargetFileExists(this.fSingleOutput) : this.isBatchExecution() && this.isSingleOuputForBatchExecution && FileUtil.fileExists((String)(out = (String)this.fSingleOutputBatch.getValue())) && !this.continueIfTargetFileExists(this.fSingleOutputBatch)) {
            return;
        }
        this.fillConfiguration();
        this.startConversion(exec, progress, this.inputOutputFiles);
    }

    protected boolean isSingleExecution() {
        return !this.isBatchExecution();
    }

    protected boolean isBatchExecution() {
        return this.isMultiple;
    }

    private boolean continueIfTargetFileExists(FileField fileField) {
        String targetFileName = fileField.getValue() != null ? (String)fileField.getValue() : "";
        String msg = String.format("Target File '%s' exists already. Overwrite?", targetFileName);
        return SwtUtil.openConfirmDlg((Shell)this.shell, (String)"File exists already", (String)msg);
    }

    private File findFreeFileName(File outputFile, String extension) {
        String name = FileUtil.replaceExtension((String)outputFile.getPath(), null);
        int index = 1;
        while (FileUtil.fileExists((File)outputFile)) {
            String defaultOutputPath = String.format("%s%d.%s", name, index, extension);
            outputFile = new File(defaultOutputPath);
            ++index;
        }
        return outputFile;
    }

    protected void fillConfiguration() {
        if (this.fSingleInput != null) {
            lastSingleInput = (String)this.fSingleInput.getValue();
        }
        if (this.fSingleOutput != null) {
            lastSingleOutput = (String)this.fSingleOutput.getValue();
        }
        if (this.fMultipleInput != null) {
            lastMultipleInput = (String)this.fMultipleInput.getValue();
        }
        if (this.fSingleOutputBatch != null) {
            lastSingleOutputBatch = (String)this.fSingleOutputBatch.getValue();
        }
        if (this.fSuffix != null) {
            this.lastSuffix = (String)this.fSuffix.getValue();
        }
        if (this.fOverwrite != null) {
            this.lastOverwrite = (Boolean)this.fOverwrite.getValue();
        }
    }
}

