/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.extra.dialogs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.edgemind.ibee.core.property.IProperty;
import net.edgemind.ibee.core.util.Selection;
import net.edgemind.ibee.swt.core.dialog.ADialog;
import net.edgemind.ibee.swt.extra.property.SwtPropertyFilter;
import net.edgemind.ibee.util.misc.IFilter;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class DlgSelectSomething<T>
extends ADialog {
    protected Selection<T> selection = new Selection();
    private Table table;
    private Combo cmbCategory;
    private List<? extends T> elements;
    private Map<String, List<? extends T>> multiList = null;
    private String multiListCategory = null;
    private boolean multiSelection = true;
    private boolean withCheckBoxes = false;
    private boolean preselectAll = false;
    protected Button btnSelectAll;
    private int sortCol = 0;
    private int sortDirection = 1;
    private boolean showHeaders = true;
    boolean filterEnabled = true;
    List<IFilter<? super T>> filters = new ArrayList<IFilter<? super T>>();
    protected List<IProperty<?, ? super T>> fields = null;

    public void addFilter(IFilter<T> filter) {
        this.filters.add(filter);
    }

    public void setShowHeaders(boolean value) {
        this.showHeaders = value;
    }

    public void setMultiSelection(boolean value) {
        this.multiSelection = value;
    }

    public void setShowCheckbox(boolean value) {
        this.withCheckBoxes = value;
    }

    public boolean isPreselectAll() {
        return this.preselectAll;
    }

    public void setPreselectAll(boolean preselectAll) {
        this.preselectAll = preselectAll;
    }

    public DlgSelectSomething(Shell parent, String title) {
        super(parent, 67696, title);
        super.setBlocking(true);
        super.setDoPack(false);
        super.setDoneButtonName("Select");
    }

    public void setElements(List<? extends T> elements) {
        if (elements == null) {
            this.elements = null;
            return;
        }
        this.elements = elements;
    }

    public void setMultiCategory(String category) {
        this.multiListCategory = category;
    }

    public void setMultiList(Map<String, List<? extends T>> multiList) {
        if (multiList == null) {
            this.multiList = null;
            return;
        }
        this.multiList = multiList;
    }

    public void addMultiList(List<? extends T> elements, String category) {
        if (this.multiList == null) {
            this.multiList = new LinkedHashMap<String, List<? extends T>>();
        }
        this.multiList.put(category, elements);
    }

    public void addField(IProperty<?, ? super T> field) {
        if (this.fields == null) {
            this.fields = new ArrayList();
        }
        this.fields.add(field);
    }

    public void setFields(List<IProperty<?, ? super T>> fields) {
        this.fields = fields;
    }

    public void createContents(Composite parent) {
        this.prepareDataAndFlags();
        if (this.fields == null) {
            this.createFields();
        }
        if (this.filterEnabled) {
            this.createFilter(parent);
        }
        if (this.multiSelection) {
            this.createSelectAllCheckbox(parent);
        }
        this.createTable(parent);
        this.createCtrl(parent);
        this.refresh();
    }

    private void prepareDataAndFlags() {
        if (this.selection == null) {
            this.selection = new Selection();
        }
        if (this.multiList != null) {
            if (this.multiListCategory == null || !this.multiList.containsKey(this.multiListCategory)) {
                this.multiListCategory = this.multiList.keySet().iterator().next();
            }
            this.elements = this.multiList.get(this.multiListCategory);
        }
        if (this.withCheckBoxes) {
            this.multiSelection = true;
        }
        if (!this.multiSelection) {
            this.preselectAll = false;
            if (this.selection.size() > 1) {
                this.selection.clear();
            }
        }
        if (this.preselectAll) {
            this.selection = new Selection(this.elements);
        }
        this.selection.filter(e -> this.elements.contains(e));
    }

    protected void createFields() {
    }

    private void createFilter(Composite parent) {
        int hSpan = 1;
        if (this.multiList != null) {
            ++hSpan;
        }
        Composite composite = new Composite(parent, 67696);
        composite.setLayout((Layout)new GridLayout(hSpan, false));
        composite.setLayoutData((Object)new GridData(768));
        if (this.multiList != null) {
            this.cmbCategory = new Combo(composite, 8);
            for (String category : this.multiList.keySet()) {
                this.cmbCategory.add(category);
            }
            this.cmbCategory.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    DlgSelectSomething.this.elements = DlgSelectSomething.this.multiList.get(DlgSelectSomething.this.cmbCategory.getText());
                    DlgSelectSomething.this.selection.clear();
                    DlgSelectSomething.this.refresh();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            if (this.multiListCategory != null && this.multiList.containsKey(this.multiListCategory)) {
                this.cmbCategory.setText(this.multiListCategory);
            } else {
                this.cmbCategory.select(0);
            }
        }
        SwtPropertyFilter filter = new SwtPropertyFilter();
        filter.createFilter(composite, this, this.fields, this.filters);
    }

    private void createSelectAllCheckbox(Composite parent) {
        this.btnSelectAll = new Button(parent, 32);
        this.btnSelectAll.setText("Select All Currently Displayed");
        this.btnSelectAll.setSelection(this.preselectAll);
        this.btnSelectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (DlgSelectSomething.this.btnSelectAll.getSelection()) {
                    DlgSelectSomething.this.selection.addAll(DlgSelectSomething.this.getCurrentlyShownElements());
                } else {
                    DlgSelectSomething.this.selection.removeAll(DlgSelectSomething.this.getCurrentlyShownElements());
                }
                DlgSelectSomething.this.refresh();
                DlgSelectSomething.this.table.setFocus();
            }
        });
    }

    private void createTable(Composite parent) {
        int style = 68096;
        if (this.multiSelection && !this.withCheckBoxes) {
            style |= 2;
        }
        if (this.withCheckBoxes) {
            style |= 0x20;
        }
        this.table = new Table(parent, style);
        GridData data = new GridData(1808);
        this.table.setLayoutData((Object)data);
        this.table.setHeaderVisible(this.showHeaders);
        this.table.addListener(13, event -> {
            if (this.withCheckBoxes) {
                if (event.item == null) {
                    return;
                }
                if (event.detail == 32) {
                    boolean selected = ((TableItem)event.item).getChecked();
                    Object el = event.item.getData();
                    if (selected) {
                        this.selection.add(el);
                    } else {
                        this.selection.remove(el);
                    }
                    this.updateAllSelectedBtn();
                }
            } else {
                this.selection.clear();
                TableItem[] tableItemArray = this.table.getSelection();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    this.selection.add(item.getData());
                    ++n2;
                }
            }
            this.updateDoneBtn();
        });
        this.createColumns();
    }

    private void updateDoneBtn() {
        this.btnDone.setEnabled(this.selection.size() > 0);
    }

    private void createColumns() {
        TableLayout layout = new TableLayout();
        int index = 0;
        while (index < this.fields.size()) {
            IProperty<?, ? super T> field = this.fields.get(index);
            TableColumn column = new TableColumn(this.table, 0);
            if (this.showHeaders) {
                column.setText(field.getName());
            }
            if (this.fields.size() > 1) {
                layout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, true));
            } else {
                layout.addColumnData((ColumnLayoutData)new ColumnWeightData(200, false));
            }
            final int indexF = index++;
            column.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DlgSelectSomething.this.sort(indexF);
                }
            });
        }
        this.table.setLayout((Layout)layout);
    }

    private void sort(int col) {
        this.sortDirection = this.sortCol == col ? (this.sortDirection == 1 ? 2 : 1) : 1;
        this.sortCol = col;
        this.table.setSortColumn(this.table.getColumns()[this.sortCol]);
        this.table.setSortDirection(this.sortDirection == 1 ? 128 : 1024);
        this.refresh();
    }

    private List<? extends T> sortElements(List<? extends T> elements) {
        if (elements.size() == 0) {
            return elements;
        }
        Collections.sort(elements, new Comparator<T>(){

            @Override
            public int compare(T element1, T element2) {
                IProperty field = DlgSelectSomething.this.fields.get(DlgSelectSomething.this.sortCol);
                return DlgSelectSomething.this.compareFieldValues(element1, element2, field);
            }
        });
        return elements;
    }

    private <U> String getFieldValueAsString(T element1, IProperty<U, ? super T> field) {
        return field.toString(field.getValue(element1));
    }

    private <U> int compareFieldValues(T element1, T element2, IProperty<U, ? super T> field) {
        if (this.sortDirection == 1) {
            return field.compareTo(field.getValue(element1), field.getValue(element2));
        }
        return field.compareTo(field.getValue(element2), field.getValue(element1));
    }

    public void refresh() {
        try {
            this.table.setRedraw(false);
            this.table.removeAll();
            this.table.deselectAll();
            for (T e : this.sortElements(this.getCurrentlyShownElements())) {
                TableItem item = new TableItem(this.table, 0);
                String[] text = new String[this.fields.size()];
                int i = 0;
                while (i < this.fields.size()) {
                    IProperty<?, ? super T> field = this.fields.get(i);
                    text[i] = this.getFieldValueAsString(e, field);
                    ++i;
                }
                item.setText(text);
                item.setData(e);
                item.setForeground(this.getForecolor(e));
                item.setBackground(this.getBackcolor(e));
            }
            if (this.withCheckBoxes) {
                TableItem[] tableItemArray = this.table.getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    boolean selected = this.selection.contains(item.getData());
                    item.setChecked(selected);
                    ++n2;
                }
            } else {
                ArrayList<TableItem> sel = new ArrayList<TableItem>();
                TableItem[] tableItemArray = this.table.getItems();
                int n = tableItemArray.length;
                int n3 = 0;
                while (n3 < n) {
                    TableItem item = tableItemArray[n3];
                    if (this.selection.contains(item.getData())) {
                        sel.add(item);
                    }
                    ++n3;
                }
                this.table.setSelection(sel.toArray(new TableItem[sel.size()]));
            }
            this.updateAllSelectedBtn();
        }
        finally {
            this.table.setRedraw(true);
        }
        this.updateDoneBtn();
    }

    private void updateAllSelectedBtn() {
        if (this.withCheckBoxes && this.btnSelectAll != null) {
            boolean allSelected = true;
            boolean isEmpty = true;
            for (T e : this.sortElements(this.getCurrentlyShownElements())) {
                isEmpty = false;
                boolean selected = this.selection.contains(e);
                if (selected) continue;
                allSelected = false;
            }
            this.btnSelectAll.setSelection(allSelected && !isEmpty);
        }
    }

    private List<T> getCurrentlyShownElements() {
        ArrayList<T> res = new ArrayList<T>();
        for (T e : this.elements) {
            boolean toShow = true;
            for (IFilter<? super T> iFilter : this.filters) {
                if (iFilter.accept(e)) continue;
                toShow = false;
                break;
            }
            if (!toShow) continue;
            res.add(e);
        }
        return res;
    }

    protected Color getForecolor(T e) {
        return null;
    }

    protected Color getBackcolor(T e) {
        return null;
    }

    public Selection<T> getSelection() {
        return this.selection;
    }

    public List<T> getSelectedElements() {
        return this.selection.getElements();
    }

    public boolean prepareDone() {
        return this.selection.size() > 0;
    }

    public void setSelection(List<? extends T> elements) {
        this.selection.clear();
        if (elements != null) {
            this.selection = new Selection(elements);
        }
    }

    public void enableFilter(boolean value) {
        this.filterEnabled = value;
    }
}

