/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.extra.field;

import net.edgemind.ibee.swt.core.field.FieldData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class HyperlinkField<T>
extends FieldData<T> {
    private IHyperlinkClicked<T> callBack;
    private int horizontalAlignment;

    public HyperlinkField(String key, String label, T defaultValue, IHyperlinkClicked<T> callBack) {
        super(key, label, defaultValue);
        this.callBack = callBack;
        this.setButtonHorizontalAlignment(16384);
    }

    public void setButtonHorizontalAlignment(int horizontalAlignment) {
        if (horizontalAlignment == 16384 || horizontalAlignment == 131072 || horizontalAlignment == 0x1000000) {
            this.horizontalAlignment = horizontalAlignment;
            this.setFieldLayout(new GridData(this.horizontalAlignment, 0x1000000, true, true, 0, 0));
        }
    }

    public Control createContents(Composite parent) {
        Composite subC = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        subC.setLayoutData((Object)gridData);
        subC.setLayout((Layout)new GridLayout());
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        Hyperlink linkConfigure = toolkit.createHyperlink(subC, this.mLabel, 0);
        linkConfigure.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                HyperlinkField.this.setValue(HyperlinkField.this.callBack.getValue(HyperlinkField.this));
            }
        });
        return linkConfigure;
    }

    public void updateUi() {
    }

    public static interface IHyperlinkClicked<T> {
        public T getValue(FieldData<T> var1);
    }
}

