/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.extra.widgets;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.edgemind.ibee.core.util.Selection;
import net.edgemind.ibee.swt.core.app.SwtWidget;
import net.edgemind.ibee.ui.column.Column;
import net.edgemind.ibee.ui.column.ISorter;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class ListWidget<T>
extends SwtWidget {
    private Table swtTable;
    private Selection<T> selection = new Selection();
    private List<T> elements = new ArrayList<T>();
    private Map<String, List<T>> multiList = null;
    private String multiListCategory = null;
    private int sortCol = 1;
    private int sortDirection = 1;
    private List<Column<T>> fields = null;

    public void setElements(List<T> elements) {
        if (elements == null) {
            this.elements = null;
            return;
        }
        this.elements = elements;
    }

    public void setMultiCategory(String category) {
        this.multiListCategory = category;
    }

    public void setMultiList(Map<String, List<T>> multiList) {
        if (multiList == null) {
            this.multiList = null;
            return;
        }
        this.multiList = multiList;
    }

    public void addMultiList(List<T> elements, String category) {
        if (this.multiList == null) {
            this.multiList = new LinkedHashMap<String, List<T>>();
        }
        this.multiList.put(category, elements);
    }

    public void setFields(List<Column<T>> fields) {
        this.fields = fields;
    }

    public void createContents(Composite parent) {
        this.createFilter(parent);
        this.createTable(parent);
        this.refresh();
        if (this.selection != null) {
            ArrayList<TableItem> selItems = new ArrayList<TableItem>();
            TableItem[] tableItemArray = this.swtTable.getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                Object el = item.getData();
                if (this.selection.contains(el)) {
                    selItems.add(item);
                }
                ++n2;
            }
            if (selItems.size() > 0) {
                this.swtTable.setSelection(selItems.toArray(new TableItem[selItems.size()]));
                this.swtTable.showSelection();
            }
        }
    }

    private void createFilter(Composite parent) {
        if (this.multiList != null) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout(1, false));
            composite.setLayoutData((Object)new GridData(768));
            final Combo cmbCategory = new Combo(composite, 8);
            for (String category : this.multiList.keySet()) {
                cmbCategory.add(category);
            }
            cmbCategory.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ListWidget.this.elements = ListWidget.this.multiList.get(cmbCategory.getText());
                    ListWidget.this.refresh();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            if (this.multiListCategory != null && this.multiList.containsKey(this.multiListCategory)) {
                this.elements = this.multiList.get(this.multiListCategory);
                cmbCategory.setText(this.multiListCategory);
            } else {
                cmbCategory.select(0);
                this.elements = this.multiList.get(cmbCategory.getText());
            }
        }
    }

    private void createTable(Composite parent) {
        this.swtTable = new Table(parent, 66050);
        GridData data = new GridData(1808);
        data.minimumWidth = 600;
        data.minimumHeight = 200;
        this.swtTable.setLayoutData((Object)data);
        this.swtTable.setHeaderVisible(true);
        this.createColumns();
    }

    public Table getSwtTable() {
        return this.swtTable;
    }

    private void createColumns() {
        TableLayout layout = new TableLayout();
        int index = 0;
        while (index < this.fields.size()) {
            Column<T> field = this.fields.get(index);
            TableColumn column = new TableColumn(this.swtTable, 0);
            column.setText(field.getTitle());
            layout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, true));
            final int indexF = index++;
            column.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ListWidget.this.sort(indexF);
                }
            });
        }
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, true));
        this.swtTable.setLayout((Layout)layout);
    }

    private void sort(int col) {
        this.sortDirection = this.sortCol == col ? (this.sortDirection == 1 ? 2 : 1) : 1;
        this.sortCol = col;
        this.swtTable.setSortColumn(this.swtTable.getColumns()[this.sortCol]);
        this.swtTable.setSortDirection(this.sortDirection == 1 ? 128 : 1024);
        this.refresh();
    }

    private void sortElements(List<? extends T> elements) {
        if (elements == null || elements.size() == 0) {
            return;
        }
        Column<T> field = this.fields.get(this.sortCol);
        final ISorter sorter = field.getSorter();
        if (sorter != null) {
            Collections.sort(elements, new Comparator<T>(){

                @Override
                public int compare(T element1, T element2) {
                    if (ListWidget.this.sortDirection == 1) {
                        return sorter.compareEquals(element1, element2);
                    }
                    return sorter.compareEquals(element2, element1);
                }
            });
        }
    }

    public void refresh() {
        try {
            this.swtTable.setRedraw(false);
            this.swtTable.removeAll();
            this.swtTable.deselectAll();
            this.sortElements(this.elements);
            for (T e : this.elements) {
                TableItem item = new TableItem(this.swtTable, 0);
                String[] text = new String[this.fields.size()];
                int i = 0;
                while (i < this.fields.size()) {
                    Column<T> field = this.fields.get(i);
                    text[i] = field.getValue(e);
                    ++i;
                }
                item.setText(text);
                item.setData(e);
            }
        }
        finally {
            this.swtTable.setRedraw(true);
        }
    }

    public Selection<T> getSelection() {
        TableItem[] items;
        this.selection.clear();
        TableItem[] tableItemArray = items = this.swtTable.getSelection();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            this.selection.add(item.getData());
            ++n2;
        }
        return this.selection;
    }

    public void setSelection(List<T> elements) {
        this.selection = new Selection(elements);
    }
}

