/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.extra.widgets;

import java.util.Iterator;
import java.util.List;
import net.edgemind.ibee.core.command.CommandStack;
import net.edgemind.ibee.core.command.IUndoRedoCommand;
import net.edgemind.ibee.core.exception.IbeeException;
import net.edgemind.ibee.core.iml.domain.IAttributeFeature;
import net.edgemind.ibee.core.iml.domain.IEnumType;
import net.edgemind.ibee.core.iml.domain.types.BooleanType;
import net.edgemind.ibee.core.iml.domain.types.IntegerType;
import net.edgemind.ibee.core.iml.domain.types.StringType;
import net.edgemind.ibee.core.iml.model.IElement;
import net.edgemind.ibee.core.resource.edit.RecordCommand;
import net.edgemind.ibee.swt.core.app.SwtWidget;
import net.edgemind.ibee.swt.core.util.SwtUtil;
import net.edgemind.ibee.util.string.StringUtil;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class PropertyWidget
extends SwtWidget {
    final int EDITABLECOLUMN = 1;
    private TableViewer viewer;
    private TableEditor editor;
    private IElement element;
    private IItemProvider itemProvider;
    private boolean editAble = false;
    private CommandStack cmdStack;

    public PropertyWidget(CommandStack cmdStack) {
        this.cmdStack = cmdStack;
    }

    public void setEditAble(boolean value) {
        this.editAble = value;
    }

    public Item createItem() {
        return new Item();
    }

    public void setItemProvider(IItemProvider provider) {
        this.itemProvider = provider;
    }

    public Composite createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        TableColumnLayout treeColumnLayout = new TableColumnLayout();
        composite.setLayout((Layout)treeColumnLayout);
        this.viewer = new TableViewer(composite, 65536);
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.getTable().setLinesVisible(true);
        data = new GridData(1808);
        this.viewer.getTable().setLayoutData((Object)data);
        super.createContextMenu((Control)this.viewer.getTable());
        this.viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object e) {
                if (PropertyWidget.this.element == null) {
                    return new Object[0];
                }
                if (PropertyWidget.this.itemProvider != null) {
                    return PropertyWidget.this.itemProvider.getItems(PropertyWidget.this.element).toArray();
                }
                return new Object[0];
            }
        });
        TableViewerColumn column = this.createTableViewerColumn("Property", 150, 0);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((Item)element).getName();
            }

            public Color getForeground(Object object) {
                Item item = (Item)object;
                return item.itemController.getForeColor(PropertyWidget.this.viewer, item);
            }
        });
        treeColumnLayout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(1));
        column = this.createTableViewerColumn("Value", 150, 1);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object object) {
                Item item = (Item)object;
                return item.getValue();
            }

            public Color getForeground(Object object) {
                Item item = (Item)object;
                return item.itemController.getForeColor(PropertyWidget.this.viewer, item);
            }
        });
        treeColumnLayout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(1));
        this.editor = new TableEditor(this.viewer.getTable());
        this.editor.horizontalAlignment = 16384;
        this.editor.grabHorizontal = true;
        this.editor.minimumWidth = 50;
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TableItem item;
                if (!PropertyWidget.this.editAble) {
                    return;
                }
                Control oldEditor = PropertyWidget.this.editor.getEditor();
                if (oldEditor != null) {
                    oldEditor.dispose();
                }
                if ((item = PropertyWidget.this.viewer.getTable().getItem(PropertyWidget.this.viewer.getTable().getSelectionIndex())) == null) {
                    return;
                }
                final Item content = PropertyWidget.this.getSelectedItem();
                final Control editorUi = PropertyWidget.this.openEditor(PropertyWidget.this.viewer, content);
                if (editorUi == null) {
                    return;
                }
                editorUi.setFocus();
                editorUi.addFocusListener(new FocusListener(){

                    public void focusLost(FocusEvent e) {
                        if (editorUi.isDisposed()) {
                            return;
                        }
                        PropertyWidget.this.closeEditor(content, true);
                    }

                    public void focusGained(FocusEvent e) {
                    }
                });
                editorUi.addKeyListener(new KeyListener(){

                    public void keyReleased(KeyEvent e) {
                    }

                    public void keyPressed(KeyEvent e) {
                        if (e.keyCode == 13) {
                            PropertyWidget.this.closeEditor(content, true);
                        }
                        if (e.keyCode == 27) {
                            PropertyWidget.this.closeEditor(content, false);
                        }
                    }
                });
                PropertyWidget.this.editor.setEditor(editorUi, item, 1);
            }
        });
        this.refresh();
        return composite;
    }

    private Control openEditor(TableViewer viewer, Item item) {
        Control editorUi = item.itemController.edit(viewer, item);
        if (editorUi == null && item.feature != null) {
            if (item.feature.getType() instanceof IEnumType) {
                Combo cmb = new Combo((Composite)viewer.getTable(), 8);
                for (Object option : ((IEnumType)item.feature.getType()).getEnums()) {
                    String optionAsString = ((IEnumType)item.feature.getType()).toString(option);
                    cmb.add(optionAsString);
                }
                editorUi = cmb;
            } else if (item.feature.getType() instanceof BooleanType) {
                Combo cmb = new Combo((Composite)viewer.getTable(), 8);
                cmb.add(Boolean.TRUE.toString());
                cmb.add(Boolean.FALSE.toString());
                cmb.setText(item.getValue());
                editorUi = cmb;
            } else if (item.feature.getType() instanceof StringType) {
                Text newEditor = new Text((Composite)viewer.getTable(), 0);
                newEditor.setText(item.getValue());
                newEditor.selectAll();
                editorUi = newEditor;
            } else if (item.feature.getType() instanceof IntegerType) {
                Spinner newEditor = new Spinner((Composite)viewer.getTable(), 0);
                newEditor.setMinimum(Integer.MIN_VALUE);
                newEditor.setMaximum(Integer.MAX_VALUE);
                int value = StringUtil.toInt((String)item.getValue(), (Integer)0);
                newEditor.setSelection(value);
                editorUi = newEditor;
            }
        }
        return editorUi;
    }

    private String getEditorValue(TableEditor editor) {
        Control uiControl = editor.getEditor();
        if (uiControl == null) {
            return null;
        }
        if (uiControl instanceof Text) {
            return ((Text)uiControl).getText();
        }
        if (uiControl instanceof Combo) {
            return ((Combo)uiControl).getText();
        }
        if (uiControl instanceof Spinner) {
            return "" + ((Spinner)uiControl).getSelection();
        }
        return null;
    }

    private void closeEditor(final Item item, final boolean commit) {
        Control editorUi;
        try {
            if (this.editor == null || this.editor.getEditor() == null) {
                return;
            }
            final IElement element = item.getElement();
            Control uiControl = this.editor.getEditor();
            if (uiControl == null) {
                return;
            }
            final String newValue = this.getEditorValue(this.editor);
            if (commit && newValue != null && !newValue.equals(item.getValue())) {
                this.cmdStack.executeWithoutError((IUndoRedoCommand)new RecordCommand(element.giGetResource(), "Set Attribute " + item.feature.getName() + ": " + newValue){

                    protected void executeRecorded() {
                        if (commit) {
                            PropertyWidget.this.setAttribute(element, item.feature, newValue);
                        }
                    }
                });
                if (commit) {
                    this.editor.getItem().setText(1, newValue);
                }
            }
        }
        catch (IbeeException e1) {
            Control editorUi2 = this.editor.getEditor();
            if (editorUi2 != null) {
                editorUi2.dispose();
                this.editor.setEditor(null);
            }
            String oldValue = item.getValue();
            this.editor.getItem().setText(1, oldValue);
            SwtUtil.showError((Throwable)e1, (Shell)this.viewer.getTable().getShell());
        }
        if ((editorUi = this.editor.getEditor()) != null) {
            editorUi.dispose();
            this.editor.setEditor(null);
        }
    }

    protected void setAttribute(IElement element, IAttributeFeature feature, String value) {
        element.giSetAttribute(feature, value);
    }

    protected String getAttribute(IElement element, IAttributeFeature feature) {
        return element.giGetAttribute(feature);
    }

    private TableViewerColumn createTableViewerColumn(String header, int width, int idx) {
        TableViewerColumn column = new TableViewerColumn(this.viewer, 16384, idx);
        column.getColumn().setText(header);
        column.getColumn().setWidth(width);
        column.getColumn().setResizable(true);
        column.getColumn().setMoveable(true);
        return column;
    }

    public void refresh() {
        this.viewer.setInput((Object)this.element);
        this.viewer.refresh();
    }

    public void setElement(IElement element) {
        Control oldEditor;
        if (this.editor != null && (oldEditor = this.editor.getEditor()) != null) {
            oldEditor.dispose();
        }
        this.element = element;
    }

    public Item getSelectedItem() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        Iterator it = selection.iterator();
        if (it.hasNext()) {
            return (Item)it.next();
        }
        return null;
    }

    public static interface IItemProvider {
        public List<Item> getItems(IElement var1);
    }

    public class Item {
        public String name;
        public ItemController itemController = new ItemController();
        public IElement element;
        public IAttributeFeature feature;

        public String getName() {
            if (this.name != null) {
                return this.name;
            }
            if (this.feature != null) {
                return this.feature.getName();
            }
            return "?";
        }

        public String getValue() {
            String value = this.itemController.getItemValue(PropertyWidget.this.viewer, this);
            if (value == null && this.feature != null) {
                IElement element = this.getElement();
                value = PropertyWidget.this.getAttribute(element, this.feature);
            }
            if (value == null) {
                value = "";
            }
            return value;
        }

        public IElement getElement() {
            if (this.element != null) {
                return this.element;
            }
            return PropertyWidget.this.element;
        }
    }

    public static class ItemController {
        public String getItemValue(TableViewer viewer, Item item) {
            return null;
        }

        public Control edit(TableViewer viewer, Item item) {
            return null;
        }

        public Color getForeColor(TableViewer viewer, Item item) {
            return null;
        }
    }
}

