/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.swt.extra.property;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.edgemind.ibee.core.property.IProperty;
import net.edgemind.ibee.swt.core.dialog.ADialog;
import net.edgemind.ibee.swt.core.image.ImageUtil;
import net.edgemind.ibee.util.misc.IFilter;
import net.edgemind.ibee.util.string.PatternUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SwtPropertyFilter {
    String filterColumn;
    protected Combo filterCombo;
    protected Text filterText;
    protected Text filterSummary;
    private Map<String, String> currentFilterMap = new HashMap<String, String>();

    public <U> void createFilter(Composite parent, final ADialog dlg, List<IProperty<?, ? super U>> fields, List<IFilter<? super U>> filters) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(6, false);
        layout.horizontalSpacing = 5;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(768);
        composite.setLayoutData((Object)data);
        Image img = ImageUtil.getBitmapImage((String)"/img/icon_filter16x16.png", SwtPropertyFilter.class);
        Label btn = new Label(composite, 0);
        btn.setImage(img);
        this.filterCombo = new Combo(composite, 2060);
        for (IProperty<?, U> iProperty : fields) {
            this.filterCombo.add(iProperty.getName());
        }
        this.filterCombo.select(0);
        this.filterColumn = this.filterCombo.getItem(0);
        this.filterText = new Text(composite, 2048);
        data = new GridData(1);
        data.widthHint = 150;
        this.filterText.setLayoutData((Object)data);
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = SwtPropertyFilter.this.filterText.getText();
                if (text != null && text.length() > 0) {
                    SwtPropertyFilter.this.currentFilterMap.put(SwtPropertyFilter.this.filterColumn, text);
                } else if (SwtPropertyFilter.this.currentFilterMap.containsKey(SwtPropertyFilter.this.filterColumn)) {
                    SwtPropertyFilter.this.currentFilterMap.remove(SwtPropertyFilter.this.filterColumn);
                }
                SwtPropertyFilter.this.refreshFilterSummary();
                dlg.refresh();
            }
        });
        this.filterCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SwtPropertyFilter.this.filterColumn = SwtPropertyFilter.this.filterCombo.getItem(SwtPropertyFilter.this.filterCombo.getSelectionIndex());
                SwtPropertyFilter.this.refreshFilter();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        new Label(composite, 0).setText("Summary:");
        this.filterSummary = new Text(composite, 8);
        this.filterSummary.setBackground(new Color((Device)parent.getShell().getDisplay(), 230, 230, 230));
        data = new GridData(768);
        this.filterSummary.setLayoutData((Object)data);
        Button button = new Button(composite, 0);
        button.setImage(ImageUtil.getBitmapImage((String)"img/reset.png", SwtPropertyFilter.class));
        button.setToolTipText("Clear Filter");
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SwtPropertyFilter.this.currentFilterMap.clear();
                SwtPropertyFilter.this.refreshFilter();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        IFilter nameFilter = e -> {
            for (String key : this.currentFilterMap.keySet()) {
                String value;
                String text = this.currentFilterMap.get(key);
                IProperty colProvider = this.getFieldProperty(fields, key);
                if (colProvider == null || PatternUtil.wildCardMatch((String)(value = (String)colProvider.getValue(e)), (String)text)) continue;
                return false;
            }
            return true;
        };
        filters.add(nameFilter);
    }

    private void refreshFilter() {
        String text = "";
        if (this.currentFilterMap.containsKey(this.filterColumn)) {
            text = this.currentFilterMap.get(this.filterColumn);
        }
        this.filterText.setText(text);
        this.refreshFilterSummary();
    }

    private void refreshFilterSummary() {
        StringBuilder buf = new StringBuilder();
        for (String key : this.currentFilterMap.keySet()) {
            String pattern = this.currentFilterMap.get(key);
            if (pattern == null || pattern.trim().length() == 0) continue;
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append(key.toUpperCase());
            buf.append("=");
            buf.append("[");
            buf.append(pattern);
            buf.append("]");
        }
        this.filterSummary.setText(buf.toString());
    }

    public <U> IProperty<?, ? super U> getFieldProperty(List<IProperty<?, ? super U>> fields, String name) {
        for (IProperty<?, U> iProperty : fields) {
            if (!iProperty.getName().equalsIgnoreCase(name)) continue;
            return iProperty;
        }
        return null;
    }
}

