/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.ui.charts;

import java.util.ArrayList;
import java.util.List;
import net.edgemind.ibee.core.diagram.Color;
import net.edgemind.ibee.core.diagram.Diagram;
import net.edgemind.ibee.core.diagram.Edge;
import net.edgemind.ibee.core.diagram.Group;
import net.edgemind.ibee.core.diagram.IDiagramData;
import net.edgemind.ibee.core.diagram.Node;
import net.edgemind.ibee.core.diagram.Point;
import net.edgemind.ibee.core.diagram.Symbol;
import net.edgemind.ibee.core.diagram.Text;
import net.edgemind.ibee.core.diagram.primitives.PCircle;
import net.edgemind.ibee.core.diagram.primitives.Primitive;
import net.edgemind.ibee.ui.charts.AbstractChart;
import net.edgemind.ibee.ui.charts.OverlayPaintingContext;
import net.edgemind.ibee.ui.charts.XYChartElement;
import net.edgemind.ibee.ui.charts.axis.Axis;
import net.edgemind.ibee.ui.charts.axis.AxisDirection;
import net.edgemind.ibee.util.math.Frame;

public class LineChart
extends AbstractChart {
    private Frame diagramFrame;
    private int MARGIN_TEXT_UPPER = 0;
    private int MARGIN_TEXT_LOWER = 0;
    private int MARGIN_TEXT_LEFT = 0;
    private int MARGIN_TEXT_RIGHT = 0;
    private boolean vertical = false;
    private boolean showArrows = false;
    private boolean connectPoints = false;
    private boolean showBars = false;
    private Color lineColor = Color.RED;
    private Color blobColor = Color.EMORANGE;
    private Group overlayGroup;
    private OverlayPaintingContext overlayContext;
    private Group nodeGroup;
    private Axis xAxis;
    private Axis yAxis;
    private List<XYChartElement> elements = new ArrayList<XYChartElement>();

    public void addElement(XYChartElement element) {
        this.elements.add(element);
    }

    public void setVertical(boolean vertical) {
        this.vertical = vertical;
    }

    public boolean isVertical() {
        return this.vertical;
    }

    public void setShowBars(boolean value) {
        this.showBars = value;
    }

    public void setLineColor(Color color) {
        this.lineColor = color;
    }

    public void setBlobColor(Color color) {
        this.blobColor = color;
    }

    public void setShowArrows(boolean showArrows) {
        this.showArrows = showArrows;
    }

    public void setConnectPoints(boolean connectPoints) {
        this.connectPoints = connectPoints;
    }

    public Axis createXAxis() {
        this.xAxis = new Axis(AxisDirection.HORIZONTAL);
        return this.xAxis;
    }

    public Axis createYAxis() {
        this.yAxis = new Axis(AxisDirection.VERTICAL);
        return this.yAxis;
    }

    @Override
    public Diagram createDiagram() {
        double minTime = 0.0;
        double maxTime = 0.0;
        for (XYChartElement element : this.elements) {
            if (element.getXValue() < minTime) {
                minTime = element.getXValue();
            }
            if (!(element.getXValue() > maxTime)) continue;
            maxTime = element.getXValue();
        }
        double minValue = 0.0;
        double maxValue = 0.0;
        for (XYChartElement element : this.elements) {
            if (element.getYValue() < minValue) {
                minValue = element.getYValue();
            }
            if (!(element.getYValue() > maxValue)) continue;
            maxValue = element.getYValue();
        }
        this.calcDiagramFrame(minTime, maxTime, minValue, maxValue);
        Diagram diagram = this.getDiagramHorizontal(minTime, maxTime, minValue, maxValue);
        return diagram;
    }

    private void calcDiagramFrame(double minX, double maxX, double minY, double maxY) {
        this.diagramFrame = new Frame((double)(-this.MARGIN_TEXT_LEFT), -maxY - (double)this.MARGIN_TEXT_UPPER, maxX - minX + (double)this.MARGIN_TEXT_LEFT + (double)this.MARGIN_TEXT_RIGHT, maxY - minY + (double)this.MARGIN_TEXT_LOWER + (double)this.MARGIN_TEXT_UPPER);
    }

    private Diagram getDiagramHorizontal(double minX, double maxX, double minY, double maxY) {
        Diagram diagram = new Diagram();
        Group root = new Group();
        diagram.addGroup(root);
        this.nodeGroup = new Group();
        root.addGroup(this.nodeGroup);
        Group edgeGroup = new Group();
        root.addGroup(edgeGroup);
        double scaleX = 1.0;
        double scaleY = 1.0;
        double offsetX = 0.0;
        double offsetY = 0.0;
        double lastX = 0.0;
        double lastY = 0.0;
        boolean first = true;
        for (XYChartElement chartElement : this.elements) {
            double xValue = offsetX + (chartElement.getXValue() - minX) * scaleX;
            double yValue = offsetY - chartElement.getYValue() * scaleY;
            if (this.connectPoints) {
                if (first) {
                    first = false;
                } else {
                    Edge connectionEdge = new Edge();
                    edgeGroup.addEdge(connectionEdge);
                    connectionEdge.setForeColor(this.lineColor);
                    ArrayList<Point> points = new ArrayList<Point>();
                    points.add(new Point(lastX, lastY));
                    points.add(new Point(xValue, yValue));
                    connectionEdge.setPoints(points);
                    connectionEdge.doAntiScaleX(true);
                    connectionEdge.doAntiScaleY(true);
                }
                lastX = xValue;
                lastY = yValue;
            }
            this.createValueNode(xValue, yValue, chartElement);
        }
        diagram.setSize(this.diagramFrame);
        return diagram;
    }

    private void createValueNode(double xValue, double yValue, XYChartElement chartElement) {
        Node node = new Node();
        this.nodeGroup.addNode(node);
        node.setSymbol((Symbol)new LargeCircle());
        node.setForeColor(this.blobColor);
        node.setBackColor(this.blobColor);
        node.setX(xValue);
        node.setY(yValue);
        node.setWidth(14.0);
        node.setHeight(14.0);
        node.doAntiScaleX(true);
        node.doAntiScaleY(true);
        node.setData((IDiagramData)chartElement);
        node.setDeltaScreenX(-7.0);
        node.setDeltaScreenY(-7.0);
    }

    private void createAxisLines() {
        this.createHorizontalLine();
        this.createVerticalLine();
    }

    private void createHorizontalLine() {
        double leftX = this.diagramFrame.getX() - 1000.0;
        double rightX = this.diagramFrame.getX() + this.diagramFrame.getWidth();
        double bottomY = 0.0;
        Edge horizontalLine = new Edge();
        ArrayList<Point> points = new ArrayList<Point>();
        points.add(new Point(leftX, bottomY));
        points.add(new Point(rightX, bottomY));
        horizontalLine.setPoints(points);
        horizontalLine.setForeColor(Color.BLACK);
        horizontalLine.setLineWidth(2.0);
        horizontalLine.setArrowType(Edge.ArrowType.ARROW_TARGET);
        horizontalLine.doAntiScaleX(true);
        horizontalLine.doAntiScaleY(true);
        this.nodeGroup.addEdge(horizontalLine);
    }

    private void createVerticalLine() {
        double leftX = 0.0;
        double topY = this.diagramFrame.getY();
        double bottomY = topY + this.diagramFrame.getHeight();
        Edge verticalLine = new Edge();
        ArrayList<Point> points = new ArrayList<Point>();
        points.add(new Point(leftX, bottomY));
        points.add(new Point(leftX, topY));
        verticalLine.setPoints(points);
        verticalLine.setForeColor(Color.BLACK);
        verticalLine.setLineWidth(2.0);
        verticalLine.setArrowType(Edge.ArrowType.ARROW_TARGET);
        verticalLine.doAntiScaleX(true);
        verticalLine.doAntiScaleY(true);
        this.nodeGroup.addEdge(verticalLine);
    }

    protected void createTitleOverlay() {
        String title = super.getTitle();
        if (title == null) {
            return;
        }
        Text text = new Text();
        text.setX(this.overlayContext.getVisibleScreen().getX() + this.overlayContext.getVisibleScreen().getWidth() / 2.0);
        text.setY(this.overlayContext.getVisibleScreen().getY());
        text.setDeltaScreenY(15.0);
        text.doAntiScaleX(true);
        text.doAntiScaleY(true);
        text.setForeColor(Color.BLACK);
        text.setTextAlign(Text.TextAlign.CENTER);
        text.setText(title);
        text.setFontStyle(Text.FontStyle.ITALIC);
        text.setFontType(Text.FontType.OPENSANS);
        text.setTextSize(16.0);
        this.overlayGroup.addText(text);
    }

    protected void createXAxisOverlay() {
        if (this.xAxis == null) {
            return;
        }
        Group xAxisOverlay = this.xAxis.paintAxis(this.overlayContext);
        if (xAxisOverlay != null) {
            this.overlayGroup.addGroup(xAxisOverlay);
        }
    }

    protected void createYAxisOverlay() {
        if (this.yAxis == null) {
            return;
        }
        Group yAxisOverlay = this.yAxis.paintAxis(this.overlayContext);
        if (yAxisOverlay != null) {
            this.overlayGroup.addGroup(yAxisOverlay);
        }
    }

    private void createAxisOverlays() {
        this.createXAxisOverlay();
        this.createYAxisOverlay();
    }

    @Override
    public Group getChartOverlay(OverlayPaintingContext context) {
        this.overlayContext = context;
        this.overlayGroup = new Group();
        this.createTitleOverlay();
        this.createAxisOverlays();
        return this.overlayGroup;
    }

    public static class LargeCircle
    extends Symbol {
        private static final long serialVersionUID = 1L;

        public LargeCircle() {
            PCircle c = new PCircle(0.5, 0.5, 0.25);
            super.addPrimitive((Primitive)c);
        }
    }
}

