/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.ui.charts.formatter;

import net.edgemind.ibee.core.diagram.Color;
import net.edgemind.ibee.ui.charts.YChartElement;
import net.edgemind.ibee.ui.charts.formatter.IChartFormatter;

public class TransientColorFormatter
implements IChartFormatter {
    private double vYellow;
    private double vRed;
    private double vMin;
    private double vMax;

    public TransientColorFormatter(double vYellow, double vRed, double vMin, double vMax) {
        this.vRed = vRed;
        this.vYellow = vYellow;
        this.vMax = vMax;
        this.vMin = vMin;
    }

    @Override
    public Color getColor(YChartElement element) {
        double r = 255.0;
        double g = 0.0;
        double b = 0.0;
        double v = element.getYValue();
        if (v > this.vMax) {
            v = this.vMax;
        }
        if (v < this.vMin) {
            v = this.vMin;
        }
        if (!(v > this.vRed)) {
            if (v > this.vYellow) {
                g = 255.0 - (v - this.vYellow) / (this.vRed - this.vYellow) * 255.0;
            } else {
                g = 255.0;
                r = (v - this.vMin) / (this.vYellow - this.vMin) * 255.0;
            }
        }
        return new Color((int)r, (int)g, (int)b);
    }
}

