/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.ui.charts.viewer;

import net.edgemind.ibee.core.diagram.Color;
import net.edgemind.ibee.core.diagram.Diagram;
import net.edgemind.ibee.core.diagram.Group;
import net.edgemind.ibee.core.diagram.IDiagramData;
import net.edgemind.ibee.core.diagram.Node;
import net.edgemind.ibee.core.diagram.Point;
import net.edgemind.ibee.core.diagram.Text;
import net.edgemind.ibee.ui.charts.Chart;
import net.edgemind.ibee.ui.charts.OverlayPaintingContext;
import net.edgemind.ibee.ui.charts.XYChartElement;
import net.edgemind.ibee.ui.charts.YChartElement;
import net.edgemind.ibee.ui.common.listener.IMouseDownListener;
import net.edgemind.ibee.ui.common.listener.IMouseMoveListener;
import net.edgemind.ibee.ui.common.listener.IMouseUpListener;
import net.edgemind.ibee.ui.common.listener.IResizedListener;
import net.edgemind.ibee.ui.diagram.IDiagramPaintListener;
import net.edgemind.ibee.ui.diagram.MouseButton;
import net.edgemind.ibee.ui.diagram.viewer.IDiagramViewer;
import net.edgemind.ibee.util.math.Frame;
import net.edgemind.ibee.util.math.NumberUtil;

public class ChartViewer {
    private int MARGIN_DFAULT = 30;
    private Chart chart;
    private boolean down = false;
    private IDiagramViewer viewer;
    private Group chartElementOverlay;
    private Group axisOverlay;
    private Point zeroPoint = new Point();
    private Color overlayColor = Color.EMBLUE;

    public ChartViewer(IDiagramViewer viewer) {
        this.viewer = viewer;
        this.chartElementOverlay = new Group();
        this.axisOverlay = new Group();
        viewer.setMargin(this.MARGIN_DFAULT, this.MARGIN_DFAULT);
    }

    public void setOverlayColor(Color color) {
        this.overlayColor = color;
    }

    public void create() {
        this.viewer.create();
        this.viewer.getDiagramPanel().addOverlay(this.axisOverlay);
        this.viewer.getDiagramPanel().addOverlay(this.chartElementOverlay);
        this.viewer.getDiagramPanel().addResizedListener(new IResizedListener(){

            @Override
            public void resized(double width, double height) {
                ChartViewer.this.viewer.refresh();
            }
        });
        this.viewer.getDiagramPanel().addMouseDownListener(new IMouseDownListener(){

            @Override
            public void mouseDown(double x, double y, MouseButton btn) {
                if (ChartViewer.this.chart == null) {
                    return;
                }
                ChartViewer.this.down = true;
            }
        });
        this.viewer.getDiagramPanel().addMouseUpListener(new IMouseUpListener(){

            @Override
            public void mouseUp(double x, double y, MouseButton btn) {
                if (ChartViewer.this.chart == null) {
                    return;
                }
                ChartViewer.this.down = false;
            }
        });
        this.viewer.getDiagramPanel().addMouseMoveListener(new IMouseMoveListener(){

            @Override
            public void mouseMove(double x, double y) {
                if (ChartViewer.this.chart == null) {
                    ChartViewer.this.chartElementOverlay.clear();
                    return;
                }
                if (ChartViewer.this.down) {
                    return;
                }
                x = ChartViewer.this.viewer.getDiagramPanel().translateX(x);
                y = ChartViewer.this.viewer.getDiagramPanel().translateY(y);
                Node e = ChartViewer.getSelectedNode(ChartViewer.this.viewer.getDiagram(), x, y, ChartViewer.this.viewer.getDiagramPanel().getZoomX(), ChartViewer.this.viewer.getDiagramPanel().getZoomY());
                ChartViewer.this.chartElementOverlay.clear();
                if (e != null && e instanceof Node) {
                    Text text;
                    String s;
                    YChartElement chartElement;
                    IDiagramData data = e.getData();
                    Node marked = new Node();
                    Node node = e;
                    marked.setX(node.getX());
                    marked.setY(node.getY());
                    marked.setWidth(node.getWidth() + 4.0);
                    marked.setHeight(node.getHeight() + 4.0);
                    marked.doAntiScaleX(node.doAntiScaleX());
                    marked.doAntiScaleY(node.doAntiScaleY());
                    marked.setBackColor(ChartViewer.this.overlayColor);
                    marked.setForeColor(ChartViewer.this.overlayColor);
                    marked.setDeltaScreenX(node.getDeltaScreenX() - 3.0);
                    marked.setDeltaScreenY(node.getDeltaScreenY() - 3.0);
                    marked.setPositioning(node.getPositioning());
                    marked.setSymbol(node.getSymbol());
                    ChartViewer.this.chartElementOverlay.addNode(marked);
                    Group secondGroup = new Group();
                    ChartViewer.this.chartElementOverlay.addGroup(secondGroup);
                    if (data instanceof XYChartElement) {
                        chartElement = (XYChartElement)data;
                        s = "x: " + NumberUtil.roundTo2Decimals((double)((XYChartElement)chartElement).getXValue()) + " t.u";
                        text = new Text();
                        text.setX(x);
                        text.setY(y);
                        text.setTextSize(12.0);
                        text.setText(s);
                        text.setForeColor(Color.GRAY);
                        text.doAntiScaleX(true);
                        text.doAntiScaleY(true);
                        text.setDeltaScreenX(15.0);
                        text.setDeltaScreenY(5.0);
                        text.setFontStyle(Text.FontStyle.ITALIC);
                        text.setFontType(Text.FontType.OPENSANS);
                        secondGroup.addText(text);
                    }
                    if (data instanceof YChartElement) {
                        chartElement = (YChartElement)data;
                        s = "y: " + NumberUtil.roundTo2Decimals((double)chartElement.getYValue()) + "%";
                        text = new Text();
                        text.setX(x);
                        text.setY(y);
                        text.setTextSize(12.0);
                        text.setText(s);
                        text.setForeColor(Color.GRAY);
                        text.doAntiScaleX(true);
                        text.doAntiScaleY(true);
                        text.setDeltaScreenX(15.0);
                        text.setDeltaScreenY(25.0);
                        text.setFontStyle(Text.FontStyle.ITALIC);
                        text.setFontType(Text.FontType.OPENSANS);
                        secondGroup.addText(text);
                    }
                }
                ChartViewer.this.viewer.paintOverlay();
            }
        });
        this.viewer.getDiagramPanel().addDiagramPaintListener(new IDiagramPaintListener(){

            @Override
            public void repaintOverlayPre(Group overlay) {
                ChartViewer.this.axisOverlay.clear();
                if (ChartViewer.this.chart == null) {
                    return;
                }
                OverlayPaintingContext context = new OverlayPaintingContext();
                context.setVisibleScreen(ChartViewer.this.viewer.getDiagramPanel().getVisibleFrame());
                context.setViewer(ChartViewer.this.viewer);
                Group group = ChartViewer.this.chart.getChartOverlay(context);
                if (group != null) {
                    ChartViewer.this.axisOverlay.addGroup(group);
                }
            }

            @Override
            public void repaintOverlayPost(Group overlay) {
            }

            @Override
            public void repaintDiagramPre(Diagram diagram) {
            }

            @Override
            public void repaintDiagramPost(Diagram diagram) {
            }
        });
    }

    private Diagram createNoDataDiagram() {
        Diagram diagram = new Diagram();
        diagram.setSize(new Frame(0.0, 0.0, 100.0, 100.0));
        Group root = new Group();
        diagram.addGroup(root);
        Text text = new Text();
        root.addText(text);
        text.setText("No data");
        text.setTextAlign(Text.TextAlign.CENTER);
        text.doAntiScaleX(true);
        text.doAntiScaleY(true);
        text.setX(50.0);
        text.setY(50.0);
        text.setForeColor(Color.BLACK);
        return diagram;
    }

    public IDiagramViewer getViewer() {
        return this.viewer;
    }

    public Chart getChart() {
        return this.chart;
    }

    public void viewChart(Chart chart) {
        this.chart = chart;
        if (chart == null) {
            this.viewer.setDiagram(this.createNoDataDiagram());
            if (this.chartElementOverlay != null) {
                this.chartElementOverlay.clear();
            }
            this.viewer.refresh();
            return;
        }
        Diagram diagram = chart.createDiagram();
        this.viewer.setDiagram(diagram);
        this.viewer.refresh();
    }

    public static Node getSelectedNode(Diagram diagram, double x, double y, double zoomX, double zoomY) {
        Node selectedNode = null;
        if (diagram == null) {
            return null;
        }
        for (Group group : diagram.getGroups()) {
            Node test = ChartViewer.getSelectedNode(group, x, y, zoomX, zoomY);
            if (test == null) continue;
            return test;
        }
        return selectedNode;
    }

    public static Node getSelectedNode(Group group, double x, double y, double zoomX, double zoomY) {
        for (Node node : group.getNodes()) {
            double offsetX = node.getDeltaScreenX() / zoomX;
            if (!(x > node.getX() + offsetX) || !(x < node.getX() + offsetX + node.getWidth() / zoomX) || node.getElement() == null && node.getData() == null) continue;
            return node;
        }
        for (Group subGroup : group.getGroups()) {
            Node test = ChartViewer.getSelectedNode(subGroup, x, y, zoomX, zoomY);
            if (test == null) continue;
            return test;
        }
        return null;
    }
}

